/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.MPXResourceField;
import net.sf.mpxj.mpx.Record;

final class ResourceModel {
    private ProjectFile m_parentFile;
    private boolean[] m_flags = new boolean[52];
    private int[] m_fields = new int[53];
    private int m_count;
    private String[] m_resourceNames;
    private HashMap<String, Integer> m_resourceNumbers = new HashMap();

    ResourceModel(ProjectFile file, Locale locale) {
        this.m_parentFile = file;
        this.setLocale(locale);
    }

    void setLocale(Locale locale) {
        this.m_resourceNames = LocaleData.getStringArray(locale, "RESOURCE_NAMES");
        this.m_resourceNumbers.clear();
        for (int loop = 0; loop < this.m_resourceNames.length; ++loop) {
            String name = this.m_resourceNames[loop];
            if (name == null) continue;
            this.m_resourceNumbers.put(name, loop);
        }
    }

    public void update(Record record, boolean isText) throws MPXJException {
        int length = record.getLength();
        for (int i = 0; i < length; ++i) {
            if (isText) {
                this.add(this.getResourceCode(record.getString(i)));
                continue;
            }
            this.add(record.getInteger(i));
        }
    }

    public int[] getModel() {
        this.m_fields[this.m_count] = -1;
        return this.m_fields;
    }

    private void populateModel() {
        if (this.m_count != 0) {
            this.m_count = 0;
            Arrays.fill(this.m_flags, false);
        }
        for (Resource resource : this.m_parentFile.getAllResources()) {
            for (int loop = 0; loop < 52; ++loop) {
                if (resource.getCachedValue(MPXResourceField.getMpxjField(loop)) == null || this.m_flags[loop]) continue;
                this.m_flags[loop] = true;
                this.m_fields[this.m_count] = loop;
                ++this.m_count;
            }
        }
        Arrays.sort(this.m_fields);
        System.arraycopy(this.m_fields, this.m_fields.length - this.m_count, this.m_fields, 0, this.m_count);
    }

    public String toString() {
        this.populateModel();
        char delimiter = this.m_parentFile.getDelimiter();
        StringBuffer textual = new StringBuffer();
        StringBuffer numeric = new StringBuffer();
        textual.append(40);
        numeric.append(41);
        for (int loop = 0; loop < this.m_count; ++loop) {
            int number = this.m_fields[loop];
            textual.append(delimiter);
            numeric.append(delimiter);
            textual.append(this.getResourceField(number));
            numeric.append(number);
        }
        textual.append("\r\n");
        numeric.append("\r\n");
        textual.append(numeric.toString());
        return textual.toString();
    }

    private void add(int field) {
        if (field < this.m_flags.length && !this.m_flags[field]) {
            this.m_flags[field] = true;
            this.m_fields[this.m_count] = field;
            ++this.m_count;
        }
    }

    private String getResourceField(int key) {
        String result = null;
        if (key > 0 && key < this.m_resourceNames.length) {
            result = this.m_resourceNames[key];
        }
        return result;
    }

    private int getResourceCode(String field) throws MPXJException {
        Integer result = this.m_resourceNumbers.get(field);
        if (result == null) {
            throw new MPXJException("Invalid resource field name " + field);
        }
        return result;
    }
}

