/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedResourceAssignment;
import net.sf.mpxj.mpp.MPPUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TimephasedResourceAssignmentFactory {
    TimephasedResourceAssignmentFactory() {
    }

    public List<TimephasedResourceAssignment> getCompleteWork(ProjectCalendar calendar, Date startDate, byte[] data) {
        LinkedList<TimephasedResourceAssignment> list = new LinkedList<TimephasedResourceAssignment>();
        if (data != null) {
            double time;
            int blockCount = MPPUtility.getShort(data, 0);
            double previousCumulativeWork = 0.0;
            TimephasedResourceAssignment previousAssignment = null;
            int index = 32;
            for (int currentBlock = 0; currentBlock < blockCount && index + 20 <= data.length; ++currentBlock) {
                time = MPPUtility.getInt(data, index + 0);
                Duration startWork = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                double currentCumulativeWork = (long)MPPUtility.getDouble(data, index + 4);
                double assignmentDuration = currentCumulativeWork - previousCumulativeWork;
                previousCumulativeWork = currentCumulativeWork;
                Duration totalWork = Duration.getInstance(assignmentDuration /= 1000.0, TimeUnit.MINUTES);
                time = (long)MPPUtility.getDouble(data, index + 12);
                time /= 125.0;
                Duration workPerDay = Duration.getInstance(time *= 6.0, TimeUnit.MINUTES);
                Date start = startWork.getDuration() == 0.0 ? startDate : calendar.getDate(startDate, startWork, true);
                TimephasedResourceAssignment assignment = new TimephasedResourceAssignment();
                assignment.setStart(start);
                assignment.setWorkPerDay(workPerDay);
                assignment.setTotalWork(totalWork);
                if (previousAssignment != null) {
                    Date finish = calendar.getDate(startDate, startWork, false);
                    previousAssignment.setFinish(finish);
                    if (previousAssignment.getStart().getTime() == previousAssignment.getFinish().getTime()) {
                        list.removeLast();
                    }
                }
                list.add(assignment);
                previousAssignment = assignment;
                index += 20;
            }
            if (previousAssignment != null) {
                time = MPPUtility.getInt(data, 24);
                Duration finishWork = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                Date finish = calendar.getDate(startDate, finishWork, false);
                previousAssignment.setFinish(finish);
                if (previousAssignment.getStart().getTime() == previousAssignment.getFinish().getTime()) {
                    list.removeLast();
                }
            }
        }
        return list;
    }

    public List<TimephasedResourceAssignment> getPlannedWork(ProjectCalendar calendar, Date startDate, double units, byte[] data, List<TimephasedResourceAssignment> timephasedComplete) {
        LinkedList<TimephasedResourceAssignment> list = new LinkedList<TimephasedResourceAssignment>();
        if (data != null) {
            int blockCount = MPPUtility.getShort(data, 0);
            if (blockCount == 0) {
                if (!timephasedComplete.isEmpty()) {
                    TimephasedResourceAssignment lastComplete = timephasedComplete.get(timephasedComplete.size() - 1);
                    Date startWork = calendar.getNextWorkStart(lastComplete.getFinish());
                    double time = MPPUtility.getDouble(data, 16);
                    Duration totalWork = Duration.getInstance(time /= 1000.0, TimeUnit.MINUTES);
                    Duration adjustedTotalWork = Duration.getInstance(time * 100.0 / units, TimeUnit.MINUTES);
                    Date finish = calendar.getDate(startWork, adjustedTotalWork, false);
                    time = MPPUtility.getDouble(data, 8);
                    time /= 2000.0;
                    Duration workPerDay = Duration.getInstance(time *= 6.0, TimeUnit.MINUTES);
                    TimephasedResourceAssignment assignment = new TimephasedResourceAssignment();
                    assignment.setStart(startWork);
                    assignment.setWorkPerDay(workPerDay);
                    assignment.setModified(false);
                    assignment.setFinish(finish);
                    assignment.setTotalWork(totalWork);
                    if (assignment.getStart().getTime() != assignment.getFinish().getTime()) {
                        list.add(assignment);
                    }
                }
            } else {
                Duration blockDuration;
                double time;
                Date offset = startDate;
                if (!timephasedComplete.isEmpty()) {
                    TimephasedResourceAssignment lastComplete = timephasedComplete.get(timephasedComplete.size() - 1);
                    offset = lastComplete.getFinish();
                }
                int index = 40;
                double previousCumulativeWork = 0.0;
                TimephasedResourceAssignment previousAssignment = null;
                for (int currentBlock = 0; currentBlock < blockCount && index + 28 <= data.length; ++currentBlock) {
                    time = MPPUtility.getInt(data, index);
                    blockDuration = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                    Date start = blockDuration.getDuration() == 0.0 ? offset : calendar.getDate(offset, blockDuration, true);
                    double currentCumulativeWork = MPPUtility.getDouble(data, index + 4);
                    double assignmentDuration = currentCumulativeWork - previousCumulativeWork;
                    Duration totalWork = Duration.getInstance(assignmentDuration /= 1000.0, TimeUnit.MINUTES);
                    previousCumulativeWork = currentCumulativeWork;
                    time = MPPUtility.getDouble(data, index + 12);
                    time /= 2000.0;
                    Duration workPerDay = Duration.getInstance(time *= 6.0, TimeUnit.MINUTES);
                    int modifiedFlag = MPPUtility.getShort(data, index + 22);
                    boolean modified = modifiedFlag == 0 && currentBlock != 0 || (modifiedFlag & 0x3000) != 0;
                    TimephasedResourceAssignment assignment = new TimephasedResourceAssignment();
                    assignment.setStart(start);
                    assignment.setWorkPerDay(workPerDay);
                    assignment.setModified(modified);
                    assignment.setTotalWork(totalWork);
                    if (previousAssignment != null) {
                        Date finish = calendar.getDate(offset, blockDuration, false);
                        previousAssignment.setFinish(finish);
                        if (previousAssignment.getStart().getTime() == previousAssignment.getFinish().getTime()) {
                            list.removeLast();
                        }
                    }
                    list.add(assignment);
                    previousAssignment = assignment;
                    index += 28;
                }
                if (previousAssignment != null) {
                    time = MPPUtility.getInt(data, 24);
                    blockDuration = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                    Date finish = calendar.getDate(offset, blockDuration, false);
                    previousAssignment.setFinish(finish);
                    if (previousAssignment.getStart().getTime() == previousAssignment.getFinish().getTime()) {
                        list.removeLast();
                    }
                }
            }
        }
        return list;
    }

    public boolean getWorkModified(List<TimephasedResourceAssignment> list) {
        TimephasedResourceAssignment assignment;
        boolean result = false;
        Iterator<TimephasedResourceAssignment> i$ = list.iterator();
        while (i$.hasNext() && !(result = (assignment = i$.next()).getModified())) {
        }
        return result;
    }
}

