/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.AbstractTimephasedResourceAssignmentNormaliser;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedResourceAssignment;
import net.sf.mpxj.utility.DateUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPPTimephasedResourceAssignmentNormaliser
extends AbstractTimephasedResourceAssignmentNormaliser {
    private static final double EQUALITY_DELTA = 0.1;

    @Override
    public void normalise(ProjectCalendar calendar, LinkedList<TimephasedResourceAssignment> list) {
        if (!list.isEmpty()) {
            this.splitDays(calendar, list);
            this.mergeSameDay(calendar, list);
            this.mergeSameWork(list);
            this.convertToHours(list);
        }
    }

    private void splitDays(ProjectCalendar calendar, LinkedList<TimephasedResourceAssignment> list) {
        LinkedList<TimephasedResourceAssignment> result = new LinkedList<TimephasedResourceAssignment>();
        boolean remainderInserted = false;
        Calendar cal = Calendar.getInstance();
        block0: for (TimephasedResourceAssignment assignment : list) {
            if (remainderInserted) {
                cal.setTime(assignment.getStart());
                cal.add(6, 1);
                assignment.setStart(cal.getTime());
                remainderInserted = false;
            }
            while (assignment != null) {
                Date startDay = DateUtility.getDayStartDate(assignment.getStart());
                Date finishDay = DateUtility.getDayStartDate(assignment.getFinish());
                if (assignment.getFinish().getTime() == finishDay.getTime()) {
                    cal.setTime(finishDay);
                    cal.add(6, -1);
                    finishDay = cal.getTime();
                }
                if (startDay.getTime() == finishDay.getTime()) {
                    Duration totalWork = assignment.getTotalWork();
                    Duration assignmentWork = this.getAssignmentWork(calendar, assignment);
                    if (totalWork.getDuration() - assignmentWork.getDuration() > 0.1) {
                        assignment.setTotalWork(assignmentWork);
                        result.add(assignment);
                        Duration remainingWork = Duration.getInstance(totalWork.getDuration() - assignmentWork.getDuration(), TimeUnit.MINUTES);
                        cal.setTime(finishDay);
                        cal.add(6, 1);
                        Date remainderStart = cal.getTime();
                        cal.add(6, 1);
                        Date remainderFinish = cal.getTime();
                        TimephasedResourceAssignment remainder = new TimephasedResourceAssignment();
                        remainder.setStart(remainderStart);
                        remainder.setFinish(remainderFinish);
                        remainder.setTotalWork(remainingWork);
                        result.add(remainder);
                        remainderInserted = true;
                        continue block0;
                    }
                    result.add(assignment);
                    continue block0;
                }
                TimephasedResourceAssignment[] split = this.splitFirstDay(calendar, assignment);
                if (split[0] != null) {
                    result.add(split[0]);
                }
                assignment = split[1];
            }
        }
        list.clear();
        list.addAll(result);
    }

    private TimephasedResourceAssignment[] splitFirstDay(ProjectCalendar calendar, TimephasedResourceAssignment assignment) {
        TimephasedResourceAssignment[] result = new TimephasedResourceAssignment[2];
        Date assignmentStart = assignment.getStart();
        Date assignmentFinish = assignment.getFinish();
        Duration calendarWork = calendar.getWork(assignmentStart, assignmentFinish, TimeUnit.MINUTES);
        Duration assignmentWork = assignment.getTotalWork();
        if (calendarWork.getDuration() != 0.0) {
            TimephasedResourceAssignment split;
            double splitMinutes;
            Date splitFinish;
            Date splitStart;
            if (calendar.isWorkingDate(assignmentStart)) {
                Duration splitWork;
                splitStart = assignmentStart;
                Date splitFinishTime = calendar.getFinishTime(splitStart);
                splitFinish = DateUtility.setTime(splitStart, splitFinishTime);
                Duration calendarSplitWork = calendar.getWork(splitStart, splitFinish, TimeUnit.MINUTES);
                Duration calendarWorkPerDay = calendar.getWork(splitStart, TimeUnit.MINUTES);
                Duration assignmentWorkPerDay = assignment.getWorkPerDay();
                if (calendarSplitWork.getDuration() == calendarWorkPerDay.getDuration()) {
                    if (calendarSplitWork.getDuration() == assignmentWorkPerDay.getDuration()) {
                        splitWork = assignmentWorkPerDay;
                        splitMinutes = splitWork.getDuration();
                    } else {
                        splitMinutes = assignmentWorkPerDay.getDuration();
                        splitMinutes *= calendarSplitWork.getDuration();
                        splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
                    }
                } else {
                    splitMinutes = assignmentWorkPerDay.getDuration();
                    splitMinutes *= calendarSplitWork.getDuration();
                    splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
                }
                TimephasedResourceAssignment split2 = new TimephasedResourceAssignment();
                split2.setStart(splitStart);
                split2.setFinish(splitFinish);
                split2.setTotalWork(splitWork);
                result[0] = split2;
            } else {
                splitFinish = assignmentStart;
                splitMinutes = 0.0;
            }
            splitStart = calendar.getNextWorkStart(splitFinish);
            splitFinish = assignmentFinish;
            if (splitStart.getTime() > splitFinish.getTime()) {
                split = null;
            } else {
                splitMinutes = assignmentWork.getDuration() - splitMinutes;
                Duration splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                split = new TimephasedResourceAssignment();
                split.setStart(splitStart);
                split.setFinish(splitFinish);
                split.setTotalWork(splitWork);
                split.setWorkPerDay(assignment.getWorkPerDay());
            }
            result[1] = split;
        }
        return result;
    }

    private void mergeSameDay(ProjectCalendar calendar, LinkedList<TimephasedResourceAssignment> list) {
        LinkedList<TimephasedResourceAssignment> result = new LinkedList<TimephasedResourceAssignment>();
        TimephasedResourceAssignment previousAssignment = null;
        for (TimephasedResourceAssignment assignment : list) {
            if (previousAssignment == null) {
                assignment.setWorkPerDay(assignment.getTotalWork());
                result.add(assignment);
            } else {
                Date previousAssignmentStart = previousAssignment.getStart();
                Date previousAssignmentStartDay = DateUtility.getDayStartDate(previousAssignmentStart);
                Date assignmentStart = assignment.getStart();
                Date assignmentStartDay = DateUtility.getDayStartDate(assignmentStart);
                if (previousAssignmentStartDay.getTime() == assignmentStartDay.getTime()) {
                    Duration previousAssignmentWork = previousAssignment.getTotalWork();
                    Duration assignmentWork = assignment.getTotalWork();
                    if (previousAssignmentWork.getDuration() != 0.0 && assignmentWork.getDuration() == 0.0) continue;
                    Date previousAssignmentFinish = previousAssignment.getFinish();
                    if (previousAssignmentFinish.getTime() == assignmentStart.getTime() || calendar.getNextWorkStart(previousAssignmentFinish).getTime() == assignmentStart.getTime()) {
                        result.removeLast();
                        if (previousAssignmentWork.getDuration() != 0.0 && assignmentWork.getDuration() != 0.0) {
                            double work = previousAssignment.getTotalWork().getDuration();
                            Duration totalWork = Duration.getInstance(work += assignment.getTotalWork().getDuration(), TimeUnit.MINUTES);
                            TimephasedResourceAssignment merged = new TimephasedResourceAssignment();
                            merged.setStart(previousAssignment.getStart());
                            merged.setFinish(assignment.getFinish());
                            merged.setTotalWork(totalWork);
                            assignment = merged;
                        } else if (assignmentWork.getDuration() == 0.0) {
                            assignment = previousAssignment;
                        }
                    }
                }
                assignment.setWorkPerDay(assignment.getTotalWork());
                result.add(assignment);
            }
            Duration calendarWork = calendar.getWork(assignment.getStart(), assignment.getFinish(), TimeUnit.MINUTES);
            Duration assignmentWork = assignment.getTotalWork();
            if (calendarWork.getDuration() == 0.0 && assignmentWork.getDuration() == 0.0) {
                result.removeLast();
                continue;
            }
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }

    private Duration getAssignmentWork(ProjectCalendar calendar, TimephasedResourceAssignment assignment) {
        Date assignmentStart;
        Date splitStart = assignmentStart = assignment.getStart();
        Date splitFinishTime = calendar.getFinishTime(splitStart);
        Date splitFinish = DateUtility.setTime(splitStart, splitFinishTime);
        Duration calendarSplitWork = calendar.getWork(splitStart, splitFinish, TimeUnit.MINUTES);
        Duration assignmentWorkPerDay = assignment.getWorkPerDay();
        double splitMinutes = assignmentWorkPerDay.getDuration();
        splitMinutes *= calendarSplitWork.getDuration();
        Duration splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
        return splitWork;
    }
}

