/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.GanttBarCommonStyle;
import net.sf.mpxj.mpp.GanttBarMiddleShape;
import net.sf.mpxj.mpp.GanttBarShowForCriteria;
import net.sf.mpxj.mpp.GanttBarShowForCriteriaEnum;
import net.sf.mpxj.mpp.GanttBarStartAndEndShape;
import net.sf.mpxj.mpp.MPPUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GanttBarStyle
extends GanttBarCommonStyle {
    private String m_name;
    private TaskField m_fromField;
    private TaskField m_toField;
    private boolean m_showForNormalTasks;
    private boolean m_showForMilestoneTasks;
    private boolean m_showForSummaryTasks;
    private boolean m_showForCriticalTasks;
    private boolean m_showForNonCriticalTasks;
    private boolean m_showForMarkedTasks;
    private boolean m_showForFinishedTasks;
    private boolean m_showForInProgressTasks;
    private boolean m_showForNotFinishedTasks;
    private boolean m_showForNotStartedTasks;
    private int m_row;
    private Set<GanttBarShowForCriteria> m_showForCriteriaSet = new HashSet<GanttBarShowForCriteria>();
    private GanttBarStartAndEndShape m_startShape;
    private GanttBarStartAndEndShape m_endShape;
    private GanttBarMiddleShape m_middleShapeAndPattern;
    private static final GanttBarShowForCriteria SHOW_FOR_NORMAL_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.NORMAL, false);
    private static final GanttBarShowForCriteria SHOW_FOR_MILESTONE_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.MILESTONE, false);
    private static final GanttBarShowForCriteria SHOW_FOR_SUMMARY_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.SUMMARY, false);
    private static final GanttBarShowForCriteria SHOW_FOR_CRITICAL_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.CRITICAL, false);
    private static final GanttBarShowForCriteria SHOW_FOR_NON_CRITICAL_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.NONCRITICAL, false);
    private static final GanttBarShowForCriteria SHOW_FOR_MARKED_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.MARKED, false);
    private static final GanttBarShowForCriteria SHOW_FOR_FINISHED_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.FINISHED, false);
    private static final GanttBarShowForCriteria SHOW_FOR_IN_PROGRESS_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.INPROGRESS, false);
    private static final GanttBarShowForCriteria SHOW_FOR_NOT_FINISHED_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.NOTFINISHED, false);
    private static final GanttBarShowForCriteria SHOW_FOR_NOT_STARTED_TASKS = new GanttBarShowForCriteria(GanttBarShowForCriteriaEnum.NOTSTARTED, false);

    public GanttBarStyle(String name, byte[] data, int offset) {
        this.m_name = name;
        this.m_middleShape = data[offset];
        this.m_middlePattern = data[offset + 1];
        this.m_middleShapeAndPattern = GanttBarMiddleShape.getInstance(this.m_middleShape, this.m_middlePattern);
        this.m_middleColor = ColorType.getInstance(data[offset + 2]);
        this.m_startShapeAndStyle = data[offset + 4];
        this.m_startShape = GanttBarStartAndEndShape.getInstance(this.m_startShapeAndStyle);
        this.m_startColor = ColorType.getInstance(data[offset + 5]);
        this.m_endShapeAndStyle = data[offset + 6];
        this.m_endShape = GanttBarStartAndEndShape.getInstance(this.m_endShapeAndStyle);
        this.m_endColor = ColorType.getInstance(data[offset + 7]);
        this.m_startShape.setColor(this.m_startColor);
        this.m_middleShapeAndPattern.setColor(this.m_middleColor);
        this.m_endShape.setColor(this.m_endColor);
        this.m_fromField = MPPTaskField.getInstance(MPPUtility.getShort(data, offset + 8));
        int toField = MPPUtility.getShort(data, offset + 12);
        this.m_toField = MPPTaskField.getInstance(toField);
        int flags1 = MPPUtility.getShort(data, offset + 16);
        int flags2 = MPPUtility.getShort(data, offset + 18);
        int flags3 = MPPUtility.getShort(data, offset + 20);
        int flags4 = MPPUtility.getShort(data, offset + 24);
        int flags5 = MPPUtility.getShort(data, offset + 26);
        int flags6 = MPPUtility.getShort(data, offset + 28);
        this.addToSet(GanttBarShowForCriteriaEnum.NORMAL, flags1, false);
        this.addToSet(GanttBarShowForCriteriaEnum.FLAG1, flags2, false);
        this.addToSet(GanttBarShowForCriteriaEnum.FLAG13, flags3, false);
        this.addToSet(GanttBarShowForCriteriaEnum.NORMAL, flags4, true);
        this.addToSet(GanttBarShowForCriteriaEnum.FLAG1, flags5, true);
        this.addToSet(GanttBarShowForCriteriaEnum.FLAG13, flags6, true);
        this.m_showForNormalTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_NORMAL_TASKS);
        this.m_showForMilestoneTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_MILESTONE_TASKS);
        this.m_showForSummaryTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_SUMMARY_TASKS);
        this.m_showForCriticalTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_CRITICAL_TASKS);
        this.m_showForNonCriticalTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_NON_CRITICAL_TASKS);
        this.m_showForMarkedTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_MARKED_TASKS);
        this.m_showForFinishedTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_FINISHED_TASKS);
        this.m_showForInProgressTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_IN_PROGRESS_TASKS);
        this.m_showForNotFinishedTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_NOT_FINISHED_TASKS);
        this.m_showForNotStartedTasks = this.m_showForCriteriaSet.contains(SHOW_FOR_NOT_STARTED_TASKS);
        this.m_row = data[offset + 32] + 1;
        this.m_leftText = MPPTaskField.getInstance(MPPUtility.getShort(data, offset + 34));
        this.m_rightText = MPPTaskField.getInstance(MPPUtility.getShort(data, offset + 38));
        this.m_topText = MPPTaskField.getInstance(MPPUtility.getShort(data, offset + 42));
        this.m_bottomText = MPPTaskField.getInstance(MPPUtility.getShort(data, offset + 46));
        this.m_insideText = MPPTaskField.getInstance(MPPUtility.getShort(data, offset + 50));
    }

    private void addToSet(GanttBarShowForCriteriaEnum baseCriteria, int flagValue, boolean notCondition) {
        int flag = 1;
        for (int index = 0; index <= 15; ++index) {
            if ((flagValue & flag) != 0) {
                GanttBarShowForCriteriaEnum enumValue = GanttBarShowForCriteriaEnum.getInstance(baseCriteria.getValue() + index);
                this.m_showForCriteriaSet.add(new GanttBarShowForCriteria(enumValue, notCondition));
            }
            flag = (short)(flag * 2);
        }
    }

    public TaskField getFromField() {
        return this.m_fromField;
    }

    public String getName() {
        return this.m_name;
    }

    public int getRow() {
        return this.m_row;
    }

    public boolean getShowForCriticalTasks() {
        return this.m_showForCriticalTasks;
    }

    public boolean getShowForFinishedTasks() {
        return this.m_showForFinishedTasks;
    }

    public boolean getShowForInProgressTasks() {
        return this.m_showForInProgressTasks;
    }

    public boolean getShowForMarkedTasks() {
        return this.m_showForMarkedTasks;
    }

    public boolean getShowForMilestoneTasks() {
        return this.m_showForMilestoneTasks;
    }

    public boolean getShowForNonCriticalTasks() {
        return this.m_showForNonCriticalTasks;
    }

    public boolean getShowForNormalTasks() {
        return this.m_showForNormalTasks;
    }

    public boolean getShowForNotFinishedTasks() {
        return this.m_showForNotFinishedTasks;
    }

    public boolean getShowForNotStartedTasks() {
        return this.m_showForNotStartedTasks;
    }

    public boolean getShowForSummaryTasks() {
        return this.m_showForSummaryTasks;
    }

    public TaskField getToField() {
        return this.m_toField;
    }

    public GanttBarStartAndEndShape getStartShape() {
        return this.m_startShape;
    }

    public GanttBarStartAndEndShape getEndShape() {
        return this.m_endShape;
    }

    public GanttBarMiddleShape getMiddleShapeAndPattern() {
        return this.m_middleShapeAndPattern;
    }

    public Set<GanttBarShowForCriteria> getShowForCriteriaSet() {
        return this.m_showForCriteriaSet;
    }

    @Override
    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("   [GanttBarStyle");
        pw.println("      Name=" + this.m_name);
        pw.println("      FromField=" + this.m_fromField);
        pw.println("      ToField=" + this.m_toField);
        pw.println("      ShowForNormalTasks=" + this.m_showForNormalTasks);
        pw.println("      ShowForMilestoneTasks=" + this.m_showForMilestoneTasks);
        pw.println("      ShowForSummaryTasks=" + this.m_showForSummaryTasks);
        pw.println("      ShowForCriticalTasks=" + this.m_showForCriticalTasks);
        pw.println("      ShowForNonCriticalTasks=" + this.m_showForNonCriticalTasks);
        pw.println("      ShowForMarkedTasks=" + this.m_showForMarkedTasks);
        pw.println("      ShowForFinishedTasks=" + this.m_showForFinishedTasks);
        pw.println("      ShowForInProgressTasks=" + this.m_showForInProgressTasks);
        pw.println("      ShowForNotFinishedTasks=" + this.m_showForNotFinishedTasks);
        pw.println("      ShowForNotStartedTasks=" + this.m_showForNotStartedTasks);
        pw.println("      Row=" + this.m_row);
        pw.println(super.toString());
        pw.println("   ]");
        pw.flush();
        return os.toString();
    }
}

