/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.awt.Color;
import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ColorType implements MpxjEnum
{
    BLACK(0, "Black", Color.BLACK),
    RED(1, "Red", Color.RED),
    YELLOW(2, "Yellow", Color.YELLOW),
    LIME(3, "Lime", Color.GREEN),
    AQUA(4, "Aqua", Color.CYAN),
    BLUE(5, "Blue", Color.BLUE),
    FUSCHIA(6, "Fuschia", Color.MAGENTA),
    WHITE(7, "White", Color.WHITE),
    MAROON(8, "Maroon", new Color(132, 0, 0)),
    GREEN(9, "Green", new Color(0, 130, 0)),
    OLIVE(10, "Olive", new Color(132, 130, 0)),
    NAVY(11, "Navy", new Color(0, 0, 132)),
    PURPLE(12, "Purple", new Color(132, 0, 132)),
    TEAL(13, "Teal", new Color(0, 130, 132)),
    GRAY(14, "Gray", new Color(132, 130, 132)),
    SILVER(15, "Silver", new Color(198, 195, 198)),
    AUTOMATIC(16, "Automatic", null);

    private static final ColorType[] TYPE_VALUES;
    private int m_value;
    private String m_name;
    private Color m_color;

    private ColorType(int type, String name, Color color) {
        this.m_value = type;
        this.m_name = name;
        this.m_color = color;
    }

    public static ColorType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = AUTOMATIC.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static ColorType getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return ColorType.getInstance(value);
    }

    public String getName() {
        return this.m_name;
    }

    public Color getColor() {
        return this.m_color;
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = new ColorType[17];
        Iterator i$ = EnumSet.range(BLACK, AUTOMATIC).iterator();
        while (i$.hasNext()) {
            ColorType e;
            ColorType.TYPE_VALUES[e.getValue()] = e = (ColorType)i$.next();
        }
    }
}

