/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.io.File;
import java.util.Locale;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.junit.MppXmlCompare;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class CustomerDataTest
extends MPXJTestCase {
    public void testCustomerData1() throws Exception {
        this.testCustomerData(1, 10);
    }

    public void testCustomerData2() throws Exception {
        this.testCustomerData(2, 10);
    }

    public void testCustomerData3() throws Exception {
        this.testCustomerData(3, 10);
    }

    public void testCustomerData4() throws Exception {
        this.testCustomerData(4, 10);
    }

    public void testCustomerData5() throws Exception {
        this.testCustomerData(5, 10);
    }

    public void testCustomerData6() throws Exception {
        this.testCustomerData(6, 10);
    }

    public void testCustomerData7() throws Exception {
        this.testCustomerData(7, 10);
    }

    public void testCustomerData8() throws Exception {
        this.testCustomerData(8, 10);
    }

    public void testCustomerData9() throws Exception {
        this.testCustomerData(9, 10);
    }

    public void testCustomerData10() throws Exception {
        this.testCustomerData(10, 10);
    }

    private void testCustomerData(int index, int max) throws Exception {
        File dir;
        String dirName = System.getProperty("mpxj.junit.privatedir");
        if (dirName != null && dirName.length() != 0 && (dir = new File(dirName)).exists() && dir.isDirectory()) {
            MPPReader mppReader = new MPPReader();
            MPXReader mpxReader = new MPXReader();
            MSPDIReader mspdiReader = new MSPDIReader();
            int failures = 0;
            File[] files = dir.listFiles();
            int interval = files.length / max;
            int startIndex = (index - 1) * interval;
            int endIndex = index == max ? files.length : startIndex + interval;
            for (int loop = startIndex; loop < endIndex; ++loop) {
                File file = files[loop];
                String name = file.getName().toUpperCase();
                try {
                    ProjectFile mpxj;
                    if (name.endsWith(".MPP")) {
                        mpxj = mppReader.read(file);
                        this.validateMpp(file.getCanonicalPath(), mpxj);
                        continue;
                    }
                    if (name.endsWith(".MPX")) {
                        mpxReader.setLocale(Locale.ENGLISH);
                        if (name.indexOf(".DE.") != -1) {
                            mpxReader.setLocale(Locale.GERMAN);
                        }
                        if (name.indexOf(".SV.") != -1) {
                            mpxReader.setLocale(new Locale("sv"));
                        }
                        mpxj = mpxReader.read(file);
                        continue;
                    }
                    if (!name.endsWith(".XML") || name.indexOf(".MPP.") != -1) continue;
                    ProjectFile projectFile = mspdiReader.read(file);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Failed to read " + name);
                    ex.printStackTrace();
                    ++failures;
                }
            }
            CustomerDataTest.assertEquals((String)("Failed to read " + failures + " files"), (int)0, (int)failures);
        }
    }

    private void validateMpp(String name, ProjectFile mpp) throws Exception {
        File xmlFile = new File(name + ".xml");
        if (xmlFile.exists()) {
            ProjectFile xml = new MSPDIReader().read(xmlFile);
            MppXmlCompare compare = new MppXmlCompare();
            compare.process(xml, mpp);
        }
    }
}

