/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.listener.FieldListener;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Task
extends ProjectEntity
implements Comparable<Task>,
FieldContainer {
    private Object[] m_array = new Object[445];
    private Task m_parent;
    private List<Task> m_children = new LinkedList<Task>();
    private List<ResourceAssignment> m_assignments = new LinkedList<ResourceAssignment>();
    private RecurringTask m_recurringTask;
    private static final TaskField[] ENTERPRISE_COST_FIELDS = new TaskField[]{TaskField.ENTERPRISE_COST1, TaskField.ENTERPRISE_COST2, TaskField.ENTERPRISE_COST3, TaskField.ENTERPRISE_COST4, TaskField.ENTERPRISE_COST5, TaskField.ENTERPRISE_COST6, TaskField.ENTERPRISE_COST7, TaskField.ENTERPRISE_COST8, TaskField.ENTERPRISE_COST9, TaskField.ENTERPRISE_COST10};
    private static final TaskField[] ENTERPRISE_DATE_FIELDS = new TaskField[]{TaskField.ENTERPRISE_DATE1, TaskField.ENTERPRISE_DATE2, TaskField.ENTERPRISE_DATE3, TaskField.ENTERPRISE_DATE4, TaskField.ENTERPRISE_DATE5, TaskField.ENTERPRISE_DATE6, TaskField.ENTERPRISE_DATE7, TaskField.ENTERPRISE_DATE8, TaskField.ENTERPRISE_DATE9, TaskField.ENTERPRISE_DATE10, TaskField.ENTERPRISE_DATE11, TaskField.ENTERPRISE_DATE12, TaskField.ENTERPRISE_DATE13, TaskField.ENTERPRISE_DATE14, TaskField.ENTERPRISE_DATE15, TaskField.ENTERPRISE_DATE16, TaskField.ENTERPRISE_DATE17, TaskField.ENTERPRISE_DATE18, TaskField.ENTERPRISE_DATE19, TaskField.ENTERPRISE_DATE20, TaskField.ENTERPRISE_DATE21, TaskField.ENTERPRISE_DATE22, TaskField.ENTERPRISE_DATE23, TaskField.ENTERPRISE_DATE24, TaskField.ENTERPRISE_DATE25, TaskField.ENTERPRISE_DATE26, TaskField.ENTERPRISE_DATE27, TaskField.ENTERPRISE_DATE28, TaskField.ENTERPRISE_DATE29, TaskField.ENTERPRISE_DATE30};
    private static final TaskField[] ENTERPRISE_DURATION_FIELDS = new TaskField[]{TaskField.ENTERPRISE_DURATION1, TaskField.ENTERPRISE_DURATION2, TaskField.ENTERPRISE_DURATION3, TaskField.ENTERPRISE_DURATION4, TaskField.ENTERPRISE_DURATION5, TaskField.ENTERPRISE_DURATION6, TaskField.ENTERPRISE_DURATION7, TaskField.ENTERPRISE_DURATION8, TaskField.ENTERPRISE_DURATION9, TaskField.ENTERPRISE_DURATION10};
    private static final TaskField[] ENTERPRISE_FLAG_FIELDS = new TaskField[]{TaskField.ENTERPRISE_FLAG1, TaskField.ENTERPRISE_FLAG2, TaskField.ENTERPRISE_FLAG3, TaskField.ENTERPRISE_FLAG4, TaskField.ENTERPRISE_FLAG5, TaskField.ENTERPRISE_FLAG6, TaskField.ENTERPRISE_FLAG7, TaskField.ENTERPRISE_FLAG8, TaskField.ENTERPRISE_FLAG9, TaskField.ENTERPRISE_FLAG10, TaskField.ENTERPRISE_FLAG11, TaskField.ENTERPRISE_FLAG12, TaskField.ENTERPRISE_FLAG13, TaskField.ENTERPRISE_FLAG14, TaskField.ENTERPRISE_FLAG15, TaskField.ENTERPRISE_FLAG16, TaskField.ENTERPRISE_FLAG17, TaskField.ENTERPRISE_FLAG18, TaskField.ENTERPRISE_FLAG19, TaskField.ENTERPRISE_FLAG20};
    private static final TaskField[] ENTERPRISE_NUMBER_FIELDS = new TaskField[]{TaskField.ENTERPRISE_NUMBER1, TaskField.ENTERPRISE_NUMBER2, TaskField.ENTERPRISE_NUMBER3, TaskField.ENTERPRISE_NUMBER4, TaskField.ENTERPRISE_NUMBER5, TaskField.ENTERPRISE_NUMBER6, TaskField.ENTERPRISE_NUMBER7, TaskField.ENTERPRISE_NUMBER8, TaskField.ENTERPRISE_NUMBER9, TaskField.ENTERPRISE_NUMBER10, TaskField.ENTERPRISE_NUMBER11, TaskField.ENTERPRISE_NUMBER12, TaskField.ENTERPRISE_NUMBER13, TaskField.ENTERPRISE_NUMBER14, TaskField.ENTERPRISE_NUMBER15, TaskField.ENTERPRISE_NUMBER16, TaskField.ENTERPRISE_NUMBER17, TaskField.ENTERPRISE_NUMBER18, TaskField.ENTERPRISE_NUMBER19, TaskField.ENTERPRISE_NUMBER20, TaskField.ENTERPRISE_NUMBER21, TaskField.ENTERPRISE_NUMBER22, TaskField.ENTERPRISE_NUMBER23, TaskField.ENTERPRISE_NUMBER24, TaskField.ENTERPRISE_NUMBER25, TaskField.ENTERPRISE_NUMBER26, TaskField.ENTERPRISE_NUMBER27, TaskField.ENTERPRISE_NUMBER28, TaskField.ENTERPRISE_NUMBER29, TaskField.ENTERPRISE_NUMBER30, TaskField.ENTERPRISE_NUMBER31, TaskField.ENTERPRISE_NUMBER32, TaskField.ENTERPRISE_NUMBER33, TaskField.ENTERPRISE_NUMBER34, TaskField.ENTERPRISE_NUMBER35, TaskField.ENTERPRISE_NUMBER36, TaskField.ENTERPRISE_NUMBER37, TaskField.ENTERPRISE_NUMBER38, TaskField.ENTERPRISE_NUMBER39, TaskField.ENTERPRISE_NUMBER40};
    private static final TaskField[] ENTERPRISE_TEXT_FIELDS = new TaskField[]{TaskField.ENTERPRISE_TEXT1, TaskField.ENTERPRISE_TEXT2, TaskField.ENTERPRISE_TEXT3, TaskField.ENTERPRISE_TEXT4, TaskField.ENTERPRISE_TEXT5, TaskField.ENTERPRISE_TEXT6, TaskField.ENTERPRISE_TEXT7, TaskField.ENTERPRISE_TEXT8, TaskField.ENTERPRISE_TEXT9, TaskField.ENTERPRISE_TEXT10, TaskField.ENTERPRISE_TEXT11, TaskField.ENTERPRISE_TEXT12, TaskField.ENTERPRISE_TEXT13, TaskField.ENTERPRISE_TEXT14, TaskField.ENTERPRISE_TEXT15, TaskField.ENTERPRISE_TEXT16, TaskField.ENTERPRISE_TEXT17, TaskField.ENTERPRISE_TEXT18, TaskField.ENTERPRISE_TEXT19, TaskField.ENTERPRISE_TEXT20, TaskField.ENTERPRISE_TEXT21, TaskField.ENTERPRISE_TEXT22, TaskField.ENTERPRISE_TEXT23, TaskField.ENTERPRISE_TEXT24, TaskField.ENTERPRISE_TEXT25, TaskField.ENTERPRISE_TEXT26, TaskField.ENTERPRISE_TEXT27, TaskField.ENTERPRISE_TEXT28, TaskField.ENTERPRISE_TEXT29, TaskField.ENTERPRISE_TEXT30, TaskField.ENTERPRISE_TEXT31, TaskField.ENTERPRISE_TEXT32, TaskField.ENTERPRISE_TEXT33, TaskField.ENTERPRISE_TEXT34, TaskField.ENTERPRISE_TEXT35, TaskField.ENTERPRISE_TEXT36, TaskField.ENTERPRISE_TEXT37, TaskField.ENTERPRISE_TEXT38, TaskField.ENTERPRISE_TEXT39, TaskField.ENTERPRISE_TEXT40};
    private static final TaskField[] BASELINE_COSTS = new TaskField[]{TaskField.BASELINE1_COST, TaskField.BASELINE2_COST, TaskField.BASELINE3_COST, TaskField.BASELINE4_COST, TaskField.BASELINE5_COST, TaskField.BASELINE6_COST, TaskField.BASELINE7_COST, TaskField.BASELINE8_COST, TaskField.BASELINE9_COST, TaskField.BASELINE10_COST};
    private static final TaskField[] BASELINE_DURATIONS = new TaskField[]{TaskField.BASELINE1_DURATION, TaskField.BASELINE2_DURATION, TaskField.BASELINE3_DURATION, TaskField.BASELINE4_DURATION, TaskField.BASELINE5_DURATION, TaskField.BASELINE6_DURATION, TaskField.BASELINE7_DURATION, TaskField.BASELINE8_DURATION, TaskField.BASELINE9_DURATION, TaskField.BASELINE10_DURATION};
    private static final TaskField[] BASELINE_STARTS = new TaskField[]{TaskField.BASELINE1_START, TaskField.BASELINE2_START, TaskField.BASELINE3_START, TaskField.BASELINE4_START, TaskField.BASELINE5_START, TaskField.BASELINE6_START, TaskField.BASELINE7_START, TaskField.BASELINE8_START, TaskField.BASELINE9_START, TaskField.BASELINE10_START};
    private static final TaskField[] BASELINE_FINISHES = new TaskField[]{TaskField.BASELINE1_FINISH, TaskField.BASELINE2_FINISH, TaskField.BASELINE3_FINISH, TaskField.BASELINE4_FINISH, TaskField.BASELINE5_FINISH, TaskField.BASELINE6_FINISH, TaskField.BASELINE7_FINISH, TaskField.BASELINE8_FINISH, TaskField.BASELINE9_FINISH, TaskField.BASELINE10_FINISH};
    private static final TaskField[] BASELINE_WORKS = new TaskField[]{TaskField.BASELINE1_WORK, TaskField.BASELINE2_WORK, TaskField.BASELINE3_WORK, TaskField.BASELINE4_WORK, TaskField.BASELINE5_WORK, TaskField.BASELINE6_WORK, TaskField.BASELINE7_WORK, TaskField.BASELINE8_WORK, TaskField.BASELINE9_WORK, TaskField.BASELINE10_WORK};
    private boolean m_null;
    private String m_wbsLevel;
    private TimeUnit m_durationFormat;
    private boolean m_resumeValid;
    private Integer m_subprojectTaskUniqueID;
    private Integer m_subprojectTaskID;
    private Integer m_subprojectTasksUniqueIDOffset;
    private String m_externalTaskProject;
    private TimeUnit m_levelingDelayFormat;
    private Integer m_physicalPercentComplete;
    private EarnedValueMethod m_earnedValueMethod;
    private Duration m_actualWorkProtected;
    private Duration m_actualOvertimeWorkProtected;
    private boolean m_expanded = true;
    private Integer m_externalTaskID;
    private List<DateRange> m_splits;
    private Date m_splitsComplete;
    private SubProject m_subProject;
    private List<FieldListener> m_listeners;

    Task(ProjectFile file, Task parent) {
        super(file);
        this.setType(TaskType.FIXED_UNITS);
        this.setConstraintType(ConstraintType.AS_SOON_AS_POSSIBLE);
        this.m_parent = parent;
        if (file.getAutoTaskUniqueID()) {
            this.setUniqueID(file.getTaskUniqueID());
        }
        if (file.getAutoTaskID()) {
            this.setID(file.getTaskID());
        }
        if (file.getAutoWBS()) {
            this.generateWBS(parent);
        }
        if (file.getAutoOutlineNumber()) {
            this.generateOutlineNumber(parent);
        }
        if (file.getAutoOutlineLevel()) {
            if (parent == null) {
                this.setOutlineLevel(1);
            } else {
                this.setOutlineLevel(NumberUtility.getInt(parent.getOutlineLevel()) + 1);
            }
        }
    }

    public void generateWBS(Task parent) {
        String wbs;
        if (parent == null) {
            wbs = NumberUtility.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTaskCount() + 1);
        } else {
            wbs = parent.getWBS();
            int index = wbs.lastIndexOf(".0");
            if (index != -1) {
                wbs = wbs.substring(0, index);
            }
            wbs = wbs.equals("0") ? Integer.toString(parent.getChildTaskCount() + 1) : wbs + "." + (parent.getChildTaskCount() + 1);
        }
        this.setWBS(wbs);
    }

    public void generateOutlineNumber(Task parent) {
        String outline;
        if (parent == null) {
            outline = NumberUtility.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTaskCount() + 1);
        } else {
            outline = parent.getOutlineNumber();
            int index = outline.lastIndexOf(".0");
            if (index != -1) {
                outline = outline.substring(0, index);
            }
            outline = outline.equals("0") ? Integer.toString(parent.getChildTaskCount() + 1) : outline + "." + (parent.getChildTaskCount() + 1);
        }
        this.setOutlineNumber(outline);
    }

    public void setNotes(String notes) {
        this.set((FieldType)TaskField.NOTES, notes);
    }

    public Task addTask() {
        ProjectFile parent = this.getParentFile();
        Task task = new Task(parent, this);
        this.m_children.add(task);
        parent.addTask(task);
        this.setSummary(true);
        return task;
    }

    public void addChildTask(Task child, int childOutlineLevel) throws MPXJException {
        int outlineLevel = NumberUtility.getInt(this.getOutlineLevel());
        if (outlineLevel + 1 == childOutlineLevel) {
            this.m_children.add(child);
        } else if (!this.m_children.isEmpty()) {
            this.m_children.get(this.m_children.size() - 1).addChildTask(child, childOutlineLevel);
        }
    }

    public void addChildTask(Task child) {
        child.m_parent = this;
        this.m_children.add(child);
    }

    public void removeChildTask(Task child) {
        if (this.m_children.remove(child)) {
            child.m_parent = null;
        }
        this.setSummary(!this.m_children.isEmpty());
    }

    public void clearChildTasks() {
        this.m_children.clear();
    }

    public RecurringTask addRecurringTask() {
        if (this.m_recurringTask == null) {
            this.m_recurringTask = new RecurringTask();
        }
        return this.m_recurringTask;
    }

    public RecurringTask getRecurringTask() {
        return this.m_recurringTask;
    }

    public ResourceAssignment addResourceAssignment(Resource resource) {
        Integer uniqueID;
        Iterator<ResourceAssignment> iter = this.m_assignments.iterator();
        ResourceAssignment assignment = null;
        Integer resourceUniqueID = resource.getUniqueID();
        while (iter.hasNext() && !(uniqueID = (assignment = iter.next()).getResourceUniqueID()).equals(resourceUniqueID)) {
            assignment = null;
        }
        if (assignment == null) {
            assignment = new ResourceAssignment(this.getParentFile(), this);
            this.m_assignments.add(assignment);
            this.getParentFile().addResourceAssignment(assignment);
            assignment.setResourceUniqueID(resourceUniqueID);
            assignment.setWork(this.getDuration());
            assignment.setUnits(ResourceAssignment.DEFAULT_UNITS);
            resource.addResourceAssignment(assignment);
        }
        return assignment;
    }

    public ResourceAssignment addResourceAssignment() {
        ResourceAssignment assignment = new ResourceAssignment(this.getParentFile(), this);
        this.m_assignments.add(assignment);
        this.getParentFile().getAllResourceAssignments().add(assignment);
        return assignment;
    }

    public List<ResourceAssignment> getResourceAssignments() {
        return this.m_assignments;
    }

    void removeResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.remove(assignment);
    }

    public Relation addPredecessor() {
        return this.addPredecessor(null);
    }

    public Relation addPredecessor(Task task) {
        LinkedList<Relation> list = (LinkedList<Relation>)this.getCachedValue(TaskField.PREDECESSORS);
        if (list == null) {
            list = new LinkedList<Relation>();
            this.set((FieldType)TaskField.PREDECESSORS, list);
        }
        Relation rel = null;
        if (task != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext() && !NumberUtility.equals((rel = (Relation)iter.next()).getTaskUniqueID(), task.getUniqueID())) {
                rel = null;
            }
        }
        if (rel == null) {
            rel = new Relation(this.getParentFile(), this);
            if (task != null) {
                rel.setTaskUniqueID(task.getUniqueID());
            }
            list.add(rel);
        }
        return rel;
    }

    public Relation addUniqueIdPredecessor() {
        return this.addUniqueIdPredecessor(null);
    }

    public Relation addUniqueIdPredecessor(Task task) {
        LinkedList<Relation> list = (LinkedList<Relation>)this.getCachedValue(TaskField.UNIQUE_ID_PREDECESSORS);
        if (list == null) {
            list = new LinkedList<Relation>();
            this.set((FieldType)TaskField.UNIQUE_ID_PREDECESSORS, list);
        }
        Relation rel = null;
        if (task != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext() && !NumberUtility.equals((rel = (Relation)iter.next()).getTaskUniqueID(), task.getUniqueID())) {
                rel = null;
            }
        }
        if (rel == null) {
            rel = new Relation(this.getParentFile(), this);
            if (task != null) {
                rel.setTaskUniqueID(task.getUniqueID());
            }
            list.add(rel);
        }
        return rel;
    }

    public Relation addSuccessor() {
        return this.addSuccessor(null);
    }

    public Relation addSuccessor(Task task) {
        LinkedList<Relation> list = (LinkedList<Relation>)this.getCachedValue(TaskField.SUCCESSORS);
        if (list == null) {
            list = new LinkedList<Relation>();
            this.set((FieldType)TaskField.SUCCESSORS, list);
        }
        Relation rel = new Relation(this.getParentFile(), this);
        if (task != null) {
            rel.setTaskUniqueID(task.getUniqueID());
        }
        list.add(rel);
        return rel;
    }

    public Relation addUniqueIdSuccessor() {
        return this.addUniqueIdSuccessor(null);
    }

    public Relation addUniqueIdSuccessor(Task task) {
        LinkedList<Relation> list = (LinkedList<Relation>)this.getCachedValue(TaskField.UNIQUE_ID_SUCCESSORS);
        if (list == null) {
            list = new LinkedList<Relation>();
            this.set((FieldType)TaskField.UNIQUE_ID_SUCCESSORS, list);
        }
        Relation rel = new Relation(this.getParentFile(), this);
        if (task != null) {
            rel.setTaskUniqueID(task.getUniqueID());
        }
        list.add(rel);
        return rel;
    }

    public void setPercentageComplete(Number val) {
        this.set((FieldType)TaskField.PERCENT_COMPLETE, val);
    }

    public void setPercentageWorkComplete(Number val) {
        this.set((FieldType)TaskField.PERCENT_WORK_COMPLETE, val);
    }

    public void setActualCost(Number val) {
        this.set((FieldType)TaskField.ACTUAL_COST, val);
    }

    public void setActualDuration(Duration val) {
        this.set((FieldType)TaskField.ACTUAL_DURATION, val);
    }

    public void setActualFinish(Date val) {
        this.set((FieldType)TaskField.ACTUAL_FINISH, val);
    }

    public void setActualStart(Date val) {
        this.set((FieldType)TaskField.ACTUAL_START, val);
    }

    public void setActualWork(Duration val) {
        this.set((FieldType)TaskField.ACTUAL_WORK, val);
    }

    public void setBaselineCost(Number val) {
        this.set((FieldType)TaskField.BASELINE_COST, val);
    }

    public void setBaselineDuration(Duration val) {
        this.set((FieldType)TaskField.BASELINE_DURATION, val);
    }

    public void setBaselineFinish(Date val) {
        this.set((FieldType)TaskField.BASELINE_FINISH, val);
    }

    public void setBaselineStart(Date val) {
        this.set((FieldType)TaskField.BASELINE_START, val);
    }

    public void setBaselineWork(Duration val) {
        this.set((FieldType)TaskField.BASELINE_WORK, val);
    }

    public void setBCWP(Number val) {
        this.set((FieldType)TaskField.BCWP, val);
    }

    public void setBCWS(Number val) {
        this.set((FieldType)TaskField.BCWS, val);
    }

    public void setConfirmed(boolean val) {
        this.set((FieldType)TaskField.CONFIRMED, val);
    }

    public void setConstraintDate(Date val) {
        this.set((FieldType)TaskField.CONSTRAINT_DATE, val);
    }

    public void setConstraintType(ConstraintType type) {
        this.set((FieldType)TaskField.CONSTRAINT_TYPE, type);
    }

    public void setContact(String val) {
        this.set((FieldType)TaskField.CONTACT, val);
    }

    public void setCost(Number val) {
        this.set((FieldType)TaskField.COST, val);
    }

    public void setCost1(Number val) {
        this.set((FieldType)TaskField.COST1, val);
    }

    public void setCost2(Number val) {
        this.set((FieldType)TaskField.COST2, val);
    }

    public void setCost3(Number val) {
        this.set((FieldType)TaskField.COST3, val);
    }

    public void setCostVariance(Number val) {
        this.set((FieldType)TaskField.COST_VARIANCE, val);
    }

    public void setCreateDate(Date val) {
        this.set((FieldType)TaskField.CREATED, val);
    }

    public void setCritical(boolean val) {
        this.set((FieldType)TaskField.CRITICAL, val);
    }

    public void setCV(Number val) {
        this.set((FieldType)TaskField.CV, val);
    }

    public void setLevelingDelay(Duration val) {
        this.set((FieldType)TaskField.LEVELING_DELAY, val);
    }

    public void setDuration(Duration val) {
        this.set((FieldType)TaskField.DURATION, val);
    }

    public void setDuration1(Duration duration) {
        this.set((FieldType)TaskField.DURATION1, duration);
    }

    public void setDuration2(Duration duration) {
        this.set((FieldType)TaskField.DURATION2, duration);
    }

    public void setDuration3(Duration duration) {
        this.set((FieldType)TaskField.DURATION3, duration);
    }

    public void setDurationVariance(Duration duration) {
        this.set((FieldType)TaskField.DURATION_VARIANCE, duration);
    }

    public void setEarlyFinish(Date date) {
        this.set((FieldType)TaskField.EARLY_FINISH, date);
    }

    public void setEarlyStart(Date date) {
        this.set((FieldType)TaskField.EARLY_START, date);
    }

    public void setFinish(Date date) {
        this.set((FieldType)TaskField.FINISH, date);
    }

    public void setFinish1(Date date) {
        this.set((FieldType)TaskField.FINISH1, date);
    }

    public void setFinish2(Date date) {
        this.set((FieldType)TaskField.FINISH2, date);
    }

    public void setFinish3(Date date) {
        this.set((FieldType)TaskField.FINISH3, date);
    }

    public void setFinish4(Date date) {
        this.set((FieldType)TaskField.FINISH4, date);
    }

    public void setFinish5(Date date) {
        this.set((FieldType)TaskField.FINISH5, date);
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)TaskField.FINISH_VARIANCE, duration);
    }

    public void setFixedCost(Number val) {
        this.set((FieldType)TaskField.FIXED_COST, val);
    }

    public void setFlag1(boolean val) {
        this.set((FieldType)TaskField.FLAG1, val);
    }

    public void setFlag2(boolean val) {
        this.set((FieldType)TaskField.FLAG2, val);
    }

    public void setFlag3(boolean val) {
        this.set((FieldType)TaskField.FLAG3, val);
    }

    public void setFlag4(boolean val) {
        this.set((FieldType)TaskField.FLAG4, val);
    }

    public void setFlag5(boolean val) {
        this.set((FieldType)TaskField.FLAG5, val);
    }

    public void setFlag6(boolean val) {
        this.set((FieldType)TaskField.FLAG6, val);
    }

    public void setFlag7(boolean val) {
        this.set((FieldType)TaskField.FLAG7, val);
    }

    public void setFlag8(boolean val) {
        this.set((FieldType)TaskField.FLAG8, val);
    }

    public void setFlag9(boolean val) {
        this.set((FieldType)TaskField.FLAG9, val);
    }

    public void setFlag10(boolean val) {
        this.set((FieldType)TaskField.FLAG10, val);
    }

    public void setFreeSlack(Duration duration) {
        this.set((FieldType)TaskField.FREE_SLACK, duration);
    }

    public void setHideBar(boolean flag) {
        this.set((FieldType)TaskField.HIDEBAR, flag);
    }

    public void setID(Integer val) {
        ProjectFile parent = this.getParentFile();
        Integer previous = this.getID();
        if (previous != null) {
            parent.unmapTaskID(previous);
        }
        parent.mapTaskID(val, this);
        this.set((FieldType)TaskField.ID, val);
    }

    public void setLateFinish(Date date) {
        this.set((FieldType)TaskField.LATE_FINISH, date);
    }

    public void setLateStart(Date date) {
        this.set((FieldType)TaskField.LATE_START, date);
    }

    public void setLinkedFields(boolean flag) {
        this.set((FieldType)TaskField.LINKED_FIELDS, flag);
    }

    public void setMarked(boolean flag) {
        this.set((FieldType)TaskField.MARKED, flag);
    }

    public void setMilestone(boolean flag) {
        this.set((FieldType)TaskField.MILESTONE, flag);
    }

    public void setName(String name) {
        this.set((FieldType)TaskField.NAME, name);
    }

    public void setNumber1(Number val) {
        this.set((FieldType)TaskField.NUMBER1, val);
    }

    public void setNumber2(Number val) {
        this.set((FieldType)TaskField.NUMBER2, val);
    }

    public void setNumber3(Number val) {
        this.set((FieldType)TaskField.NUMBER3, val);
    }

    public void setNumber4(Number val) {
        this.set((FieldType)TaskField.NUMBER4, val);
    }

    public void setNumber5(Number val) {
        this.set((FieldType)TaskField.NUMBER5, val);
    }

    public void setObjects(Integer val) {
        this.set((FieldType)TaskField.OBJECTS, val);
    }

    public void setOutlineLevel(Integer val) {
        this.set((FieldType)TaskField.OUTLINE_LEVEL, val);
    }

    public void setOutlineNumber(String val) {
        this.set((FieldType)TaskField.OUTLINE_NUMBER, val);
    }

    public void setPredecessors(List<Relation> list) {
        this.set((FieldType)TaskField.PREDECESSORS, list);
    }

    public void setPriority(Priority priority) {
        this.set((FieldType)TaskField.PRIORITY, priority);
    }

    public void setProject(String val) {
        this.set((FieldType)TaskField.PROJECT, val);
    }

    public void setRemainingCost(Number val) {
        this.set((FieldType)TaskField.REMAINING_COST, val);
    }

    public void setRemainingDuration(Duration val) {
        this.set((FieldType)TaskField.REMAINING_DURATION, val);
    }

    public void setRemainingWork(Duration val) {
        this.set((FieldType)TaskField.REMAINING_WORK, val);
    }

    public void setResourceGroup(String val) {
        this.set((FieldType)TaskField.RESOURCE_GROUP, val);
    }

    public void setResourceInitials(String val) {
        this.set((FieldType)TaskField.RESOURCE_INITIALS, val);
    }

    public void setResourceNames(String val) {
        this.set((FieldType)TaskField.RESOURCE_NAMES, val);
    }

    public void setResume(Date val) {
        this.set((FieldType)TaskField.RESUME, val);
    }

    public void setRollup(boolean val) {
        this.set((FieldType)TaskField.ROLLUP, val);
    }

    public void setStart(Date val) {
        this.set((FieldType)TaskField.START, val);
    }

    public void setStart1(Date val) {
        this.set((FieldType)TaskField.START1, val);
    }

    public void setStart2(Date val) {
        this.set((FieldType)TaskField.START2, val);
    }

    public void setStart3(Date val) {
        this.set((FieldType)TaskField.START3, val);
    }

    public void setStart4(Date val) {
        this.set((FieldType)TaskField.START4, val);
    }

    public void setStart5(Date val) {
        this.set((FieldType)TaskField.START5, val);
    }

    public void setStartVariance(Duration val) {
        this.set((FieldType)TaskField.START_VARIANCE, val);
    }

    public void setStop(Date val) {
        this.set((FieldType)TaskField.STOP, val);
    }

    public void setSubprojectName(String val) {
        this.set((FieldType)TaskField.SUBPROJECT_FILE, val);
    }

    public void setSuccessors(List<Relation> list) {
        this.set((FieldType)TaskField.SUCCESSORS, list);
    }

    public void setSummary(boolean val) {
        this.set((FieldType)TaskField.SUMMARY, val);
    }

    public void setSV(Number val) {
        this.set((FieldType)TaskField.SV, val);
    }

    public void setText1(String val) {
        this.set((FieldType)TaskField.TEXT1, val);
    }

    public void setText2(String val) {
        this.set((FieldType)TaskField.TEXT2, val);
    }

    public void setText3(String val) {
        this.set((FieldType)TaskField.TEXT3, val);
    }

    public void setText4(String val) {
        this.set((FieldType)TaskField.TEXT4, val);
    }

    public void setText5(String val) {
        this.set((FieldType)TaskField.TEXT5, val);
    }

    public void setText6(String val) {
        this.set((FieldType)TaskField.TEXT6, val);
    }

    public void setText7(String val) {
        this.set((FieldType)TaskField.TEXT7, val);
    }

    public void setText8(String val) {
        this.set((FieldType)TaskField.TEXT8, val);
    }

    public void setText9(String val) {
        this.set((FieldType)TaskField.TEXT9, val);
    }

    public void setText10(String val) {
        this.set((FieldType)TaskField.TEXT10, val);
    }

    public void setTotalSlack(Duration val) {
        this.set((FieldType)TaskField.TOTAL_SLACK, val);
    }

    public void setUniqueID(Integer val) {
        ProjectFile parent = this.getParentFile();
        Integer previous = this.getUniqueID();
        if (previous != null) {
            parent.unmapTaskUniqueID(previous);
        }
        parent.mapTaskUniqueID(val, this);
        this.set((FieldType)TaskField.UNIQUE_ID, val);
    }

    public void setUniqueIDPredecessors(List<Relation> list) {
        this.set((FieldType)TaskField.UNIQUE_ID_PREDECESSORS, list);
    }

    public void setUniqueIDSuccessors(List<Relation> list) {
        this.set((FieldType)TaskField.UNIQUE_ID_SUCCESSORS, list);
    }

    public void setUpdateNeeded(boolean val) {
        this.set((FieldType)TaskField.UPDATE_NEEDED, val);
    }

    public void setWBS(String val) {
        this.set((FieldType)TaskField.WBS, val);
    }

    public void setWork(Duration val) {
        this.set((FieldType)TaskField.WORK, val);
    }

    public void setWorkVariance(Duration val) {
        this.set((FieldType)TaskField.WORK_VARIANCE, val);
    }

    public Number getPercentageComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_COMPLETE);
    }

    public Number getPercentageWorkComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_WORK_COMPLETE);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_COST);
    }

    public Duration getActualDuration() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_DURATION);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_FINISH);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_START);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_WORK);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(TaskField.BASELINE_COST);
    }

    public Duration getBaselineDuration() {
        return (Duration)this.getCachedValue(TaskField.BASELINE_DURATION);
    }

    public Date getBaselineFinish() {
        return (Date)this.getCachedValue(TaskField.BASELINE_FINISH);
    }

    public Date getBaselineStart() {
        return (Date)this.getCachedValue(TaskField.BASELINE_START);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(TaskField.BASELINE_WORK);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(TaskField.BCWP);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(TaskField.BCWS);
    }

    public boolean getConfirmed() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.CONFIRMED));
    }

    public Date getConstraintDate() {
        return (Date)this.getCachedValue(TaskField.CONSTRAINT_DATE);
    }

    public ConstraintType getConstraintType() {
        return (ConstraintType)this.getCachedValue(TaskField.CONSTRAINT_TYPE);
    }

    public String getContact() {
        return (String)this.getCachedValue(TaskField.CONTACT);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(TaskField.COST);
    }

    public Number getCost1() {
        return (Number)this.getCachedValue(TaskField.COST1);
    }

    public Number getCost2() {
        return (Number)this.getCachedValue(TaskField.COST2);
    }

    public Number getCost3() {
        return (Number)this.getCachedValue(TaskField.COST3);
    }

    public Number getCostVariance() {
        Number variance = (Number)this.getCachedValue(TaskField.COST_VARIANCE);
        if (variance == null) {
            Number cost = this.getCost();
            Number baselineCost = this.getBaselineCost();
            if (cost != null && baselineCost != null) {
                variance = NumberUtility.getDouble(cost.doubleValue() - baselineCost.doubleValue());
                this.set((FieldType)TaskField.COST_VARIANCE, variance);
            }
        }
        return variance;
    }

    public Date getCreateDate() {
        return (Date)this.getCachedValue(TaskField.CREATED);
    }

    public boolean getCritical() {
        Boolean critical = (Boolean)this.getCachedValue(TaskField.CRITICAL);
        if (critical == null) {
            Duration totalSlack = this.getTotalSlack();
            critical = totalSlack != null && totalSlack.getDuration() <= 0.0 && NumberUtility.getInt(this.getPercentageComplete()) != 100;
            this.set((FieldType)TaskField.CRITICAL, critical);
        }
        return BooleanUtility.getBoolean(critical);
    }

    public Number getCV() {
        Number variance = (Number)this.getCachedValue(TaskField.CV);
        if (variance == null) {
            variance = NumberUtility.getDouble(this.getBCWP()) - NumberUtility.getDouble(this.getACWP());
            this.set((FieldType)TaskField.CV, variance);
        }
        return variance;
    }

    public Duration getLevelingDelay() {
        return (Duration)this.getCachedValue(TaskField.LEVELING_DELAY);
    }

    public Duration getDuration() {
        return (Duration)this.getCachedValue(TaskField.DURATION);
    }

    public Duration getDuration1() {
        return (Duration)this.getCachedValue(TaskField.DURATION1);
    }

    public Duration getDuration2() {
        return (Duration)this.getCachedValue(TaskField.DURATION2);
    }

    public Duration getDuration3() {
        return (Duration)this.getCachedValue(TaskField.DURATION3);
    }

    public Duration getDurationVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.DURATION_VARIANCE);
        if (variance == null) {
            Duration duration = this.getDuration();
            Duration baselineDuration = this.getBaselineDuration();
            if (duration != null && baselineDuration != null) {
                variance = Duration.getInstance(duration.getDuration() - baselineDuration.convertUnits(duration.getUnits(), this.getParentFile().getProjectHeader()).getDuration(), duration.getUnits());
                this.set((FieldType)TaskField.DURATION_VARIANCE, variance);
            }
        }
        return variance;
    }

    public Date getEarlyFinish() {
        return (Date)this.getCachedValue(TaskField.EARLY_FINISH);
    }

    public Date getEarlyStart() {
        return (Date)this.getCachedValue(TaskField.EARLY_START);
    }

    public Date getFinish() {
        return (Date)this.getCachedValue(TaskField.FINISH);
    }

    public Date getFinish1() {
        return (Date)this.getCachedValue(TaskField.FINISH1);
    }

    public Date getFinish2() {
        return (Date)this.getCachedValue(TaskField.FINISH2);
    }

    public Date getFinish3() {
        return (Date)this.getCachedValue(TaskField.FINISH3);
    }

    public Date getFinish4() {
        return (Date)this.getCachedValue(TaskField.FINISH4);
    }

    public Date getFinish5() {
        return (Date)this.getCachedValue(TaskField.FINISH5);
    }

    public Duration getFinishVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.FINISH_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            variance = DateUtility.getVariance(this, this.getBaselineFinish(), this.getFinish(), format);
            this.set((FieldType)TaskField.FINISH_VARIANCE, variance);
        }
        return variance;
    }

    public Number getFixedCost() {
        return (Number)this.getCachedValue(TaskField.FIXED_COST);
    }

    public boolean getFlag1() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG1));
    }

    public boolean getFlag2() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG2));
    }

    public boolean getFlag3() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG3));
    }

    public boolean getFlag4() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG4));
    }

    public boolean getFlag5() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG5));
    }

    public boolean getFlag6() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG6));
    }

    public boolean getFlag7() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG7));
    }

    public boolean getFlag8() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG8));
    }

    public boolean getFlag9() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG9));
    }

    public boolean getFlag10() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG10));
    }

    public Duration getFreeSlack() {
        return (Duration)this.getCachedValue(TaskField.FREE_SLACK);
    }

    public boolean getHideBar() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.HIDEBAR));
    }

    public Integer getID() {
        return (Integer)this.getCachedValue(TaskField.ID);
    }

    public Date getLateFinish() {
        return (Date)this.getCachedValue(TaskField.LATE_FINISH);
    }

    public Date getLateStart() {
        return (Date)this.getCachedValue(TaskField.LATE_START);
    }

    public boolean getLinkedFields() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.LINKED_FIELDS));
    }

    public boolean getMarked() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.MARKED));
    }

    public boolean getMilestone() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.MILESTONE));
    }

    public String getName() {
        return (String)this.getCachedValue(TaskField.NAME);
    }

    public String getNotes() {
        String notes = (String)this.getCachedValue(TaskField.NOTES);
        return notes == null ? "" : notes;
    }

    public Number getNumber1() {
        return (Number)this.getCachedValue(TaskField.NUMBER1);
    }

    public Number getNumber2() {
        return (Number)this.getCachedValue(TaskField.NUMBER2);
    }

    public Number getNumber3() {
        return (Number)this.getCachedValue(TaskField.NUMBER3);
    }

    public Number getNumber4() {
        return (Number)this.getCachedValue(TaskField.NUMBER4);
    }

    public Number getNumber5() {
        return (Number)this.getCachedValue(TaskField.NUMBER5);
    }

    public Integer getObjects() {
        return (Integer)this.getCachedValue(TaskField.OBJECTS);
    }

    public Integer getOutlineLevel() {
        return (Integer)this.getCachedValue(TaskField.OUTLINE_LEVEL);
    }

    public String getOutlineNumber() {
        return (String)this.getCachedValue(TaskField.OUTLINE_NUMBER);
    }

    public List<Relation> getPredecessors() {
        return (List)this.getCachedValue(TaskField.PREDECESSORS);
    }

    public Priority getPriority() {
        return (Priority)this.getCachedValue(TaskField.PRIORITY);
    }

    public String getProject() {
        return (String)this.getCachedValue(TaskField.PROJECT);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_COST);
    }

    public Duration getRemainingDuration() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_DURATION);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_WORK);
    }

    public String getResourceGroup() {
        return (String)this.getCachedValue(TaskField.RESOURCE_GROUP);
    }

    public String getResourceInitials() {
        return (String)this.getCachedValue(TaskField.RESOURCE_INITIALS);
    }

    public String getResourceNames() {
        return (String)this.getCachedValue(TaskField.RESOURCE_NAMES);
    }

    public Date getResume() {
        return (Date)this.getCachedValue(TaskField.RESUME);
    }

    public boolean getRollup() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.ROLLUP));
    }

    public Date getStart() {
        return (Date)this.getCachedValue(TaskField.START);
    }

    public Date getStart1() {
        return (Date)this.getCachedValue(TaskField.START1);
    }

    public Date getStart2() {
        return (Date)this.getCachedValue(TaskField.START2);
    }

    public Date getStart3() {
        return (Date)this.getCachedValue(TaskField.START3);
    }

    public Date getStart4() {
        return (Date)this.getCachedValue(TaskField.START4);
    }

    public Date getStart5() {
        return (Date)this.getCachedValue(TaskField.START5);
    }

    public Duration getStartVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.START_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            variance = DateUtility.getVariance(this, this.getBaselineStart(), this.getStart(), format);
            this.set((FieldType)TaskField.START_VARIANCE, variance);
        }
        return variance;
    }

    public Date getStop() {
        return (Date)this.getCachedValue(TaskField.STOP);
    }

    public String getSubprojectName() {
        return (String)this.getCachedValue(TaskField.SUBPROJECT_FILE);
    }

    public List<Relation> getSuccessors() {
        return (List)this.getCachedValue(TaskField.SUCCESSORS);
    }

    public boolean getSummary() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.SUMMARY));
    }

    public Number getSV() {
        Number variance = (Number)this.getCachedValue(TaskField.SV);
        if (variance == null) {
            Number bcwp = this.getBCWP();
            Number bcws = this.getBCWS();
            if (bcwp != null && bcws != null) {
                variance = NumberUtility.getDouble(bcwp.doubleValue() - bcws.doubleValue());
                this.set((FieldType)TaskField.SV, variance);
            }
        }
        return variance;
    }

    public String getText1() {
        return (String)this.getCachedValue(TaskField.TEXT1);
    }

    public String getText2() {
        return (String)this.getCachedValue(TaskField.TEXT2);
    }

    public String getText3() {
        return (String)this.getCachedValue(TaskField.TEXT3);
    }

    public String getText4() {
        return (String)this.getCachedValue(TaskField.TEXT4);
    }

    public String getText5() {
        return (String)this.getCachedValue(TaskField.TEXT5);
    }

    public String getText6() {
        return (String)this.getCachedValue(TaskField.TEXT6);
    }

    public String getText7() {
        return (String)this.getCachedValue(TaskField.TEXT7);
    }

    public String getText8() {
        return (String)this.getCachedValue(TaskField.TEXT8);
    }

    public String getText9() {
        return (String)this.getCachedValue(TaskField.TEXT9);
    }

    public String getText10() {
        return (String)this.getCachedValue(TaskField.TEXT10);
    }

    public Duration getTotalSlack() {
        Duration totalSlack = (Duration)this.getCachedValue(TaskField.TOTAL_SLACK);
        if (totalSlack == null) {
            Duration duration = this.getDuration();
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.DAYS);
            }
            TimeUnit units = duration.getUnits();
            Duration startSlack = this.getStartSlack();
            if (startSlack == null) {
                startSlack = Duration.getInstance(0, units);
            } else if (startSlack.getUnits() != units) {
                startSlack = startSlack.convertUnits(units, this.getParentFile().getProjectHeader());
            }
            Duration finishSlack = this.getFinishSlack();
            if (finishSlack == null) {
                finishSlack = Duration.getInstance(0, units);
            } else if (finishSlack.getUnits() != units) {
                finishSlack = finishSlack.convertUnits(units, this.getParentFile().getProjectHeader());
            }
            double startSlackDuration = startSlack.getDuration();
            double finishSlackDuration = finishSlack.getDuration();
            totalSlack = startSlackDuration == 0.0 || finishSlackDuration == 0.0 ? (startSlackDuration != 0.0 ? startSlack : finishSlack) : (startSlackDuration < finishSlackDuration ? startSlack : finishSlack);
            this.set((FieldType)TaskField.TOTAL_SLACK, totalSlack);
        }
        return totalSlack;
    }

    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(TaskField.UNIQUE_ID);
    }

    public List<Relation> getUniqueIDPredecessors() {
        return (List)this.getCachedValue(TaskField.UNIQUE_ID_PREDECESSORS);
    }

    public List<Relation> getUniqueIDSuccessors() {
        return (List)this.getCachedValue(TaskField.UNIQUE_ID_SUCCESSORS);
    }

    public boolean getUpdateNeeded() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.UPDATE_NEEDED));
    }

    public String getWBS() {
        return (String)this.getCachedValue(TaskField.WBS);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(TaskField.WORK);
    }

    public Duration getWorkVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.WORK_VARIANCE);
        if (variance == null) {
            Duration work = this.getWork();
            Duration baselineWork = this.getBaselineWork();
            if (work != null && baselineWork != null) {
                variance = Duration.getInstance(work.getDuration() - baselineWork.convertUnits(work.getUnits(), this.getParentFile().getProjectHeader()).getDuration(), work.getUnits());
                this.set((FieldType)TaskField.WORK_VARIANCE, variance);
            }
        }
        return variance;
    }

    int getChildTaskCount() {
        return this.m_children.size();
    }

    public Task getParentTask() {
        return this.m_parent;
    }

    public List<Task> getChildTasks() {
        return this.m_children;
    }

    @Override
    public int compareTo(Task o) {
        int id2;
        int id1 = NumberUtility.getInt(this.getID());
        return id1 < (id2 = NumberUtility.getInt(o.getID())) ? -1 : (id1 == id2 ? 0 : 1);
    }

    public boolean getEstimated() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.ESTIMATED));
    }

    public void setEstimated(boolean estimated) {
        this.set((FieldType)TaskField.ESTIMATED, estimated);
    }

    public Date getDeadline() {
        return (Date)this.getCachedValue(TaskField.DEADLINE);
    }

    public void setDeadline(Date deadline) {
        this.set((FieldType)TaskField.DEADLINE, deadline);
    }

    public TaskType getType() {
        return (TaskType)this.getCachedValue(TaskField.TYPE);
    }

    public void setType(TaskType type) {
        this.set((FieldType)TaskField.TYPE, type);
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setNull(boolean isNull) {
        this.m_null = isNull;
    }

    public String getWBSLevel() {
        return this.m_wbsLevel;
    }

    public void setWBSLevel(String wbsLevel) {
        this.m_wbsLevel = wbsLevel;
    }

    public TimeUnit getDurationFormat() {
        return this.m_durationFormat;
    }

    public void setDurationFormat(TimeUnit durationFormat) {
        this.m_durationFormat = durationFormat;
    }

    public boolean getResumeValid() {
        return this.m_resumeValid;
    }

    public void setResumeValid(boolean resumeValid) {
        this.m_resumeValid = resumeValid;
    }

    public boolean getRecurring() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.RECURRING));
    }

    public void setRecurring(boolean recurring) {
        this.set((FieldType)TaskField.RECURRING, recurring);
    }

    public boolean getOverAllocated() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.OVERALLOCATED));
    }

    public void setOverAllocated(boolean overAllocated) {
        this.set((FieldType)TaskField.OVERALLOCATED, overAllocated);
    }

    public Integer getSubprojectTaskUniqueID() {
        return this.m_subprojectTaskUniqueID;
    }

    public void setSubprojectTaskUniqueID(Integer subprojectUniqueTaskID) {
        this.m_subprojectTaskUniqueID = subprojectUniqueTaskID;
    }

    public Integer getSubprojectTaskID() {
        return this.m_subprojectTaskID;
    }

    public void setSubprojectTaskID(Integer subprojectTaskID) {
        this.m_subprojectTaskID = subprojectTaskID;
    }

    public void setSubprojectTasksUniqueIDOffset(Integer offset) {
        this.m_subprojectTasksUniqueIDOffset = offset;
    }

    public Integer getSubprojectTasksUniqueIDOffset() {
        return this.m_subprojectTasksUniqueIDOffset;
    }

    public boolean getSubprojectReadOnly() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.SUBPROJECT_READ_ONLY));
    }

    public void setSubprojectReadOnly(boolean subprojectReadOnly) {
        this.set((FieldType)TaskField.SUBPROJECT_READ_ONLY, subprojectReadOnly);
    }

    public boolean getExternalTask() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.EXTERNAL_TASK));
    }

    public void setExternalTask(boolean externalTask) {
        this.set((FieldType)TaskField.EXTERNAL_TASK, externalTask);
    }

    public String getExternalTaskProject() {
        return this.m_externalTaskProject;
    }

    public void setExternalTaskProject(String externalTaskProject) {
        this.m_externalTaskProject = externalTaskProject;
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(TaskField.ACWP);
    }

    public void setACWP(Number acwp) {
        this.set((FieldType)TaskField.ACWP, acwp);
    }

    public TimeUnit getLevelingDelayFormat() {
        return this.m_levelingDelayFormat;
    }

    public void setLevelingDelayFormat(TimeUnit levelingDelayFormat) {
        this.m_levelingDelayFormat = levelingDelayFormat;
    }

    public boolean getIgnoreResourceCalendar() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.IGNORE_RESOURCE_CALENDAR));
    }

    public void setIgnoreResourceCalendar(boolean ignoreResourceCalendar) {
        this.set((FieldType)TaskField.IGNORE_RESOURCE_CALENDAR, ignoreResourceCalendar);
    }

    public Integer getPhysicalPercentComplete() {
        return this.m_physicalPercentComplete;
    }

    public void setPhysicalPercentComplete(Integer physicalPercentComplete) {
        this.m_physicalPercentComplete = physicalPercentComplete;
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return this.m_earnedValueMethod;
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.m_earnedValueMethod = earnedValueMethod;
    }

    public Duration getActualWorkProtected() {
        return this.m_actualWorkProtected;
    }

    public void setActualWorkProtected(Duration actualWorkProtected) {
        this.m_actualWorkProtected = actualWorkProtected;
    }

    public Duration getActualOvertimeWorkProtected() {
        return this.m_actualOvertimeWorkProtected;
    }

    public void setActualOvertimeWorkProtected(Duration actualOvertimeWorkProtected) {
        this.m_actualOvertimeWorkProtected = actualOvertimeWorkProtected;
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(TaskField.REGULAR_WORK);
    }

    public void setRegularWork(Duration regularWork) {
        this.set((FieldType)TaskField.REGULAR_WORK, regularWork);
    }

    public boolean getFlag11() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG11));
    }

    public boolean getFlag12() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG12));
    }

    public boolean getFlag13() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG13));
    }

    public boolean getFlag14() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG14));
    }

    public boolean getFlag15() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG15));
    }

    public boolean getFlag16() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG16));
    }

    public boolean getFlag17() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG17));
    }

    public boolean getFlag18() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG18));
    }

    public boolean getFlag19() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG19));
    }

    public boolean getFlag20() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG20));
    }

    public void setFlag11(boolean b) {
        this.set((FieldType)TaskField.FLAG11, b);
    }

    public void setFlag12(boolean b) {
        this.set((FieldType)TaskField.FLAG12, b);
    }

    public void setFlag13(boolean b) {
        this.set((FieldType)TaskField.FLAG13, b);
    }

    public void setFlag14(boolean b) {
        this.set((FieldType)TaskField.FLAG14, b);
    }

    public void setFlag15(boolean b) {
        this.set((FieldType)TaskField.FLAG15, b);
    }

    public void setFlag16(boolean b) {
        this.set((FieldType)TaskField.FLAG16, b);
    }

    public void setFlag17(boolean b) {
        this.set((FieldType)TaskField.FLAG17, b);
    }

    public void setFlag18(boolean b) {
        this.set((FieldType)TaskField.FLAG18, b);
    }

    public void setFlag19(boolean b) {
        this.set((FieldType)TaskField.FLAG19, b);
    }

    public void setFlag20(boolean b) {
        this.set((FieldType)TaskField.FLAG20, b);
    }

    public void setEffortDriven(boolean flag) {
        this.set((FieldType)TaskField.EFFORT_DRIVEN, flag);
    }

    public boolean getEffortDriven() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.EFFORT_DRIVEN));
    }

    public String getText11() {
        return (String)this.getCachedValue(TaskField.TEXT11);
    }

    public String getText12() {
        return (String)this.getCachedValue(TaskField.TEXT12);
    }

    public String getText13() {
        return (String)this.getCachedValue(TaskField.TEXT13);
    }

    public String getText14() {
        return (String)this.getCachedValue(TaskField.TEXT14);
    }

    public String getText15() {
        return (String)this.getCachedValue(TaskField.TEXT15);
    }

    public String getText16() {
        return (String)this.getCachedValue(TaskField.TEXT16);
    }

    public String getText17() {
        return (String)this.getCachedValue(TaskField.TEXT17);
    }

    public String getText18() {
        return (String)this.getCachedValue(TaskField.TEXT18);
    }

    public String getText19() {
        return (String)this.getCachedValue(TaskField.TEXT19);
    }

    public String getText20() {
        return (String)this.getCachedValue(TaskField.TEXT20);
    }

    public String getText21() {
        return (String)this.getCachedValue(TaskField.TEXT21);
    }

    public String getText22() {
        return (String)this.getCachedValue(TaskField.TEXT22);
    }

    public String getText23() {
        return (String)this.getCachedValue(TaskField.TEXT23);
    }

    public String getText24() {
        return (String)this.getCachedValue(TaskField.TEXT24);
    }

    public String getText25() {
        return (String)this.getCachedValue(TaskField.TEXT25);
    }

    public String getText26() {
        return (String)this.getCachedValue(TaskField.TEXT26);
    }

    public String getText27() {
        return (String)this.getCachedValue(TaskField.TEXT27);
    }

    public String getText28() {
        return (String)this.getCachedValue(TaskField.TEXT28);
    }

    public String getText29() {
        return (String)this.getCachedValue(TaskField.TEXT29);
    }

    public String getText30() {
        return (String)this.getCachedValue(TaskField.TEXT30);
    }

    public void setText11(String string) {
        this.set((FieldType)TaskField.TEXT11, string);
    }

    public void setText12(String string) {
        this.set((FieldType)TaskField.TEXT12, string);
    }

    public void setText13(String string) {
        this.set((FieldType)TaskField.TEXT13, string);
    }

    public void setText14(String string) {
        this.set((FieldType)TaskField.TEXT14, string);
    }

    public void setText15(String string) {
        this.set((FieldType)TaskField.TEXT15, string);
    }

    public void setText16(String string) {
        this.set((FieldType)TaskField.TEXT16, string);
    }

    public void setText17(String string) {
        this.set((FieldType)TaskField.TEXT17, string);
    }

    public void setText18(String string) {
        this.set((FieldType)TaskField.TEXT18, string);
    }

    public void setText19(String string) {
        this.set((FieldType)TaskField.TEXT19, string);
    }

    public void setText20(String string) {
        this.set((FieldType)TaskField.TEXT20, string);
    }

    public void setText21(String string) {
        this.set((FieldType)TaskField.TEXT21, string);
    }

    public void setText22(String string) {
        this.set((FieldType)TaskField.TEXT22, string);
    }

    public void setText23(String string) {
        this.set((FieldType)TaskField.TEXT23, string);
    }

    public void setText24(String string) {
        this.set((FieldType)TaskField.TEXT24, string);
    }

    public void setText25(String string) {
        this.set((FieldType)TaskField.TEXT25, string);
    }

    public void setText26(String string) {
        this.set((FieldType)TaskField.TEXT26, string);
    }

    public void setText27(String string) {
        this.set((FieldType)TaskField.TEXT27, string);
    }

    public void setText28(String string) {
        this.set((FieldType)TaskField.TEXT28, string);
    }

    public void setText29(String string) {
        this.set((FieldType)TaskField.TEXT29, string);
    }

    public void setText30(String string) {
        this.set((FieldType)TaskField.TEXT30, string);
    }

    public void setNumber6(Number val) {
        this.set((FieldType)TaskField.NUMBER6, val);
    }

    public Number getNumber6() {
        return (Number)this.getCachedValue(TaskField.NUMBER6);
    }

    public void setNumber7(Number val) {
        this.set((FieldType)TaskField.NUMBER7, val);
    }

    public Number getNumber7() {
        return (Number)this.getCachedValue(TaskField.NUMBER7);
    }

    public void setNumber8(Number val) {
        this.set((FieldType)TaskField.NUMBER8, val);
    }

    public Number getNumber8() {
        return (Number)this.getCachedValue(TaskField.NUMBER8);
    }

    public void setNumber9(Number val) {
        this.set((FieldType)TaskField.NUMBER9, val);
    }

    public Number getNumber9() {
        return (Number)this.getCachedValue(TaskField.NUMBER9);
    }

    public void setNumber10(Number val) {
        this.set((FieldType)TaskField.NUMBER10, val);
    }

    public Number getNumber10() {
        return (Number)this.getCachedValue(TaskField.NUMBER10);
    }

    public void setNumber11(Number val) {
        this.set((FieldType)TaskField.NUMBER11, val);
    }

    public Number getNumber11() {
        return (Number)this.getCachedValue(TaskField.NUMBER11);
    }

    public void setNumber12(Number val) {
        this.set((FieldType)TaskField.NUMBER12, val);
    }

    public Number getNumber12() {
        return (Number)this.getCachedValue(TaskField.NUMBER12);
    }

    public void setNumber13(Number val) {
        this.set((FieldType)TaskField.NUMBER13, val);
    }

    public Number getNumber13() {
        return (Number)this.getCachedValue(TaskField.NUMBER13);
    }

    public void setNumber14(Number val) {
        this.set((FieldType)TaskField.NUMBER14, val);
    }

    public Number getNumber14() {
        return (Number)this.getCachedValue(TaskField.NUMBER14);
    }

    public void setNumber15(Number val) {
        this.set((FieldType)TaskField.NUMBER15, val);
    }

    public Number getNumber15() {
        return (Number)this.getCachedValue(TaskField.NUMBER15);
    }

    public void setNumber16(Number val) {
        this.set((FieldType)TaskField.NUMBER16, val);
    }

    public Number getNumber16() {
        return (Number)this.getCachedValue(TaskField.NUMBER16);
    }

    public void setNumber17(Number val) {
        this.set((FieldType)TaskField.NUMBER17, val);
    }

    public Number getNumber17() {
        return (Number)this.getCachedValue(TaskField.NUMBER17);
    }

    public void setNumber18(Number val) {
        this.set((FieldType)TaskField.NUMBER18, val);
    }

    public Number getNumber18() {
        return (Number)this.getCachedValue(TaskField.NUMBER18);
    }

    public void setNumber19(Number val) {
        this.set((FieldType)TaskField.NUMBER19, val);
    }

    public Number getNumber19() {
        return (Number)this.getCachedValue(TaskField.NUMBER19);
    }

    public void setNumber20(Number val) {
        this.set((FieldType)TaskField.NUMBER20, val);
    }

    public Number getNumber20() {
        return (Number)this.getCachedValue(TaskField.NUMBER20);
    }

    public Duration getDuration10() {
        return (Duration)this.getCachedValue(TaskField.DURATION10);
    }

    public Duration getDuration4() {
        return (Duration)this.getCachedValue(TaskField.DURATION4);
    }

    public Duration getDuration5() {
        return (Duration)this.getCachedValue(TaskField.DURATION5);
    }

    public Duration getDuration6() {
        return (Duration)this.getCachedValue(TaskField.DURATION6);
    }

    public Duration getDuration7() {
        return (Duration)this.getCachedValue(TaskField.DURATION7);
    }

    public Duration getDuration8() {
        return (Duration)this.getCachedValue(TaskField.DURATION8);
    }

    public Duration getDuration9() {
        return (Duration)this.getCachedValue(TaskField.DURATION9);
    }

    public void setDuration10(Duration duration) {
        this.set((FieldType)TaskField.DURATION10, duration);
    }

    public void setDuration4(Duration duration) {
        this.set((FieldType)TaskField.DURATION4, duration);
    }

    public void setDuration5(Duration duration) {
        this.set((FieldType)TaskField.DURATION5, duration);
    }

    public void setDuration6(Duration duration) {
        this.set((FieldType)TaskField.DURATION6, duration);
    }

    public void setDuration7(Duration duration) {
        this.set((FieldType)TaskField.DURATION7, duration);
    }

    public void setDuration8(Duration duration) {
        this.set((FieldType)TaskField.DURATION8, duration);
    }

    public void setDuration9(Duration duration) {
        this.set((FieldType)TaskField.DURATION9, duration);
    }

    public Date getDate1() {
        return (Date)this.getCachedValue(TaskField.DATE1);
    }

    public Date getDate10() {
        return (Date)this.getCachedValue(TaskField.DATE10);
    }

    public Date getDate2() {
        return (Date)this.getCachedValue(TaskField.DATE2);
    }

    public Date getDate3() {
        return (Date)this.getCachedValue(TaskField.DATE3);
    }

    public Date getDate4() {
        return (Date)this.getCachedValue(TaskField.DATE4);
    }

    public Date getDate5() {
        return (Date)this.getCachedValue(TaskField.DATE5);
    }

    public Date getDate6() {
        return (Date)this.getCachedValue(TaskField.DATE6);
    }

    public Date getDate7() {
        return (Date)this.getCachedValue(TaskField.DATE7);
    }

    public Date getDate8() {
        return (Date)this.getCachedValue(TaskField.DATE8);
    }

    public Date getDate9() {
        return (Date)this.getCachedValue(TaskField.DATE9);
    }

    public void setDate1(Date date) {
        this.set((FieldType)TaskField.DATE1, date);
    }

    public void setDate10(Date date) {
        this.set((FieldType)TaskField.DATE10, date);
    }

    public void setDate2(Date date) {
        this.set((FieldType)TaskField.DATE2, date);
    }

    public void setDate3(Date date) {
        this.set((FieldType)TaskField.DATE3, date);
    }

    public void setDate4(Date date) {
        this.set((FieldType)TaskField.DATE4, date);
    }

    public void setDate5(Date date) {
        this.set((FieldType)TaskField.DATE5, date);
    }

    public void setDate6(Date date) {
        this.set((FieldType)TaskField.DATE6, date);
    }

    public void setDate7(Date date) {
        this.set((FieldType)TaskField.DATE7, date);
    }

    public void setDate8(Date date) {
        this.set((FieldType)TaskField.DATE8, date);
    }

    public void setDate9(Date date) {
        this.set((FieldType)TaskField.DATE9, date);
    }

    public Number getCost10() {
        return (Number)this.getCachedValue(TaskField.COST10);
    }

    public Number getCost4() {
        return (Number)this.getCachedValue(TaskField.COST4);
    }

    public Number getCost5() {
        return (Number)this.getCachedValue(TaskField.COST5);
    }

    public Number getCost6() {
        return (Number)this.getCachedValue(TaskField.COST6);
    }

    public Number getCost7() {
        return (Number)this.getCachedValue(TaskField.COST7);
    }

    public Number getCost8() {
        return (Number)this.getCachedValue(TaskField.COST8);
    }

    public Number getCost9() {
        return (Number)this.getCachedValue(TaskField.COST9);
    }

    public void setCost10(Number number) {
        this.set((FieldType)TaskField.COST10, number);
    }

    public void setCost4(Number number) {
        this.set((FieldType)TaskField.COST4, number);
    }

    public void setCost5(Number number) {
        this.set((FieldType)TaskField.COST5, number);
    }

    public void setCost6(Number number) {
        this.set((FieldType)TaskField.COST6, number);
    }

    public void setCost7(Number number) {
        this.set((FieldType)TaskField.COST7, number);
    }

    public void setCost8(Number number) {
        this.set((FieldType)TaskField.COST8, number);
    }

    public void setCost9(Number number) {
        this.set((FieldType)TaskField.COST9, number);
    }

    public Date getStart10() {
        return (Date)this.getCachedValue(TaskField.START10);
    }

    public Date getStart6() {
        return (Date)this.getCachedValue(TaskField.START6);
    }

    public Date getStart7() {
        return (Date)this.getCachedValue(TaskField.START7);
    }

    public Date getStart8() {
        return (Date)this.getCachedValue(TaskField.START8);
    }

    public Date getStart9() {
        return (Date)this.getCachedValue(TaskField.START9);
    }

    public void setStart10(Date date) {
        this.set((FieldType)TaskField.START10, date);
    }

    public void setStart6(Date date) {
        this.set((FieldType)TaskField.START6, date);
    }

    public void setStart7(Date date) {
        this.set((FieldType)TaskField.START7, date);
    }

    public void setStart8(Date date) {
        this.set((FieldType)TaskField.START8, date);
    }

    public void setStart9(Date date) {
        this.set((FieldType)TaskField.START9, date);
    }

    public Date getFinish10() {
        return (Date)this.getCachedValue(TaskField.FINISH10);
    }

    public Date getFinish6() {
        return (Date)this.getCachedValue(TaskField.FINISH6);
    }

    public Date getFinish7() {
        return (Date)this.getCachedValue(TaskField.FINISH7);
    }

    public Date getFinish8() {
        return (Date)this.getCachedValue(TaskField.FINISH8);
    }

    public Date getFinish9() {
        return (Date)this.getCachedValue(TaskField.FINISH9);
    }

    public void setFinish10(Date date) {
        this.set((FieldType)TaskField.FINISH10, date);
    }

    public void setFinish6(Date date) {
        this.set((FieldType)TaskField.FINISH6, date);
    }

    public void setFinish7(Date date) {
        this.set((FieldType)TaskField.FINISH7, date);
    }

    public void setFinish8(Date date) {
        this.set((FieldType)TaskField.FINISH8, date);
    }

    public void setFinish9(Date date) {
        this.set((FieldType)TaskField.FINISH9, date);
    }

    public Number getOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number number) {
        this.set((FieldType)TaskField.OVERTIME_COST, number);
    }

    public void setOutlineCode1(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE1, value);
    }

    public String getOutlineCode1() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE1);
    }

    public void setOutlineCode2(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE2, value);
    }

    public String getOutlineCode2() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE2);
    }

    public void setOutlineCode3(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE3, value);
    }

    public String getOutlineCode3() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE3);
    }

    public void setOutlineCode4(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE4, value);
    }

    public String getOutlineCode4() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE4);
    }

    public void setOutlineCode5(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE5, value);
    }

    public String getOutlineCode5() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE5);
    }

    public void setOutlineCode6(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE6, value);
    }

    public String getOutlineCode6() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE6);
    }

    public void setOutlineCode7(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE7, value);
    }

    public String getOutlineCode7() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE7);
    }

    public void setOutlineCode8(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE8, value);
    }

    public String getOutlineCode8() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE8);
    }

    public void setOutlineCode9(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE9, value);
    }

    public String getOutlineCode9() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE9);
    }

    public void setOutlineCode10(String value) {
        this.set((FieldType)TaskField.OUTLINE_CODE10, value);
    }

    public String getOutlineCode10() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE10);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number cost) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_COST, cost);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_WORK, work);
    }

    public AccrueType getFixedCostAccrual() {
        return (AccrueType)this.getCachedValue(TaskField.FIXED_COST_ACCRUAL);
    }

    public void setFixedCostAccrual(AccrueType type) {
        this.set((FieldType)TaskField.FIXED_COST_ACCRUAL, type);
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(TaskField.HYPERLINK);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_ADDRESS);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlink(String text) {
        this.set((FieldType)TaskField.HYPERLINK, text);
    }

    public void setHyperlinkAddress(String text) {
        this.set((FieldType)TaskField.HYPERLINK_ADDRESS, text);
    }

    public void setHyperlinkSubAddress(String text) {
        this.set((FieldType)TaskField.HYPERLINK_SUBADDRESS, text);
    }

    public boolean getLevelAssignments() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.LEVEL_ASSIGNMENTS));
    }

    public void setLevelAssignments(boolean flag) {
        this.set((FieldType)TaskField.LEVEL_ASSIGNMENTS, flag);
    }

    public boolean getLevelingCanSplit() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.LEVELING_CAN_SPLIT));
    }

    public void setLevelingCanSplit(boolean flag) {
        this.set((FieldType)TaskField.LEVELING_CAN_SPLIT, flag);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.OVERTIME_WORK);
    }

    public void setOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.OVERTIME_WORK, work);
    }

    public Date getPreleveledStart() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_START);
    }

    public Date getPreleveledFinish() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_FINISH);
    }

    public void setPreleveledStart(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_START, date);
    }

    public void setPreleveledFinish(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_FINISH, date);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_WORK, work);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number cost) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_COST, cost);
    }

    public ProjectCalendar getCalendar() {
        return (ProjectCalendar)this.getCachedValue(TaskField.CALENDAR);
    }

    public void setCalendar(ProjectCalendar calendar) {
        this.set((FieldType)TaskField.CALENDAR, calendar);
    }

    public boolean getExpanded() {
        return this.m_expanded;
    }

    public void setExpanded(boolean expanded) {
        this.m_expanded = expanded;
    }

    public void setStartSlack(Duration duration) {
        this.set((FieldType)TaskField.START_SLACK, duration);
    }

    public void setFinishSlack(Duration duration) {
        this.set((FieldType)TaskField.FINISH_SLACK, duration);
    }

    public Duration getStartSlack() {
        Duration duration;
        Duration startSlack = (Duration)this.getCachedValue(TaskField.START_SLACK);
        if (startSlack == null && (duration = this.getDuration()) != null) {
            startSlack = DateUtility.getVariance(this, this.getLateStart(), this.getEarlyStart(), duration.getUnits());
            this.set((FieldType)TaskField.START_SLACK, startSlack);
        }
        return startSlack;
    }

    public Duration getFinishSlack() {
        Duration duration;
        Duration finishSlack = (Duration)this.getCachedValue(TaskField.FINISH_SLACK);
        if (finishSlack == null && (duration = this.getDuration()) != null) {
            finishSlack = DateUtility.getVariance(this, this.getLateFinish(), this.getEarlyFinish(), duration.getUnits());
            this.set((FieldType)TaskField.FINISH_SLACK, finishSlack);
        }
        return finishSlack;
    }

    public Object getFieldByAlias(String alias) {
        return this.getCachedValue(this.getParentFile().getAliasTaskField(alias));
    }

    public void setFieldByAlias(String alias, Object value) {
        this.set((FieldType)this.getParentFile().getAliasTaskField(alias), value);
    }

    public List<DateRange> getSplits() {
        return this.m_splits;
    }

    public void setSplits(List<DateRange> splits) {
        this.m_splits = splits;
    }

    public Date getSplitCompleteDuration() {
        return this.m_splitsComplete;
    }

    public void setSplitCompleteDuration(Date splitsComplete) {
        this.m_splitsComplete = splitsComplete;
    }

    public void remove() {
        this.getParentFile().removeTask(this);
    }

    public SubProject getSubProject() {
        return this.m_subProject;
    }

    public void setSubProject(SubProject subProject) {
        this.m_subProject = subProject;
    }

    public Integer getExternalTaskID() {
        return this.m_externalTaskID;
    }

    public void setExternalTaskID(Integer externalTaskID) {
        this.m_externalTaskID = externalTaskID;
    }

    public Number getEnterpriseCost(int index) {
        return (Number)this.getCachedValue(this.selectTaskField(ENTERPRISE_COST_FIELDS, index));
    }

    public void setEnterpriseCost(int index, Number value) {
        this.set((FieldType)this.selectTaskField(ENTERPRISE_COST_FIELDS, index), value);
    }

    public Date getEnterpriseDate(int index) {
        return (Date)this.getCachedValue(this.selectTaskField(ENTERPRISE_DATE_FIELDS, index));
    }

    public void setEnterpriseDate(int index, Date value) {
        this.set((FieldType)this.selectTaskField(ENTERPRISE_DATE_FIELDS, index), value);
    }

    public Duration getEnterpriseDuration(int index) {
        return (Duration)this.getCachedValue(this.selectTaskField(ENTERPRISE_DURATION_FIELDS, index));
    }

    public void setEnterpriseDuration(int index, Duration value) {
        this.set((FieldType)this.selectTaskField(ENTERPRISE_DURATION_FIELDS, index), value);
    }

    public boolean getEnterpriseFlag(int index) {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(this.selectTaskField(ENTERPRISE_FLAG_FIELDS, index)));
    }

    public void setEnterpriseFlag(int index, boolean value) {
        this.set((FieldType)this.selectTaskField(ENTERPRISE_FLAG_FIELDS, index), value);
    }

    public Number getEnterpriseNumber(int index) {
        return (Number)this.getCachedValue(this.selectTaskField(ENTERPRISE_NUMBER_FIELDS, index));
    }

    public void setEnterpriseNumber(int index, Number value) {
        this.set((FieldType)this.selectTaskField(ENTERPRISE_NUMBER_FIELDS, index), value);
    }

    public String getEnterpriseText(int index) {
        return (String)this.getCachedValue(this.selectTaskField(ENTERPRISE_TEXT_FIELDS, index));
    }

    public void setEnterpriseText(int index, String value) {
        this.set((FieldType)this.selectTaskField(ENTERPRISE_TEXT_FIELDS, index), value);
    }

    public void setBaselineCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectTaskField(BASELINE_COSTS, baselineNumber), value);
    }

    public void setBaselineDuration(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectTaskField(BASELINE_DURATIONS, baselineNumber), value);
    }

    public void setBaselineFinish(int baselineNumber, Date value) {
        this.set((FieldType)this.selectTaskField(BASELINE_FINISHES, baselineNumber), value);
    }

    public void setBaselineStart(int baselineNumber, Date value) {
        this.set((FieldType)this.selectTaskField(BASELINE_STARTS, baselineNumber), value);
    }

    public void setBaselineWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectTaskField(BASELINE_WORKS, baselineNumber), value);
    }

    public Number getBaselineCost(int baselineNumber) {
        return (Number)this.getCachedValue(this.selectTaskField(BASELINE_COSTS, baselineNumber));
    }

    public Duration getBaselineDuration(int baselineNumber) {
        return (Duration)this.getCachedValue(this.selectTaskField(BASELINE_DURATIONS, baselineNumber));
    }

    public Date getBaselineFinish(int baselineNumber) {
        return (Date)this.getCachedValue(this.selectTaskField(BASELINE_FINISHES, baselineNumber));
    }

    public Date getBaselineStart(int baselineNumber) {
        return (Date)this.getCachedValue(this.selectTaskField(BASELINE_STARTS, baselineNumber));
    }

    public Duration getBaselineWork(int baselineNumber) {
        return (Duration)this.getCachedValue(this.selectTaskField(BASELINE_WORKS, baselineNumber));
    }

    public Date getCompleteThrough() {
        Date value = (Date)this.getCachedValue(TaskField.COMPLETE_THROUGH);
        if (value == null) {
            int percentComplete = NumberUtility.getInt(this.getPercentageComplete());
            switch (percentComplete) {
                case 0: {
                    break;
                }
                case 100: {
                    value = this.getActualFinish();
                    break;
                }
                default: {
                    Duration duration = this.getDuration();
                    double durationValue = duration.getDuration() * (double)percentComplete / 100.0;
                    duration = Duration.getInstance(durationValue, duration.getUnits());
                    ProjectCalendar calendar = this.getCalendar();
                    if (calendar == null) {
                        calendar = this.getParentFile().getCalendar();
                    }
                    value = calendar.getDate(this.getActualStart(), duration, true);
                    break;
                }
            }
            this.set((FieldType)TaskField.COMPLETE_THROUGH, value);
        }
        return value;
    }

    public Date getSummaryProgress() {
        Date value = (Date)this.getCachedValue(TaskField.SUMMARY_PROGRESS);
        return value;
    }

    public void setSummaryProgress(Date value) {
        this.set((FieldType)TaskField.SUMMARY_PROGRESS, value);
    }

    private TaskField selectTaskField(TaskField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return field == null ? null : this.m_array[field.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType field) {
        Object result = null;
        if (field != null) {
            int fieldValue = field.getValue();
            switch (fieldValue) {
                case 43: {
                    result = this.getStartVariance();
                    break;
                }
                case 9: {
                    result = this.getCostVariance();
                    break;
                }
                case 29: {
                    result = this.getDurationVariance();
                    break;
                }
                case 3: {
                    result = this.getWorkVariance();
                    break;
                }
                case 81: {
                    result = this.getCV();
                    break;
                }
                case 13: {
                    result = this.getSV();
                    break;
                }
                case 21: {
                    result = this.getTotalSlack();
                    break;
                }
                case 18: {
                    result = this.getCritical();
                    break;
                }
                case 443: {
                    result = this.getCompleteThrough();
                    break;
                }
                default: {
                    result = this.m_array[fieldValue];
                }
            }
        }
        return result;
    }

    @Override
    public void set(FieldType field, Object value) {
        if (field != null) {
            int index = field.getValue();
            this.fireFieldChangeEvent(field, this.m_array[index], value);
            this.m_array[index] = value;
        }
    }

    private void fireFieldChangeEvent(FieldType field, Object oldValue, Object newValue) {
        switch (field.getValue()) {
            case 33: 
            case 41: {
                this.m_array[43] = null;
                break;
            }
            case 34: 
            case 42: {
                this.m_array[44] = null;
                break;
            }
            case 5: 
            case 6: {
                this.m_array[9] = null;
                break;
            }
            case 28: {
                this.m_array[29] = null;
                this.m_array[443] = null;
                break;
            }
            case 26: {
                this.m_array[29] = null;
                break;
            }
            case 0: 
            case 1: {
                this.m_array[3] = null;
                break;
            }
            case 11: 
            case 111: {
                this.m_array[81] = null;
                this.m_array[13] = null;
                break;
            }
            case 12: {
                this.m_array[13] = null;
                break;
            }
            case 236: 
            case 237: {
                this.m_array[21] = null;
                this.m_array[18] = null;
                break;
            }
            case 36: 
            case 38: {
                this.m_array[237] = null;
                this.m_array[21] = null;
                this.m_array[18] = null;
                break;
            }
            case 35: 
            case 37: {
                this.m_array[236] = null;
                this.m_array[21] = null;
                this.m_array[18] = null;
                break;
            }
            case 31: 
            case 39: {
                this.m_array[443] = null;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener listener : this.m_listeners) {
                listener.fieldChange(this, field, oldValue, newValue);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public String toString() {
        SubProject externalTask = this.getSubProject();
        return "[Task id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + (this.getExternalTask() ? " [EXTERNAL " + externalTask.getFullPath() + " " + this.getExternalTaskID() + "]" : "") + "]";
    }
}

