/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimephasedResourceAssignment;
import net.sf.mpxj.TimephasedResourceAssignmentNormaliser;
import net.sf.mpxj.WorkContour;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceAssignment
extends ProjectEntity {
    private Number m_units;
    private Duration m_work;
    private Duration m_plannedWork;
    private Duration m_actualWork;
    private Duration m_overtimeWork;
    private Number m_cost;
    private Number m_plannedCost;
    private Number m_actualCost;
    private Date m_start;
    private Date m_finish;
    private Duration m_delay;
    private Integer m_resourceUniqueID;
    private LinkedList<TimephasedResourceAssignment> m_timephasedComplete;
    private LinkedList<TimephasedResourceAssignment> m_timephasedPlanned;
    private boolean m_timephasedCompleteRaw;
    private boolean m_timephasedPlannedRaw;
    private TimephasedResourceAssignmentNormaliser m_timephasedNormaliser;
    private Duration m_remainingWork;
    private Task m_task;
    private ResourceAssignmentWorkgroupFields m_workgroup;
    private WorkContour m_workContour;
    public static final Double DEFAULT_UNITS = 100.0;

    ResourceAssignment(ProjectFile file, Task task) {
        super(file);
        this.m_task = task;
    }

    public ResourceAssignmentWorkgroupFields addWorkgroupAssignment() throws MPXJException {
        if (this.m_workgroup != null) {
            throw new MPXJException("Maximum number of records of this type exist");
        }
        this.m_workgroup = new ResourceAssignmentWorkgroupFields();
        return this.m_workgroup;
    }

    public Number getUnits() {
        return this.m_units;
    }

    public void setUnits(Number val) {
        this.m_units = val;
    }

    public Duration getWork() {
        return this.m_work;
    }

    public void setWork(Duration dur) {
        this.m_work = dur;
    }

    public Duration getPlannedWork() {
        return this.m_plannedWork;
    }

    public void setPlannedWork(Duration dur) {
        this.m_plannedWork = dur;
    }

    public Duration getActualWork() {
        return this.m_actualWork;
    }

    public void setActualWork(Duration dur) {
        this.m_actualWork = dur;
    }

    public Duration getOvertimeWork() {
        return this.m_overtimeWork;
    }

    public void setOvertimeWork(Duration dur) {
        this.m_overtimeWork = dur;
    }

    public Number getCost() {
        return this.m_cost;
    }

    public void setCost(Number val) {
        this.m_cost = val;
    }

    public Number getPlannedCost() {
        return this.m_plannedCost;
    }

    public void setPlannedCost(Number val) {
        this.m_plannedCost = val;
    }

    public Number getActualCost() {
        return this.m_actualCost;
    }

    public void setActualCost(Number val) {
        this.m_actualCost = val;
    }

    public Date getStart() {
        return this.m_start;
    }

    public void setStart(Date val) {
        this.m_start = val;
    }

    public Date getFinish() {
        return this.m_finish;
    }

    public void setFinish(Date val) {
        this.m_finish = val;
    }

    public Duration getDelay() {
        return this.m_delay;
    }

    public void setDelay(Duration dur) {
        this.m_delay = dur;
    }

    public Integer getResourceUniqueID() {
        return this.m_resourceUniqueID;
    }

    public void setResourceUniqueID(Integer val) {
        if (val != null) {
            this.m_resourceUniqueID = val;
        }
    }

    public ResourceAssignmentWorkgroupFields getWorkgroupAssignment() {
        return this.m_workgroup;
    }

    public Task getTask() {
        return this.m_task;
    }

    public Resource getResource() {
        return this.getParentFile().getResourceByUniqueID(this.getResourceUniqueID());
    }

    public WorkContour getWorkContour() {
        return this.m_workContour;
    }

    public void setWorkContour(WorkContour workContour) {
        this.m_workContour = workContour;
    }

    public void remove() {
        this.getParentFile().removeResourceAssignment(this);
    }

    public Duration getRemainingWork() {
        return this.m_remainingWork;
    }

    public void setRemainingWork(Duration remainingWork) {
        this.m_remainingWork = remainingWork;
    }

    public List<TimephasedResourceAssignment> getTimephasedComplete() {
        if (this.m_timephasedCompleteRaw) {
            this.m_timephasedNormaliser.normalise(this.getCalendar(), this.m_timephasedComplete);
            this.m_timephasedCompleteRaw = false;
        }
        return this.m_timephasedComplete;
    }

    public void setTimephasedComplete(List<TimephasedResourceAssignment> timephasedComplete, boolean raw) {
        this.m_timephasedComplete = timephasedComplete instanceof LinkedList ? (LinkedList<Object>)timephasedComplete : new LinkedList<TimephasedResourceAssignment>(timephasedComplete);
        this.m_timephasedCompleteRaw = raw;
    }

    public List<TimephasedResourceAssignment> getTimephasedPlanned() {
        if (this.m_timephasedPlannedRaw) {
            this.m_timephasedNormaliser.normalise(this.getCalendar(), this.m_timephasedPlanned);
            this.m_timephasedPlannedRaw = false;
        }
        return this.m_timephasedPlanned;
    }

    public void setTimephasedPlanned(List<TimephasedResourceAssignment> timephasedPlanned, boolean raw) {
        this.m_timephasedPlanned = timephasedPlanned instanceof LinkedList ? (LinkedList<Object>)timephasedPlanned : new LinkedList<TimephasedResourceAssignment>(timephasedPlanned);
        this.m_timephasedPlannedRaw = raw;
    }

    public void setTimephasedNormaliser(TimephasedResourceAssignmentNormaliser normaliser) {
        this.m_timephasedNormaliser = normaliser;
    }

    public boolean getHasTimephasedData() {
        return this.m_timephasedPlanned != null && !this.m_timephasedPlanned.isEmpty() || this.m_timephasedComplete != null && !this.m_timephasedComplete.isEmpty();
    }

    public ProjectCalendar getCalendar() {
        ProjectCalendar calendar = null;
        Resource resource = this.getResource();
        if (resource != null) {
            calendar = resource.getResourceCalendar();
        }
        if (calendar == null) {
            Task task = this.getTask();
            task.getCalendar();
        }
        if (calendar == null) {
            calendar = this.getParentFile().getCalendar();
        }
        return calendar;
    }

    public String toString() {
        return "[Resource Assignment task=" + this.m_task.getName() + " resource=" + this.getResource().getName() + " start=" + this.m_start + " finish=" + this.m_finish + " duration=" + this.m_work + " workContour=" + this.m_workContour + "]";
    }
}

