/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Resource;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectCalendar
extends ProjectEntity {
    private Integer m_uniqueID = 0;
    private String m_name;
    private ProjectCalendar m_baseCalendar;
    private int[] m_days = new int[7];
    private LinkedList<ProjectCalendarException> m_exceptions = new LinkedList();
    private ProjectCalendarHours[] m_hours = new ProjectCalendarHours[7];
    private Resource m_resource;
    private List<ProjectCalendar> m_derivedCalendars = new LinkedList<ProjectCalendar>();
    public static final String DEFAULT_BASE_CALENDAR_NAME = "Standard";
    public static final int NON_WORKING = 0;
    public static final int WORKING = 1;
    public static final int DEFAULT = 2;
    public static final Date DEFAULT_START1 = DateUtility.getTime(8, 0);
    public static final Date DEFAULT_END1 = DateUtility.getTime(12, 0);
    public static final Date DEFAULT_START2 = DateUtility.getTime(13, 0);
    public static final Date DEFAULT_END2 = DateUtility.getTime(17, 0);
    private static final int MAX_NONWORKING_DAYS = 1000;

    ProjectCalendar(ProjectFile file) {
        super(file);
        if (file.getAutoCalendarUniqueID()) {
            this.setUniqueID(file.getCalendarUniqueID());
        }
    }

    public ProjectCalendarException addCalendarException() {
        ProjectCalendarException bce = new ProjectCalendarException();
        this.m_exceptions.add(bce);
        return bce;
    }

    public List<ProjectCalendarException> getCalendarExceptions() {
        return this.m_exceptions;
    }

    public ProjectCalendarHours addCalendarHours(Day day) {
        ProjectCalendarHours bch = new ProjectCalendarHours(this);
        bch.setDay(day);
        this.m_hours[day.getValue() - 1] = bch;
        return bch;
    }

    public ProjectCalendarHours addCalendarHours() {
        return new ProjectCalendarHours(this);
    }

    public void attachHoursToDay(ProjectCalendarHours hours) {
        if (hours.getParentCalendar() != this) {
            throw new IllegalArgumentException();
        }
        this.m_hours[hours.getDay().getValue() - 1] = hours;
    }

    public void removeHoursFromDay(ProjectCalendarHours hours) {
        if (hours.getParentCalendar() != this) {
            throw new IllegalArgumentException();
        }
        this.m_hours[hours.getDay().getValue() - 1] = null;
    }

    public ProjectCalendarHours getCalendarHours(Day day) {
        return this.m_hours[day.getValue() - 1];
    }

    public ProjectCalendarHours getHours(Day day) {
        ProjectCalendarHours result = this.getCalendarHours(day);
        if (result == null) {
            if (this.m_baseCalendar == null) {
                this.addDefaultCalendarHours();
                result = this.getCalendarHours(day);
            } else {
                result = this.m_baseCalendar.getHours(day);
            }
        }
        return result;
    }

    public ProjectCalendarHours[] getHours() {
        return this.m_hours;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setBaseCalendar(ProjectCalendar calendar) {
        if (this.m_baseCalendar != null) {
            this.m_baseCalendar.removeDerivedCalendar(this);
        }
        this.m_baseCalendar = calendar;
        if (this.m_baseCalendar != null) {
            this.m_baseCalendar.addDerivedCalendar(this);
        }
    }

    public ProjectCalendar getBaseCalendar() {
        return this.m_baseCalendar;
    }

    public boolean isWorkingDay(Day day) {
        ProjectCalendar cal;
        int value = this.m_days[day.getValue() - 1];
        boolean result = value == 2 ? ((cal = this.getBaseCalendar()) != null ? cal.isWorkingDay(day) : day != Day.SATURDAY && day != Day.SUNDAY) : value == 1;
        return result;
    }

    public int[] getDays() {
        return this.m_days;
    }

    public int getWorkingDay(Day day) {
        return this.m_days[day.getValue() - 1];
    }

    public void setWorkingDay(Day day, int working) {
        this.m_days[day.getValue() - 1] = working;
    }

    public void setWorkingDay(Day day, boolean working) {
        this.setWorkingDay(day, working ? 1 : 0);
    }

    public void setWorkingDay(Day day, Integer working) {
        int value = working == null ? (!this.isBaseCalendar() ? 2 : 1) : working;
        this.setWorkingDay(day, value);
    }

    public void addDefaultCalendarHours() {
        ProjectCalendarHours hours = this.addCalendarHours(Day.SUNDAY);
        hours = this.addCalendarHours(Day.MONDAY);
        hours.addRange(new DateRange(DEFAULT_START1, DEFAULT_END1));
        hours.addRange(new DateRange(DEFAULT_START2, DEFAULT_END2));
        hours = this.addCalendarHours(Day.TUESDAY);
        hours.addRange(new DateRange(DEFAULT_START1, DEFAULT_END1));
        hours.addRange(new DateRange(DEFAULT_START2, DEFAULT_END2));
        hours = this.addCalendarHours(Day.WEDNESDAY);
        hours.addRange(new DateRange(DEFAULT_START1, DEFAULT_END1));
        hours.addRange(new DateRange(DEFAULT_START2, DEFAULT_END2));
        hours = this.addCalendarHours(Day.THURSDAY);
        hours.addRange(new DateRange(DEFAULT_START1, DEFAULT_END1));
        hours.addRange(new DateRange(DEFAULT_START2, DEFAULT_END2));
        hours = this.addCalendarHours(Day.FRIDAY);
        hours.addRange(new DateRange(DEFAULT_START1, DEFAULT_END1));
        hours.addRange(new DateRange(DEFAULT_START2, DEFAULT_END2));
        this.addCalendarHours(Day.SATURDAY);
    }

    public Duration getDuration(Date startDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int dayIndex = cal.get(7);
        int days = this.getDaysInRange(startDate, endDate);
        int duration = 0;
        while (days > 0) {
            if (this.isWorkingDate(cal.getTime(), Day.getInstance(dayIndex))) {
                ++duration;
            }
            --days;
            if (++dayIndex > 7) {
                dayIndex = 1;
            }
            cal.set(6, cal.get(6) + 1);
        }
        return Duration.getInstance(duration, TimeUnit.DAYS);
    }

    public Date getStartTime(Date date) {
        ProjectCalendarDateRanges ranges = this.getException(date);
        if (ranges == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            Day day = Day.getInstance(cal.get(7));
            ranges = this.getHours(day);
        }
        Date result = ranges == null ? this.getParentFile().getProjectHeader().getDefaultStartTime() : ranges.getRange(0).getStart();
        return DateUtility.getCanonicalTime(result);
    }

    public Date getFinishTime(Date date) {
        Date result = null;
        if (date != null) {
            ProjectCalendarDateRanges ranges = this.getException(date);
            if (ranges == null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                Day day = Day.getInstance(cal.get(7));
                ranges = this.getHours(day);
            }
            if (ranges == null) {
                result = this.getParentFile().getProjectHeader().getDefaultEndTime();
                result = DateUtility.getCanonicalTime(result);
            } else {
                Date rangeStart = result = ranges.getRange(0).getStart();
                Date rangeFinish = ranges.getRange(ranges.getRangeCount() - 1).getEnd();
                Date startDay = DateUtility.getDayStartDate(rangeStart);
                Date finishDay = DateUtility.getDayStartDate(rangeFinish);
                result = DateUtility.getCanonicalTime(rangeFinish);
                if (startDay != null && finishDay != null && startDay.getTime() != finishDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(result);
                    calendar.add(6, 1);
                    result = calendar.getTime();
                }
            }
        }
        return result;
    }

    public Date getDate(Date startDate, Duration duration, boolean returnNextWorkStart) {
        ProjectHeader header = this.getParentFile().getProjectHeader();
        double remainingMinutes = NumberUtility.truncate(duration.convertUnits(TimeUnit.MINUTES, header).getDuration(), 2.0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        while (remainingMinutes > 0.0) {
            Date currentDate = cal.getTime();
            endCal.setTime(currentDate);
            endCal.add(6, 1);
            Date currentDateEnd = DateUtility.getDayStartDate(endCal.getTime());
            double currentDateWorkingMinutes = this.getWork(currentDate, currentDateEnd, TimeUnit.MINUTES).getDuration();
            if (remainingMinutes > currentDateWorkingMinutes) {
                Day day;
                remainingMinutes = NumberUtility.truncate(remainingMinutes - currentDateWorkingMinutes, 2.0);
                int nonWorkingDayCount = 0;
                do {
                    cal.add(6, 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(startDate);
                    cal.add(6, 1);
                    remainingMinutes = 0.0;
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                Date startTime = this.getStartTime(cal.getTime());
                DateUtility.setTime(cal, startTime);
                continue;
            }
            ProjectCalendarDateRanges ranges = this.getException(cal.getTime());
            if (ranges == null) {
                Day day = Day.getInstance(cal.get(7));
                ranges = this.getHours(day);
            }
            Date endTime = null;
            Date currentDateStartTime = DateUtility.getCanonicalTime(currentDate);
            boolean firstRange = true;
            for (DateRange range : ranges) {
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                Date canonicalRangeEnd = DateUtility.getCanonicalTime(rangeEnd);
                Date canonicalRangeStart = DateUtility.getCanonicalTime(rangeStart);
                Date rangeStartDay = DateUtility.getDayStartDate(rangeStart);
                Date rangeEndDay = DateUtility.getDayStartDate(rangeEnd);
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(canonicalRangeEnd);
                    calendar.add(6, 1);
                    canonicalRangeEnd = calendar.getTime();
                }
                if (firstRange && canonicalRangeEnd.getTime() < currentDateStartTime.getTime()) continue;
                if (firstRange && canonicalRangeStart.getTime() < currentDateStartTime.getTime()) {
                    canonicalRangeStart = currentDateStartTime;
                }
                firstRange = false;
                double rangeMinutes = canonicalRangeEnd.getTime() - canonicalRangeStart.getTime();
                if (remainingMinutes > (rangeMinutes /= 60000.0)) {
                    remainingMinutes = NumberUtility.truncate(remainingMinutes - rangeMinutes, 2.0);
                    continue;
                }
                if (remainingMinutes == rangeMinutes) {
                    endTime = canonicalRangeEnd;
                } else {
                    endTime = new Date((long)((double)canonicalRangeStart.getTime() + remainingMinutes * 60000.0));
                    returnNextWorkStart = false;
                }
                remainingMinutes = 0.0;
                break;
            }
            DateUtility.setTime(cal, endTime);
        }
        if (returnNextWorkStart) {
            this.updateToNextWorkStart(cal);
        }
        return cal.getTime();
    }

    public Date getStartDate(Date finishDate, Duration duration) {
        ProjectHeader header = this.getParentFile().getProjectHeader();
        double remainingMinutes = NumberUtility.truncate(duration.convertUnits(TimeUnit.MINUTES, header).getDuration(), 2.0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(finishDate);
        Calendar startCal = Calendar.getInstance();
        while (remainingMinutes > 0.0) {
            Date currentDate = cal.getTime();
            startCal.setTime(currentDate);
            startCal.add(6, -1);
            Date currentDateStart = DateUtility.getDayEndDate(startCal.getTime());
            double currentDateWorkingMinutes = this.getWork(currentDateStart, currentDate, TimeUnit.MINUTES).getDuration();
            if (remainingMinutes > currentDateWorkingMinutes) {
                Day day;
                remainingMinutes = NumberUtility.truncate(remainingMinutes - currentDateWorkingMinutes, 2.0);
                do {
                    cal.add(6, -1);
                    day = Day.getInstance(cal.get(7));
                } while (!this.isWorkingDate(cal.getTime(), day));
                Date finishTime = this.getFinishTime(cal.getTime());
                DateUtility.setTime(cal, finishTime);
                continue;
            }
            ProjectCalendarDateRanges ranges = this.getException(cal.getTime());
            if (ranges == null) {
                Day day = Day.getInstance(cal.get(7));
                ranges = this.getHours(day);
            }
            Date startTime = null;
            Date currentDateFinishTime = DateUtility.getCanonicalTime(currentDate);
            boolean firstRange = true;
            for (int i = ranges.getRangeCount() - 1; i >= 0; --i) {
                DateRange range = ranges.getRange(i);
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                Date canonicalRangeEnd = DateUtility.getCanonicalTime(rangeEnd);
                Date canonicalRangeStart = DateUtility.getCanonicalTime(rangeStart);
                Date rangeStartDay = DateUtility.getDayStartDate(rangeStart);
                Date rangeEndDay = DateUtility.getDayStartDate(rangeEnd);
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(canonicalRangeStart);
                    calendar.add(6, -1);
                    canonicalRangeStart = calendar.getTime();
                }
                if (firstRange && canonicalRangeStart.getTime() > currentDateFinishTime.getTime()) continue;
                if (firstRange && canonicalRangeEnd.getTime() > currentDateFinishTime.getTime()) {
                    canonicalRangeEnd = currentDateFinishTime;
                }
                firstRange = false;
                double rangeMinutes = canonicalRangeEnd.getTime() - canonicalRangeStart.getTime();
                if (remainingMinutes > (rangeMinutes /= 60000.0)) {
                    remainingMinutes = NumberUtility.truncate(remainingMinutes - rangeMinutes, 2.0);
                    continue;
                }
                startTime = remainingMinutes == rangeMinutes ? canonicalRangeStart : new Date((long)((double)canonicalRangeEnd.getTime() - remainingMinutes * 60000.0));
                remainingMinutes = 0.0;
                break;
            }
            DateUtility.setTime(cal, startTime);
        }
        return cal.getTime();
    }

    private void updateToNextWorkStart(Calendar cal) {
        Date originalDate = cal.getTime();
        ProjectCalendarDateRanges ranges = this.getException(cal.getTime());
        if (ranges == null) {
            Day day = Day.getInstance(cal.get(7));
            ranges = this.getHours(day);
        }
        if (ranges != null) {
            Date calTime = DateUtility.getCanonicalTime(cal.getTime());
            Date startTime = null;
            for (DateRange range : ranges) {
                Date rangeStart = DateUtility.getCanonicalTime(range.getStart());
                Date rangeEnd = DateUtility.getCanonicalTime(range.getEnd());
                Date rangeStartDay = DateUtility.getDayStartDate(range.getStart());
                Date rangeEndDay = DateUtility.getDayStartDate(range.getEnd());
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(rangeEnd);
                    calendar.add(6, 1);
                    rangeEnd = calendar.getTime();
                }
                if (calTime.getTime() >= rangeEnd.getTime()) continue;
                if (calTime.getTime() > rangeStart.getTime()) {
                    startTime = calTime;
                    break;
                }
                startTime = rangeStart;
                break;
            }
            if (startTime == null) {
                Day day;
                int nonWorkingDayCount = 0;
                do {
                    cal.set(6, cal.get(6) + 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(originalDate);
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                startTime = this.getStartTime(cal.getTime());
            }
            DateUtility.setTime(cal, startTime);
        }
    }

    public Date getNextWorkStart(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.updateToNextWorkStart(cal);
        return cal.getTime();
    }

    public boolean isWorkingDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Day day = Day.getInstance(cal.get(7));
        return this.isWorkingDate(date, day);
    }

    private boolean isWorkingDate(Date date, Day day) {
        ProjectCalendarException exception = this.getException(date);
        boolean result = exception != null ? exception.getWorking() : this.isWorkingDay(day);
        return result;
    }

    private int getDaysInRange(Date startDate, Date endDate) {
        int result;
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        int endDateYear = cal.get(1);
        int endDateDayOfYear = cal.get(6);
        cal.setTime(startDate);
        if (endDateYear == cal.get(1)) {
            result = endDateDayOfYear - cal.get(6) + 1;
        } else {
            result = 0;
            do {
                result += cal.getActualMaximum(6) - cal.get(6) + 1;
                cal.roll(1, 1);
                cal.set(6, 1);
            } while (cal.get(1) < endDateYear);
            result += endDateDayOfYear;
        }
        return result;
    }

    public boolean isBaseCalendar() {
        return this.m_baseCalendar == null;
    }

    public void setUniqueID(Integer uniqueID) {
        ProjectFile parent = this.getParentFile();
        if (this.m_uniqueID != null) {
            parent.unmapTaskUniqueID(this.m_uniqueID);
        }
        parent.mapCalendarUniqueID(uniqueID, this);
        this.m_uniqueID = uniqueID;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public void setResource(Resource resource) {
        this.m_resource = resource;
        this.m_name = this.m_resource.getName();
        if (this.m_name == null || this.m_name.length() == 0) {
            this.m_name = "Unnamed Resource";
        }
    }

    public void remove() {
        this.getParentFile().removeCalendar(this);
    }

    public ProjectCalendarException getException(Date date) {
        Iterator iter = this.m_exceptions.iterator();
        ProjectCalendarException exception = null;
        while (iter.hasNext() && !(exception = (ProjectCalendarException)iter.next()).contains(date)) {
            exception = null;
        }
        if (exception == null && this.m_baseCalendar != null) {
            exception = this.m_baseCalendar.getException(date);
        }
        return exception;
    }

    public Duration getWork(Date date, TimeUnit format) {
        ProjectCalendarDateRanges ranges = this.getException(date);
        if (ranges == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            Day day = Day.getInstance(cal.get(7));
            ranges = this.getHours(day);
        }
        long time = this.getTotalTime(ranges);
        Duration result = Duration.getInstance(time /= 60000L, TimeUnit.MINUTES);
        return result;
    }

    public Duration getWork(Date startDate, Date endDate, TimeUnit format) {
        boolean invert = false;
        if (startDate.getTime() > endDate.getTime()) {
            invert = true;
            Date temp = startDate;
            startDate = endDate;
            endDate = temp;
        }
        Date canonicalStartDate = DateUtility.getDayStartDate(startDate);
        Date canonicalEndDate = DateUtility.getDayStartDate(endDate);
        long totalTime = 0L;
        if (canonicalStartDate.getTime() == canonicalEndDate.getTime()) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            Day day = Day.getInstance(cal.get(7));
            if (this.isWorkingDate(startDate, day)) {
                ProjectCalendarDateRanges ranges = this.getException(startDate);
                if (ranges == null) {
                    ranges = this.getHours(day);
                }
                totalTime = this.getTotalTime(ranges, startDate, endDate);
            }
        } else {
            Date currentDate = startDate;
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            Day day = Day.getInstance(cal.get(7));
            while (!this.isWorkingDate(currentDate, day) && currentDate.getTime() < canonicalEndDate.getTime()) {
                cal.add(6, 1);
                currentDate = cal.getTime();
                day = day.getNextDay();
            }
            if (currentDate.getTime() < canonicalEndDate.getTime()) {
                ProjectCalendarException exception = this.getException(currentDate);
                totalTime = exception == null ? (totalTime += this.getTotalTime(this.getHours(day), currentDate, true)) : (totalTime += this.getTotalTime((ProjectCalendarDateRanges)exception, currentDate, true));
                while (true) {
                    cal.add(6, 1);
                    currentDate = cal.getTime();
                    day = day.getNextDay();
                    if (currentDate.getTime() >= canonicalEndDate.getTime()) break;
                    if (!this.isWorkingDate(currentDate, day)) continue;
                    exception = this.getException(currentDate);
                    if (exception == null) {
                        totalTime += this.getTotalTime(this.getHours(day));
                        continue;
                    }
                    totalTime += this.getTotalTime(exception);
                }
            }
            if (this.isWorkingDate(endDate, day)) {
                ProjectCalendarDateRanges ranges = this.getException(endDate);
                if (ranges == null) {
                    ranges = this.getHours(day);
                }
                totalTime += this.getTotalTime(ranges, DateUtility.getDayStartDate(endDate), endDate);
            }
        }
        double duration = 0.0;
        double minutesPerDay = this.getParentFile().getProjectHeader().getMinutesPerDay().doubleValue();
        double minutesPerWeek = this.getParentFile().getProjectHeader().getMinutesPerWeek().doubleValue();
        double daysPerMonth = this.getParentFile().getProjectHeader().getDaysPerMonth().doubleValue();
        switch (format) {
            case MINUTES: {
                duration = totalTime;
                duration /= 60000.0;
                break;
            }
            case HOURS: {
                duration = totalTime;
                duration /= 3600000.0;
                break;
            }
            case DAYS: {
                duration = totalTime;
                if (minutesPerDay != 0.0) {
                    duration /= minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case WEEKS: {
                duration = totalTime;
                if (minutesPerWeek != 0.0) {
                    duration /= minutesPerWeek * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case MONTHS: {
                duration = totalTime;
                if (daysPerMonth != 0.0 && minutesPerDay != 0.0) {
                    duration /= daysPerMonth * minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case ELAPSED_MINUTES: {
                duration = totalTime / 60000L;
                break;
            }
            case ELAPSED_HOURS: {
                duration = totalTime / 3600000L;
                break;
            }
            case ELAPSED_DAYS: {
                duration = totalTime / 86400000L;
                break;
            }
            case ELAPSED_WEEKS: {
                duration = totalTime / 604800000L;
                break;
            }
            case ELAPSED_MONTHS: {
                duration = totalTime / -1702967296L;
                break;
            }
            default: {
                throw new IllegalArgumentException("TimeUnit " + format + " not supported");
            }
        }
        if (invert) {
            duration = -duration;
        }
        return Duration.getInstance(duration, format);
    }

    private long getTotalTime(ProjectCalendarDateRanges exception, Date date, boolean after) {
        long currentTime = DateUtility.getCanonicalTime(date).getTime();
        long total = 0L;
        for (DateRange range : exception) {
            total += this.getTime(range.getStart(), range.getEnd(), currentTime, after);
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarDateRanges exception) {
        long total = 0L;
        for (DateRange range : exception) {
            total += this.getTime(range.getStart(), range.getEnd());
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarHours hours, Date date, boolean after) {
        long total = 0L;
        Date current = DateUtility.getCanonicalTime(date);
        long currentTime = current.getTime();
        for (DateRange range : hours) {
            total += this.getTime(range.getStart(), range.getEnd(), currentTime, after);
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarDateRanges hours, Date startDate, Date endDate) {
        long total = 0L;
        if (startDate.getTime() != endDate.getTime()) {
            Date start = DateUtility.getCanonicalTime(startDate);
            Date end = DateUtility.getCanonicalTime(endDate);
            for (DateRange range : hours) {
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canoncialRangeStart = DateUtility.getCanonicalTime(rangeStart);
                Date canonicalRangeEnd = DateUtility.getCanonicalTime(rangeEnd);
                Date startDay = DateUtility.getDayStartDate(rangeStart);
                Date finishDay = DateUtility.getDayStartDate(rangeEnd);
                if (startDay.getTime() != finishDay.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(canonicalRangeEnd);
                    calendar.add(6, 1);
                    canonicalRangeEnd = calendar.getTime();
                }
                if (canoncialRangeStart.getTime() == canonicalRangeEnd.getTime() && rangeEnd.getTime() > rangeStart.getTime()) {
                    total += 86400000L;
                    continue;
                }
                total += this.getTime(start, end, canoncialRangeStart, canonicalRangeEnd);
            }
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarHours hours) {
        long total = 0L;
        for (DateRange range : hours) {
            total += this.getTime(range.getStart(), range.getEnd());
        }
        return total;
    }

    private long getTime(Date start, Date end, long target, boolean after) {
        long total = 0L;
        if (start != null && end != null) {
            int diff;
            Date startTime = DateUtility.getCanonicalTime(start);
            Date endTime = DateUtility.getCanonicalTime(end);
            Date startDay = DateUtility.getDayStartDate(start);
            Date finishDay = DateUtility.getDayStartDate(end);
            if (startDay.getTime() != finishDay.getTime()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endTime);
                calendar.add(6, 1);
                endTime = calendar.getTime();
            }
            if ((diff = DateUtility.compare(startTime, endTime, target)) == 0) {
                total = after ? endTime.getTime() - target : target - startTime.getTime();
            } else if (after && diff < 0 || !after && diff > 0) {
                total = endTime.getTime() - startTime.getTime();
            }
        }
        return total;
    }

    private long getTime(Date start, Date end) {
        long total = 0L;
        if (start != null && end != null) {
            Date startTime = DateUtility.getCanonicalTime(start);
            Date endTime = DateUtility.getCanonicalTime(end);
            Date startDay = DateUtility.getDayStartDate(start);
            Date finishDay = DateUtility.getDayStartDate(end);
            if (startDay.getTime() != finishDay.getTime()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endTime);
                calendar.add(6, 1);
                endTime = calendar.getTime();
            }
            total = endTime.getTime() - startTime.getTime();
        }
        return total;
    }

    private long getTime(Date start1, Date end1, Date start2, Date end2) {
        long end;
        long start;
        long total = 0L;
        if (start1 != null && end1 != null && start2 != null && end2 != null && (start = start1.getTime() < start2.getTime() ? start2.getTime() : start1.getTime()) < (end = end1.getTime() < end2.getTime() ? end1.getTime() : end2.getTime())) {
            total = end - start;
        }
        return total;
    }

    protected void addDerivedCalendar(ProjectCalendar calendar) {
        this.m_derivedCalendars.add(calendar);
    }

    protected void removeDerivedCalendar(ProjectCalendar calendar) {
        this.m_derivedCalendars.remove(calendar);
    }

    public List<ProjectCalendar> getDerivedCalendars() {
        return this.m_derivedCalendars;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[ProjectCalendar");
        pw.println("   ID=" + this.m_uniqueID);
        pw.println("   name=" + this.m_name);
        pw.println("   baseCalendarName=" + (this.m_baseCalendar == null ? "" : this.m_baseCalendar.getName()));
        pw.println("   resource=" + (this.m_resource == null ? "" : this.m_resource.getName()));
        String[] dayType = new String[]{"Non-working", "Working", "Default"};
        String[] dayName = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        for (int loop = 0; loop < 7; ++loop) {
            pw.println("   [Day " + dayName[loop]);
            pw.println("      type=" + dayType[this.m_days[loop]]);
            pw.println("      hours=" + this.m_hours[loop]);
            pw.println("   ]");
        }
        if (!this.m_exceptions.isEmpty()) {
            pw.println("   [Exceptions=");
            for (ProjectCalendarException ex : this.m_exceptions) {
                pw.println("      " + ex.toString());
            }
            pw.println("   ]");
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

