/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FilterCriteria;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    private Integer m_id;
    private String m_name;
    private boolean m_showRelatedSummaryRows;
    private List<FilterCriteria> m_criteria = new LinkedList<FilterCriteria>();
    private boolean m_promptTextSet;

    public void setID(Integer id) {
        this.m_id = id;
    }

    public Integer getID() {
        return this.m_id;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setShowRelatedSummaryRows(boolean showRelatedSummaryRows) {
        this.m_showRelatedSummaryRows = showRelatedSummaryRows;
    }

    public boolean getShowRelatedSummaryRows() {
        return this.m_showRelatedSummaryRows;
    }

    public void addCriteria(FilterCriteria criteria) {
        this.m_criteria.add(criteria);
        if (criteria.getPromptTextSet()) {
            this.m_promptTextSet = true;
        }
    }

    public List<FilterCriteria> getCriteria() {
        return this.m_criteria;
    }

    public boolean isTaskFilter() {
        boolean result = true;
        if (!this.m_criteria.isEmpty()) {
            result = this.m_criteria.get(0).getField() instanceof TaskField;
        }
        return result;
    }

    public boolean isResourceFilter() {
        boolean result = true;
        if (!this.m_criteria.isEmpty()) {
            result = this.m_criteria.get(0).getField() instanceof ResourceField;
        }
        return result;
    }

    public boolean evaluate(FieldContainer container) {
        boolean result = true;
        if (!this.m_criteria.isEmpty()) {
            boolean currentBlockResult = true;
            boolean currentAnd = true;
            boolean lastBlockAnd = true;
            for (FilterCriteria criteria : this.m_criteria) {
                boolean criteriaResult = criteria.evaluate(container);
                currentBlockResult = currentAnd ? currentBlockResult && criteriaResult : currentBlockResult || criteriaResult;
                switch (criteria.getCriteriaLogic()) {
                    case IN_BLOCK_AND: {
                        currentAnd = true;
                        break;
                    }
                    case IN_BLOCK_OR: {
                        currentAnd = false;
                        break;
                    }
                    case BETWEEN_BLOCK_AND: {
                        result = lastBlockAnd ? result && currentBlockResult : result || currentBlockResult;
                        currentAnd = true;
                        currentBlockResult = true;
                        lastBlockAnd = true;
                        break;
                    }
                    case BETWEEN_BLOCK_OR: {
                        result = lastBlockAnd ? result && currentBlockResult : result || currentBlockResult;
                        currentAnd = true;
                        currentBlockResult = true;
                        lastBlockAnd = false;
                    }
                }
            }
            if (lastBlockAnd) {
                result = result && currentBlockResult;
            } else {
                boolean bl = result = result || currentBlockResult;
            }
            if (!result && this.m_showRelatedSummaryRows && container instanceof Task) {
                for (Task task : ((Task)container).getChildTasks()) {
                    if (!this.evaluate(task)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public boolean getPromptTextSet() {
        return this.m_promptTextSet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Filter id=");
        sb.append(this.m_id);
        sb.append(" name=");
        sb.append(this.m_name);
        sb.append(" showRelatedSummaryRows=");
        sb.append(this.m_showRelatedSummaryRows);
        sb.append(" criteria=[");
        for (FilterCriteria fc : this.m_criteria) {
            sb.append(fc.toString());
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

