/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedResourceAssignment;
import net.sf.mpxj.TimephasedResourceAssignmentNormaliser;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTimephasedResourceAssignmentNormaliser
implements TimephasedResourceAssignmentNormaliser {
    @Override
    public abstract void normalise(ProjectCalendar var1, LinkedList<TimephasedResourceAssignment> var2);

    protected void mergeSameWork(LinkedList<TimephasedResourceAssignment> list) {
        LinkedList<TimephasedResourceAssignment> result = new LinkedList<TimephasedResourceAssignment>();
        TimephasedResourceAssignment previousAssignment = null;
        for (TimephasedResourceAssignment assignment : list) {
            if (previousAssignment == null) {
                assignment.setWorkPerDay(assignment.getTotalWork());
                result.add(assignment);
            } else {
                Duration previousAssignmentWork = previousAssignment.getWorkPerDay();
                Duration assignmentWork = assignment.getTotalWork();
                if (NumberUtility.equals(previousAssignmentWork.getDuration(), assignmentWork.getDuration(), 0.01)) {
                    Date assignmentStart = previousAssignment.getStart();
                    Date assignmentFinish = assignment.getFinish();
                    double total = previousAssignment.getTotalWork().getDuration();
                    Duration totalWork = Duration.getInstance(total += assignmentWork.getDuration(), TimeUnit.MINUTES);
                    TimephasedResourceAssignment merged = new TimephasedResourceAssignment();
                    merged.setStart(assignmentStart);
                    merged.setFinish(assignmentFinish);
                    merged.setWorkPerDay(assignmentWork);
                    merged.setTotalWork(totalWork);
                    result.removeLast();
                    assignment = merged;
                } else {
                    assignment.setWorkPerDay(assignment.getTotalWork());
                }
                result.add(assignment);
            }
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }

    protected void convertToHours(LinkedList<TimephasedResourceAssignment> list) {
        for (TimephasedResourceAssignment assignment : list) {
            Duration totalWork = assignment.getTotalWork();
            Duration workPerDay = assignment.getWorkPerDay();
            totalWork = Duration.getInstance(totalWork.getDuration() / 60.0, TimeUnit.HOURS);
            workPerDay = Duration.getInstance(workPerDay.getDuration() / 60.0, TimeUnit.HOURS);
            assignment.setTotalWork(totalWork);
            assignment.setWorkPerDay(workPerDay);
        }
    }
}

