/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.subset;

import ch.randelshofer.quaqua.LookAndFeelProxy;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.color.InactivatableColorUIResource;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;

public class QuaquaLeopardFileChooserLAF
extends LookAndFeelProxy {
    protected static final String commonDir = "/ch/randelshofer/quaqua/images/";
    protected static final String jaguarDir = "/ch/randelshofer/quaqua/jaguar/images/";
    protected static final String leopardDir = "/ch/randelshofer/quaqua/leopard/images/";
    private UIDefaults myDefaults;
    protected static final FontUIResource SMALL_SYSTEM_FONT = new FontUIResource("Lucida Grande", 0, 11);

    public QuaquaLeopardFileChooserLAF() {
        String targetClassName = "apple.laf.AquaLookAndFeel";
        try {
            this.setTarget((LookAndFeel)Class.forName(targetClassName).newInstance());
        }
        catch (Exception e) {
            throw new InternalError("Unable to instanciate target Look and Feel \"" + targetClassName + "\". " + e.getMessage());
        }
    }

    public String getDescription() {
        return "The Quaqua Leopard FileChooser Look and Feel for Java 1.5";
    }

    public String getName() {
        return "Quaqua FileChooser-only LAF";
    }

    public void initialize() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                QuaquaLeopardFileChooserLAF.this.target.initialize();
                QuaquaLeopardFileChooserLAF.this.myDefaults = QuaquaLeopardFileChooserLAF.this.target.getDefaults();
                QuaquaLeopardFileChooserLAF.this.initResourceBundle(QuaquaLeopardFileChooserLAF.this.myDefaults);
                QuaquaLeopardFileChooserLAF.this.initClassDefaults(QuaquaLeopardFileChooserLAF.this.myDefaults);
                QuaquaLeopardFileChooserLAF.this.initFontDefaults(QuaquaLeopardFileChooserLAF.this.myDefaults);
                QuaquaLeopardFileChooserLAF.this.initGeneralDefaults(QuaquaLeopardFileChooserLAF.this.myDefaults);
                QuaquaLeopardFileChooserLAF.this.initComponentDefaults(QuaquaLeopardFileChooserLAF.this.myDefaults);
                return null;
            }
        });
    }

    public UIDefaults getDefaults() {
        return this.myDefaults;
    }

    protected void initResourceBundle(UIDefaults table) {
        ResourceBundle bundle = ResourceBundle.getBundle("ch.randelshofer.quaqua.Labels", Locale.getDefault(), this.getClass().getClassLoader());
        Enumeration<String> i = bundle.getKeys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            table.put(key, bundle.getObject(key));
        }
    }

    protected void initClassDefaults(UIDefaults table) {
        String basicPrefix = "javax.swing.plaf.basic.Basic";
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaquaLeopardPrefix = "ch.randelshofer.quaqua.leopard.QuaquaLeopard";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "FileChooserUI", quaquaLeopardPrefix + "FileChooserUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initGeneralDefaults(UIDefaults table) {
        Object[] uiDefaults = new Object[]{"ClassLoader", this.getClass().getClassLoader()};
        table.putDefaults(uiDefaults);
    }

    protected Font getBaseSystemFont() {
        return new Font("Lucida Grande", 0, 13);
    }

    protected void initFontDefaults(UIDefaults table) {
        Font baseSystemFont = this.getBaseSystemFont();
        float fourteen = 14.0f;
        float thirteen = 13.0f;
        float twelve = 12.0f;
        float eleven = 11.0f;
        float ten = 11.0f;
        float nine = 9.0f;
        int fontPlain = 0;
        int fontBold = 1;
        UIDefaults.ProxyLazyValue systemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, thirteen)});
        UIDefaults.ProxyLazyValue emphasizedSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, thirteen)});
        UIDefaults.ProxyLazyValue smallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, eleven)});
        UIDefaults.ProxyLazyValue emphasizedSmallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, eleven)});
        UIDefaults.ProxyLazyValue miniSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, nine)});
        UIDefaults.ProxyLazyValue emphasizedMiniSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, nine)});
        Object applicationFont = baseSystemFont;
        UIDefaults.ProxyLazyValue labelFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, ten)});
        UIDefaults.ProxyLazyValue viewFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, twelve)});
        UIDefaults.ProxyLazyValue menuFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, fourteen)});
        if (QuaquaManager.getProperty("Quaqua.sizeStyle", "regular").equals("small")) {
            viewFont = smallSystemFont;
            systemFont = smallSystemFont;
            emphasizedSystemFont = emphasizedSmallSystemFont;
            menuFont = smallSystemFont;
            applicationFont = smallSystemFont;
        }
        Object[] uiDefaults = new Object[]{"SystemFont", systemFont, "EmphasizedSystemFont", emphasizedSystemFont, "SmallSystemFont", smallSystemFont, "EmphasizedSmallSystemFont", emphasizedSmallSystemFont, "MiniSystemFont", miniSystemFont, "EmphasizedMiniSystemFont", miniSystemFont, "ApplicationFont", applicationFont, "LabelFont", labelFont, "ViewFont", viewFont, "MenuFont", menuFont, "Browser.font", viewFont, "Button.font", systemFont, "Button.smallFont", smallSystemFont, "FileChooser.previewLabelFont", emphasizedSmallSystemFont, "FileChooser.previewValueFont", smallSystemFont};
        this.putDefaults(table, uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        Icon[] browserIcons = this.makeIcons("/ch/randelshofer/quaqua/images/Browser.disclosureIcons.png", 4, true);
        FontUIResource smallSystemFont = SMALL_SYSTEM_FONT;
        Color grayedFocusCellBorderColor = (Color)table.get("listHighlight");
        Integer one = new Integer(1);
        Boolean autovalidate = new Boolean(QuaquaManager.getProperty("Quaqua.FileChooser.autovalidate", "true").equals("true"));
        Object[] uiDefaults = new Object[]{"Browser.expandedIcon", browserIcons[0], "Browser.expandingIcon", browserIcons[1], "Browser.selectedExpandedIcon", browserIcons[2], "Browser.selectedExpandingIcon", browserIcons[3], "Browser.selectionBackground", new ColorUIResource(56, 117, 215), "Browser.selectionForeground", new ColorUIResource(255, 255, 255), "Browser.inactiveSelectionBackground", new ColorUIResource(208, 208, 208), "Browser.inactiveSelectionForeground", new ColorUIResource(0, 0, 0), "Browser.sizeHandleIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/images/Browser.sizeHandleIcon.png", one, Boolean.TRUE, one}), "FileChooser.homeFolderIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileChooser.homeFolderIcon.png"), "FileChooser.autovalidate", autovalidate, "FileChooser.previewLabelForeground", new ColorUIResource(0), "FileChooser.previewValueForeground", new ColorUIResource(0), "FileChooser.splitPaneDividerSize", new Integer(4), "FileChooser.previewLabelInsets", new InsetsUIResource(1, 0, 0, 1), "FileChooser.previewLabelDelimiter", ":", "FileChooser.speed", new Boolean(QuaquaManager.getProperty("Quaqua.FileChooser.speed") != null && QuaquaManager.getProperty("Quaqua.FileChooser.speed").equals("true")), "FileView.computerIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.computerIcon.png"), "FileView.fileIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.fileIcon.png"), "FileView.directoryIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.directoryIcon.png"), "FileChooser.orderByType", new Boolean(QuaquaManager.getProperty("Quaqua.FileChooser.speed") != null && QuaquaManager.getProperty("Quaqua.FileChooser.orderByType").equals("true")), "FileChooser.browserFocusCellHighlightBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{table.get("listHighlightBorder")}), "FileChooser.browserCellBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{new Insets(1, 1, 1, 1)}), "FileChooser.previewLabelForeground", new ColorUIResource(0x808080), "FileChooser.previewValueForeground", new ColorUIResource(0), "FileChooser.previewLabelInsets", new InsetsUIResource(1, 0, 0, 4), "FileChooser.previewLabelDelimiter", "", "FileChooser.cellTipOrigin", new Point(18, 1), "FileChooser.splitPaneDividerSize", new Integer(1), "FileChooser.browserFocusCellHighlightBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{new Insets(1, 1, 1, 1)}), "FileChooser.browserFocusCellHighlightBorderGrayed", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new Object[]{new Integer(1), new Integer(1), new Integer(1), new Integer(1), grayedFocusCellBorderColor}), "FileChooser.browserCellBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{new Insets(1, 1, 1, 1)}), "FileView.computerIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.computerIcon.png"), "FileView.fileIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.fileIcon.png"), "FileView.directoryIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.directoryIcon.png"), "FileView.hardDriveIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.hardDriveIcon.png"), "FileView.floppyDriveIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.floppyDriveIcon.png"), "FileChooser.enforceQuaquaTreeUI", Boolean.TRUE, "Tree.collapsedIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.collapsedIcon.png"), "Tree.expandedIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.expandedIcon.png"), "Tree.leafIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.leafIcon.png"), "Tree.openIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.openIcon.png"), "Tree.closedIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.closedIcon.png"), "Tree.background.sideBar", new InactivatableColorUIResource(0xD5DDE5, 0xE8E8E8), "Tree.selectionBorder.sideBar", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.leopard.QuaquaLeopardSideBarSelectionBorder"), "Tree.leftChildIndent", new Integer(8), "Tree.rightChildIndent", new Integer(12), "Tree.icons", this.makeIcons("/ch/randelshofer/quaqua/leopard/images/Tree.icons.png", 6, true), "Tree.category.foreground.sideBar", new InactivatableColorUIResource(0xFFFFFF, 0x5C5C5C), "Tree.category.font.sideBar", new FontUIResource("Lucida Grande", 1, 11), "Tree.foreground.sideBar", new InactivatableColorUIResource(0xFFFFFF, 0), "Tree.font.sideBar", new FontUIResource("Lucida Grande", 0, 11), "Tree.font.selected.sideBar", new FontUIResource("Lucida Grande", 1, 11), "Sheet.showAsSheet", Boolean.TRUE};
        table.putDefaults(uiDefaults);
    }

    protected URL getResource(String location) {
        URL url = this.getClass().getResource(location);
        if (url == null) {
            throw new InternalError("image resource missing: " + location);
        }
        return url;
    }

    protected Image createImage(String location) {
        return Toolkit.getDefaultToolkit().createImage(this.getResource(location));
    }

    protected Icon[] makeIcons(String location, int count, boolean horizontal) {
        Icon[] icons = new Icon[count];
        BufferedImage[] images = Images.split(this.createImage(location), count, horizontal);
        for (int i = 0; i < count; ++i) {
            icons[i] = new IconUIResource(new ImageIcon(images[i]));
        }
        return icons;
    }

    protected void putDefaults(UIDefaults table, Object[] keyValueList) {
        Set included = QuaquaManager.getIncludedUIs();
        Set excluded = QuaquaManager.getExcludedUIs();
        if (excluded == null) {
            return;
        }
        if (included == null && excluded.size() == 0) {
            table.putDefaults(keyValueList);
        } else if (included != null && excluded.size() == 0) {
            for (int i = 0; i < keyValueList.length; i += 2) {
                if (keyValueList[i] instanceof String) {
                    String name = (String)keyValueList[i];
                    int p = name.indexOf(46);
                    if (p == -1 && name.endsWith("UI")) {
                        name = name.substring(0, name.length() - 2);
                        p = 1;
                    } else if (p != -1) {
                        name = name.substring(0, p);
                    }
                    if (p != -1 && !included.contains(name)) continue;
                    table.put(keyValueList[i], keyValueList[i + 1]);
                    continue;
                }
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        } else if (included == null) {
            for (int i = 0; i < keyValueList.length; i += 2) {
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        } else {
            for (int i = 0; i < keyValueList.length; i += 2) {
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        }
    }
}

