/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFImageDecoder;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.ImageDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.MemoryCacheSeekableStream;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class OSXFile {
    public static final int FILE_TYPE_ALIAS = 2;
    public static final int FILE_TYPE_DIRECTORY = 1;
    public static final int FILE_TYPE_FILE = 0;
    public static final int FILE_TYPE_UNKOWN = -1;
    private static final int EXPECTED_NATIVE_CODE_VERSION = 4;
    private static final Color[][] labelColors = new Color[][]{{null, null, null, null}, {new Color(0xB5B5B5), new Color(0xD7D7D7), new Color(0xE9E9E9), new Color(0xF3F3F3)}, {new Color(12442714), new Color(14478762), new Color(15529422), new Color(16120550)}, {new Color(13344222), new Color(14928878), new Color(15786742), new Color(16249082)}, {new Color(6730239), new Color(11983615), new Color(13756671), new Color(15332607)}, {new Color(15916890), new Color(16512170), new Color(16578254), new Color(16710886)}, {new Color(16741740), new Color(16757420), new Color(16766675), new Color(16771302)}, {new Color(16430421), new Color(16570018), new Color(16705996), new Color(0xFFF3E3)}};
    private static Boolean isNativeCodeAvailable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isNativeCodeAvailable() {
        if (isNativeCodeAvailable == null) {
            Class clazz = OSXFile.class;
            synchronized (clazz) {
                block18: {
                    if (isNativeCodeAvailable == null) {
                        boolean success = false;
                        try {
                            String value = QuaquaManager.getProperty("Quaqua.jniIsPreloaded");
                            if (value == null) {
                                value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
                            }
                            String libraryName = null;
                            if (value != null && value.equals("true")) {
                                success = true;
                            } else {
                                libraryName = QuaquaManager.getOS() >= 5 && QuaquaManager.getProperty("os.arch").equals("x86_64") ? "quaqua64" : "quaqua";
                                try {
                                    System.loadLibrary(libraryName);
                                    success = true;
                                }
                                catch (UnsatisfiedLinkError e) {
                                    System.err.println("Warning: " + OSXFile.class + " couldn't load library \"" + libraryName + "\". " + e);
                                    success = false;
                                }
                                catch (AccessControlException e) {
                                    System.err.println("Warning: " + OSXFile.class + " access controller denied loading library \"" + libraryName + "\". " + e);
                                    success = false;
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    System.err.println("Warning: " + OSXFile.class + " couldn't load library \"" + libraryName + "\". " + e);
                                    success = false;
                                }
                            }
                            if (!success) break block18;
                            try {
                                int nativeCodeVersion = OSXFile.nativeGetNativeCodeVersion();
                                if (nativeCodeVersion != 4) {
                                    System.err.println("Warning: " + OSXFile.class + " can't use library " + libraryName + ". It has version " + nativeCodeVersion + " instead of " + 4);
                                    success = false;
                                }
                            }
                            catch (UnsatisfiedLinkError e) {
                                System.err.println("Warning: " + OSXFile.class + " could load library " + libraryName + " but can't use it. " + e);
                                success = false;
                            }
                        }
                        finally {
                            isNativeCodeAvailable = success;
                        }
                    }
                }
            }
        }
        return isNativeCodeAvailable == Boolean.TRUE;
    }

    private OSXFile() {
    }

    public static File getAbsoluteFile(File f) {
        if (!f.isAbsolute()) {
            f = new File(QuaquaManager.getProperty("user.home") + File.separatorChar + f.getPath());
        }
        if (File.separatorChar == '\\') {
            return f;
        }
        StringBuffer buf = new StringBuffer(f.getPath().length());
        int skip = 0;
        for (File i = f; i != null; i = i.getParentFile()) {
            String name = i.getName();
            if (name.equals(".")) {
                if (skip <= 0) continue;
                --skip;
                continue;
            }
            if (name.equals("..")) {
                ++skip;
                continue;
            }
            if (skip > 0) {
                --skip;
                continue;
            }
            buf.insert(0, name);
            buf.insert(0, File.separatorChar);
        }
        return f.getPath().equals(buf.toString()) ? f : new File(buf.toString());
    }

    public static boolean canWorkWithAliases() {
        return OSXFile.isNativeCodeAvailable();
    }

    public static int getFileType(File f) {
        if (OSXFile.isNativeCodeAvailable()) {
            return OSXFile.nativeGetFileType(f.getPath());
        }
        return f.isDirectory() ? 1 : (f.isFile() ? 0 : -1);
    }

    public static File resolveAlias(File alias, boolean noUI) {
        if (OSXFile.isNativeCodeAvailable()) {
            String path = OSXFile.nativeResolveAlias(alias.getPath(), noUI);
            return path == null ? null : new File(path);
        }
        return alias;
    }

    public static int resolveAliasType(File alias, boolean noUI) {
        if (OSXFile.isNativeCodeAvailable()) {
            return OSXFile.nativeResolveAliasType(alias.getPath(), noUI);
        }
        return alias.isFile() ? 0 : (alias.isDirectory() ? 1 : -1);
    }

    public static byte[] toSerializedAlias(File f) {
        if (OSXFile.isNativeCodeAvailable()) {
            return OSXFile.nativeToSerializedAlias(f.getPath());
        }
        return null;
    }

    public static File resolveAlias(byte[] serializedAlias, boolean noUI) {
        if (OSXFile.isNativeCodeAvailable()) {
            String path = OSXFile.nativeResolveAlias(serializedAlias, noUI);
            return path == null ? null : new File(path);
        }
        return null;
    }

    public static int resolveAliasType(byte[] serializedAlias, boolean noUI) {
        if (OSXFile.isNativeCodeAvailable()) {
            return OSXFile.nativeResolveAliasType(serializedAlias, noUI);
        }
        return -1;
    }

    public static boolean canWorkWithLabels() {
        return OSXFile.isNativeCodeAvailable();
    }

    public static int getLabel(File f) {
        if (OSXFile.isNativeCodeAvailable() && f != null) {
            return OSXFile.nativeGetLabel(f.getPath());
        }
        return -1;
    }

    public static Color getLabelColor(int label, int type) {
        return label == -1 ? null : labelColors[label][type];
    }

    public static BufferedImage getIconImage(File file, int size) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            try {
                BufferedImage image;
                byte[] tiffData = OSXFile.nativeGetIconImage(file.getPath(), size);
                if (tiffData == null) {
                    return null;
                }
                TIFFImageDecoder decoder = new TIFFImageDecoder(new MemoryCacheSeekableStream(new ByteArrayInputStream(tiffData)), (ImageDecodeParam)new TIFFDecodeParam());
                RenderedImage rImg = decoder.decodeAsRenderedImage(0);
                if (rImg instanceof BufferedImage) {
                    image = (BufferedImage)rImg;
                } else {
                    Raster r = rImg.getData();
                    WritableRaster wr = WritableRaster.createWritableRaster(r.getSampleModel(), null);
                    rImg.copyData(wr);
                    image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
                }
                if (image.getWidth() != size) {
                    image = Images.toBufferedImage(image.getScaledInstance(size, size, 4));
                }
                return image;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public static Icon getIcon(File file, int size) {
        return new ImageIcon(OSXFile.getIconImage(file, size));
    }

    public static String getKindString(File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            return OSXFile.nativeGetKindString(file.getPath());
        }
        return null;
    }

    public static boolean isTraversable(File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            int flags = OSXFile.nativeGetBasicItemInfoFlags(file.getPath());
            return (flags & 0xB) == 8;
        }
        return file.isDirectory();
    }

    private static native int nativeGetFileType(String var0);

    private static native String nativeResolveAlias(String var0, boolean var1);

    private static native int nativeResolveAliasType(String var0, boolean var1);

    private static native byte[] nativeToSerializedAlias(String var0);

    private static native String nativeResolveAlias(byte[] var0, boolean var1);

    private static native int nativeResolveAliasType(byte[] var0, boolean var1);

    private static native int nativeGetLabel(String var0);

    private static native String nativeGetKindString(String var0);

    private static native byte[] nativeGetIconImage(String var0, int var1);

    private static native int nativeGetBasicItemInfoFlags(String var0);

    public static String getDisplayName(File f) {
        if (OSXFile.isNativeCodeAvailable()) {
            return OSXFile.nativeGetDisplayName(f.getPath());
        }
        return f.getName();
    }

    private static native String nativeGetDisplayName(String var0);

    private static native int nativeGetNativeCodeVersion();
}

