/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaKeyboardFocusManager;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

public class Quaqua14TextFieldFocusHandler
implements FocusListener {
    private static Quaqua14TextFieldFocusHandler instance;

    public static Quaqua14TextFieldFocusHandler getInstance() {
        if (instance == null) {
            instance = new Quaqua14TextFieldFocusHandler();
        }
        return instance;
    }

    private Quaqua14TextFieldFocusHandler() {
    }

    public void focusGained(FocusEvent event) {
        QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
        JTextComponent tc = (JTextComponent)event.getSource();
        if (tc.isEditable() && tc.isEnabled()) {
            String uiProperty = tc instanceof JPasswordField ? "PasswordField.autoSelect" : (tc instanceof JFormattedTextField ? "FormattedTextField.autoSelect" : "TextField.autoSelect");
            if ((tc.getClientProperty("Quaqua.TextComponent.autoSelect") == Boolean.TRUE || tc.getClientProperty("Quaqua.TextComponent.autoSelect") == null && QuaquaManager.getBoolean(uiProperty)) && KeyboardFocusManager.getCurrentKeyboardFocusManager() instanceof QuaquaKeyboardFocusManager) {
                QuaquaKeyboardFocusManager kfm = (QuaquaKeyboardFocusManager)KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (event.getOppositeComponent() == kfm.getLastKeyboardTraversingComponent()) {
                    tc.selectAll();
                }
            }
        }
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager() instanceof QuaquaKeyboardFocusManager) {
            QuaquaKeyboardFocusManager kfm = (QuaquaKeyboardFocusManager)KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.setLastKeyboardTraversingComponent(null);
        }
    }

    public void focusLost(FocusEvent event) {
        QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
    }
}

