/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRemoveDependencyEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Dependency dependency;
    private long dependencyID;

    public TaskRemoveDependencyEdit(Dependency dependency, String string) {
        this.dependency = dependency;
        this.dependencyID = dependency.getUniqueId();
        Common.log("Action: " + string + " - task remove dependency edit - predecessor: " + dependency.getPredecessor().getFullName() + " - successor: " + dependency.getSuccessor().getFullName());
    }

    public static ExtendedCompoundEdit createRescheduleEdit(Dependency dependency) {
        TaskRemoveDependencyEdit taskRemoveDependencyEdit = new TaskRemoveDependencyEdit(dependency, "01-10-2009 19:26:06");
        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(dependency.getSuccessor());
        extendedCompoundEdit.addEdit(taskRemoveDependencyEdit);
        extendedCompoundEdit.end();
        return extendedCompoundEdit;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            Task.addDependency(this.dependency, false);
        }
        catch (CircularRelationshipException circularRelationshipException) {
            Common.logException("Error:", circularRelationshipException);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Task.removeDependency(this.dependency);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.dependency = (Dependency)hashMap.get(this.dependencyID);
        if (this.dependency == null) {
            this.dependency = company.getDependencyForUniqueId(this.dependencyID);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.dependency != null) {
            Task.removeDependency(this.dependency);
        }
        return null;
    }

    @Override
    public void serialize() {
        this.dependency = null;
    }
}

