/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPasteSerializableEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task parent;
    private long parentId;
    private Task child;
    private int index;
    private String actionId;

    public TaskPasteSerializableEdit(Task task, Task task2, int n) {
        this.parent = task;
        this.child = task2;
        this.index = n;
        this.parentId = task.getUniqueId();
        this.actionId = task.getName();
    }

    @Override
    public void undo() throws CannotUndoException {
    }

    @Override
    public void redo() throws CannotRedoException {
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.parent = (Task)hashMap.get(this.parentId);
        if (this.parent == null) {
            this.parent = company.getTaskForUniqueId(this.parentId);
            hashMap.put(this.parentId, this.parent);
        }
        if (this.parent != null) {
            this.addNewUniqueIds(this.child, hashMap, uniqueIdContainer);
        }
    }

    private void addNewUniqueIds(Task task, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        if (task != null) {
            uniqueIdContainer.newElement(task);
            hashMap.put(task.getUniqueId(), task);
            for (Dependency uniqueId : task.getSuccessorDependencies()) {
                uniqueIdContainer.newElement(uniqueId);
                hashMap.put(uniqueId.getUniqueId(), uniqueId);
            }
            for (Dependency dependency : task.getPredecessorDependencies()) {
                uniqueIdContainer.newElement(dependency);
                hashMap.put(dependency.getUniqueId(), dependency);
            }
            for (Assignment assignment : task.getAssignments()) {
                uniqueIdContainer.newElement(assignment);
                hashMap.put(assignment.getUniqueId(), assignment);
            }
            for (Task task2 : task.getChildList()) {
                this.addNewUniqueIds(task2, hashMap, uniqueIdContainer);
            }
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.parent != null) {
            this.child.updateClonedAssignments(this.parent.getCompany());
            this.parent.addChild(this.index, this.child);
            this.child.addClonnedAssignments(false);
            this.parent.setDirty(true);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("task paste edit", this.actionId, "Task parent no longer exists."));
        return vector;
    }

    @Override
    public void serialize() {
        this.parent = null;
    }
}

