/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFixedUnitsEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task task;
    private long taskUniqueId;
    private boolean fixedUnits;
    private String actionId;

    public TaskFixedUnitsEdit(Task task, boolean bl, String string) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.fixedUnits = bl;
        this.actionId = task.getName();
        Common.log("Action: " + string + " - task fixed units edit - task: " + task.getFullName() + " - old: " + !bl + " new: " + bl);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.setFixedUnits(!this.fixedUnits);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setFixedUnits(this.fixedUnits);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.setFixedUnits(this.fixedUnits);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("Task set fixed units", this.actionId, "Task no longer exists."));
        return vector;
    }

    @Override
    public void serialize() {
        this.task = null;
    }
}

