/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskConstraintEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task task;
    private long taskUniqueId;
    private Constraint oldConstaint;
    private Constraint newConstraint;
    private boolean force;

    public TaskConstraintEdit(Task task, Constraint constraint, Constraint constraint2, String string) {
        this(task, constraint, constraint2, false, string);
    }

    public TaskConstraintEdit(Task task, Constraint constraint, Constraint constraint2, boolean bl, String string) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.oldConstaint = constraint;
        this.newConstraint = constraint2;
        this.force = bl;
        Common.log("Action: " + string + " - task constraint edit - task: " + task.getFullName() + " - old: " + constraint + " new: " + constraint2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.setForce(this.force);
        this.task.setConstraint(this.oldConstaint);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setForce(this.force);
        this.task.setConstraint(this.newConstraint);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
    }

    @Override
    public void serialize() {
        this.task = null;
        this.oldConstaint = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.setForce(this.force);
            this.task.setConstraint(this.newConstraint);
        }
        return null;
    }
}

