/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskCatchUpEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task task;
    private long taskUniqueId;
    private List<OldCompletion> oldCompletionList;
    private Date newCompletionDate;

    public TaskCatchUpEdit(Task task, Date date, String string) {
        this.task = task;
        this.newCompletionDate = date;
        this.taskUniqueId = task.getUniqueId();
        this.oldCompletionList = new LinkedList<OldCompletion>();
        this.storeOldCompletion(task);
        Common.log("Action: " + string + " - task catch up edit - task: " + task.getFullName() + " - new completion date: " + date);
    }

    private void storeOldCompletion(Task task) {
        if (task.isLeaf()) {
            this.oldCompletionList.add(new OldCompletion(task, task.getCompletion()));
        }
        for (Task task2 : task.getChildList()) {
            if (task2.isEmpty()) continue;
            this.storeOldCompletion(task2);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (OldCompletion oldCompletion : this.oldCompletionList) {
            oldCompletion.task.setCompletion(oldCompletion.completion);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.catchUp(this.newCompletionDate);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.catchUp(this.newCompletionDate);
        }
        return null;
    }

    @Override
    public void serialize() {
        this.task = null;
        this.oldCompletionList = null;
    }

    private class OldCompletion {
        private Task task;
        private double completion;

        public OldCompletion(Task task, double d) {
            this.task = task;
            this.completion = d;
        }
    }
}

