/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskCalendarEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task task;
    private long taskUniqueId;
    private CalendarManager oldCalendar;
    private CalendarManager newCalendar;
    private long newCalendarUniqueId;

    public TaskCalendarEdit(Task task, CalendarManager calendarManager, CalendarManager calendarManager2, String string) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.oldCalendar = calendarManager;
        this.newCalendar = calendarManager2;
        this.newCalendarUniqueId = calendarManager2 != null ? calendarManager2.getUniqueId() : Long.MIN_VALUE;
        Common.log("Action: " + string + " - task calendar edit - task: " + task.getFullName() + " - old: " + (calendarManager != null ? calendarManager.getName() : null) + " new: " + (calendarManager2 != null ? calendarManager2.getName() : null));
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.setCalendar(this.oldCalendar);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setCalendar(this.newCalendar);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
        if (this.newCalendarUniqueId != Long.MIN_VALUE) {
            this.newCalendar = (CalendarManager)hashMap.get(this.newCalendarUniqueId);
            if (this.newCalendar == null) {
                this.newCalendar = company.getCalendarForUniqueId(this.newCalendarUniqueId);
                hashMap.put(this.newCalendarUniqueId, this.newCalendar);
            }
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.setCalendar(this.newCalendar);
        }
        return null;
    }

    @Override
    public void serialize() {
        this.oldCalendar = null;
        this.newCalendar = null;
        this.task = null;
    }
}

