/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskAdditionalFieldEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task task;
    private long taskUniqueId;
    private String oldField;
    private String newField;
    private int index;

    public TaskAdditionalFieldEdit(Task task, String string, String string2, int n, String string3) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.oldField = string;
        this.newField = string2;
        this.index = n;
        Common.log("Action: " + string3 + " - task additional field edit - task: " + task.getFullName() + " - old: " + string + " new: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.setFieldAt(this.index, this.oldField);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setFieldAt(this.index, this.newField);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
    }

    @Override
    public void serialize() {
        this.task = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.setFieldAt(this.index, this.newField);
        }
        return null;
    }
}

