/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiskResponsePlanEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Risk risk;
    private long riskUniqueId;
    private String oldResponsePlan;
    private String newResponsePlan;
    private String actionId;

    public RiskResponsePlanEdit(Risk risk, String string, String string2, String string3) {
        this.risk = risk;
        this.riskUniqueId = risk.getUniqueId();
        this.actionId = risk.getDescription();
        this.oldResponsePlan = string;
        this.newResponsePlan = string2;
        Common.log("Action: " + string3 + " - risk response plan edit - risk: " + risk.getDescription() + " - old: " + string + " new: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.risk.setResponsePlan(this.oldResponsePlan);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.risk.setResponsePlan(this.newResponsePlan);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.risk = (Risk)hashMap.get(this.riskUniqueId);
        if (this.risk == null) {
            this.risk = company.getRiskForUniqueId(this.riskUniqueId);
            hashMap.put(this.riskUniqueId, this.risk);
        }
    }

    @Override
    public void serialize() {
        this.risk = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.risk != null) {
            this.risk.setResponsePlan(this.newResponsePlan);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("risk response plan edit", this.actionId, "Risk no longer exists."));
        return vector;
    }
}

