/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceStdRateEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Resource resource;
    private double oldStdRate;
    private double newStdRate;

    public ResourceStdRateEdit(Resource resource, double d, double d2, String string) {
        this.resource = resource;
        this.uniqueId = resource.getUniqueId();
        this.oldStdRate = d;
        this.newStdRate = d2;
        Common.log("Action: " + string + " - resource std rate edit - resource: " + resource.getName() + " - old: " + d + " new: " + d2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.resource.setStandardRate(this.oldStdRate);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.resource.setStandardRate(this.newStdRate);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.resource = (Resource)hashMap.get(this.uniqueId);
        if (this.resource == null) {
            this.resource = company.getResourceForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.resource);
        }
    }

    @Override
    public void serialize() {
        this.resource = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.resource != null) {
            this.resource.setStandardRate(this.newStdRate);
        }
        return null;
    }
}

