/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceNotesEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Resource resource;
    private String oldNotes;
    private String newNotes;
    private String actionId;

    public ResourceNotesEdit(Resource resource, String string, String string2, String string3) {
        this.resource = resource;
        this.uniqueId = resource.getUniqueId();
        this.oldNotes = string;
        this.newNotes = string2;
        this.actionId = string2;
        Common.log("Action: " + string3 + " - resource notes edit - resource: " + resource.getName() + " - old: " + string + " new: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.resource.setNotes(this.oldNotes);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.resource.setNotes(this.newNotes);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.resource = (Resource)hashMap.get(this.uniqueId);
        if (this.resource == null) {
            this.resource = company.getResourceForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.resource);
        }
    }

    @Override
    public void serialize() {
        this.resource = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.resource != null) {
            this.resource.setNotes(this.newNotes);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("resource notes edit", this.actionId, "Resource no longer exists."));
        return vector;
    }
}

