/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConstraintsEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long taskUniqueId;
    private Task task;
    private String oldConstraints;
    private String newConstraints;
    private String actionId;

    public ProjectConstraintsEdit(Task task, String string, String string2, String string3) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.oldConstraints = string;
        this.newConstraints = string2;
        this.actionId = string2;
        Common.log("Action: " + string3 + " - project constraints edit - task: " + task.getFullName() + " - old: " + string + " new: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.setConstraints(this.oldConstraints);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setConstraints(this.newConstraints);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
    }

    @Override
    public void serialize() {
        this.task = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.setConstraints(this.newConstraints);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("project constraints edit", this.actionId, "Project no longer exists."));
        return vector;
    }
}

