/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectClientEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long taskUniqueId;
    private Task task;
    private Client oldClient;
    private Client newClient;
    private long newClientId;
    private String actionId;

    public ProjectClientEdit(Task task, Client client, Client client2, String string) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.oldClient = client;
        this.newClient = client2;
        this.newClientId = client2.getUniqueId();
        this.actionId = client2.getName();
        Common.log("Action: " + string + " - project client edit - project: " + task.getFullName() + " - old: " + (client != null ? client.getName() : "null") + " new: " + (client2 != null ? client2.getName() : "null"));
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.setClient(this.oldClient);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setClient(this.newClient);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
        this.newClient = (Client)hashMap.get(this.newClientId);
        if (this.newClient == null) {
            this.newClient = company.getClientForUniqueId(this.newClientId);
            hashMap.put(this.newClientId, this.newClient);
        }
    }

    @Override
    public void serialize() {
        this.task = null;
        this.oldClient = null;
        this.newClient = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        Vector<FailedSerializableEdit> vector;
        if (this.task != null) {
            if (this.newClient != null) {
                this.task.setClient(this.newClient);
                return null;
            }
            this.task.setClient(null);
            vector = new Vector();
            vector.add(new FailedSerializableEdit("Project client edit", this.actionId, "Client no longer exists."));
        }
        vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("Project client edit", this.actionId, "Project no longer exists."));
        return vector;
    }
}

