/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MResourceMeasurementUnitEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private MaterialResource resource;
    private String oldMeasurementUnit;
    private String newMeasurementUnit;

    public MResourceMeasurementUnitEdit(MaterialResource materialResource, String string, String string2, String string3) {
        this.resource = materialResource;
        this.uniqueId = materialResource.getUniqueId();
        this.oldMeasurementUnit = string;
        this.newMeasurementUnit = string2;
        Common.log("Action: " + string3 + " - material resource measurement unit edit - resource: " + materialResource.getName() + " - old: " + string + " new: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.resource.setMeasurementUnit(this.oldMeasurementUnit);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.resource.setMeasurementUnit(this.newMeasurementUnit);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.resource = (MaterialResource)hashMap.get(this.uniqueId);
        if (this.resource == null) {
            this.resource = company.getMaterialResourceForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.resource);
        }
    }

    @Override
    public void serialize() {
        this.resource = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.resource != null) {
            this.resource.setMeasurementUnit(this.newMeasurementUnit);
        }
        return null;
    }
}

