/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HResourceCalendarEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private HumanResource resource;
    private long resourceUniqueId;
    private long newCalendarUniqueId;
    private CalendarManager oldCalendar;
    private CalendarManager newCalendar;

    public HResourceCalendarEdit(HumanResource humanResource, CalendarManager calendarManager, CalendarManager calendarManager2, String string) {
        this.resource = humanResource;
        this.oldCalendar = calendarManager;
        this.newCalendar = calendarManager2;
        this.resourceUniqueId = humanResource.getUniqueId();
        this.newCalendarUniqueId = calendarManager2 != null ? calendarManager2.getUniqueId() : Long.MIN_VALUE;
        Common.log("Action: " + string + " - human resource calendar changed - resource: " + humanResource.getName() + " - old: " + (calendarManager != null ? calendarManager.getName() : null) + " new value: " + (calendarManager2 != null ? calendarManager2.getName() : null));
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.resource.setCalendar(this.oldCalendar);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.resource.setCalendar(this.newCalendar);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.resource = (HumanResource)hashMap.get(this.resourceUniqueId);
        if (this.resource == null) {
            this.resource = company.getHumanResourceForUniqueId(this.resourceUniqueId);
            hashMap.put(this.resourceUniqueId, this.resource);
        }
        if (this.newCalendarUniqueId != Long.MIN_VALUE) {
            this.newCalendar = (CalendarManager)hashMap.get(this.newCalendarUniqueId);
            if (this.newCalendar == null) {
                this.newCalendar = company.getCalendarForUniqueId(this.newCalendarUniqueId);
                hashMap.put(this.newCalendarUniqueId, this.newCalendar);
            }
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.resource != null) {
            this.resource.setCalendar(this.newCalendar);
        }
        return null;
    }

    @Override
    public void serialize() {
        this.resource = null;
        this.oldCalendar = null;
        this.newCalendar = null;
    }
}

