/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientNotesEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Client client;
    private String oldNotes;
    private String newNotes;
    private String actionId;

    public ClientNotesEdit(Client client, String string, String string2, String string3) {
        this.client = client;
        this.uniqueId = client.getUniqueId();
        this.oldNotes = string;
        this.newNotes = string2;
        this.actionId = string2;
        Common.log("Action: " + string3 + " - client notes edit - task: " + client.getName() + " - old: " + string + " new: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.client.setNotes(this.oldNotes);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.client.setNotes(this.newNotes);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.client = (Client)hashMap.get(this.uniqueId);
        if (this.client == null) {
            this.client = company.getClientForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.client);
        }
    }

    @Override
    public void serialize() {
        this.client = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.client != null) {
            this.client.setNotes(this.newNotes);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("client notes edit", this.actionId, "Client no longer exists."));
        return vector;
    }
}

