/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Contact;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientMainContactEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ID = 4;
    private long uniqueId;
    private Client client;
    private Contact oldMainContact;
    private Contact newMainContact;

    public ClientMainContactEdit(Client client, Contact contact, Contact contact2, int n) {
        this.client = client;
        this.uniqueId = client.getUniqueId();
        this.oldMainContact = contact;
        this.newMainContact = contact2;
        Common.log("Action: " + n + " - client main contact edit - client: " + client.getName() + " - old value: " + (this.oldMainContact != null ? this.oldMainContact.getName() : null) + " new value: " + (this.newMainContact != null ? this.newMainContact.getName() : null));
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.client.setMainContact(this.oldMainContact);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.client.setMainContact(this.newMainContact);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.client = (Client)hashMap.get(this.uniqueId);
        if (this.client == null) {
            this.client = company.getClientForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.client);
        }
    }

    @Override
    public void serialize() {
        this.client = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }
}

