/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientDeleteEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Company company;
    private Client client;
    private long uniqueId;
    private int index;

    public ClientDeleteEdit(Company company, Client client, int n, String string) {
        this.company = company;
        this.client = client;
        this.index = n;
        this.uniqueId = client.getUniqueId();
        Common.log("Action: " + string + " - client deleted - client: " + client.getName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.company.addClient(this.index, this.client);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.company.removeClient(this.client);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.company = company;
        this.client = (Client)hashMap.get(this.uniqueId);
        if (this.client == null) {
            this.client = company.getClientForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.client);
        }
        if (this.client != null) {
            company.removeClient(this.client);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }

    @Override
    public void serialize() {
        this.client = null;
        this.company = null;
    }
}

