/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientAdditionalFieldEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Client client;
    private String oldField;
    private String newField;
    private int index;

    public ClientAdditionalFieldEdit(Client client, String string, String string2, int n, int n2) {
        this.client = client;
        this.uniqueId = client.getUniqueId();
        this.oldField = string;
        this.newField = string2;
        this.index = n;
        Common.log("Action: " + n2 + " - client aditional field edit - index: " + n + " - old field: " + string + " - new field: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.client.setFieldAt(this.index, this.oldField);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.client.setFieldAt(this.index, this.newField);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.client = (Client)hashMap.get(this.uniqueId);
        if (this.client == null) {
            this.client = company.getClientForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.client);
        }
        if (this.client != null) {
            this.client.setFieldAt(this.index, this.newField);
        }
    }

    @Override
    public void serialize() {
        this.client = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }
}

