/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarWeekPatternEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private CalendarManager calendar;
    private long uniqueId;
    private DayWorkingPattern oldPattern;
    private DayWorkingPattern newPattern;
    private int dayOfWeek;

    public CalendarWeekPatternEdit(Company company, CalendarManager calendarManager, DayWorkingPattern dayWorkingPattern, DayWorkingPattern dayWorkingPattern2, int n, String string) {
        this.calendar = calendarManager;
        this.uniqueId = calendarManager.getUniqueId();
        this.newPattern = dayWorkingPattern2;
        this.oldPattern = dayWorkingPattern;
        this.dayOfWeek = n;
        Common.log("Action: " + string + " - calendar week pattern changed - calendar: " + calendarManager.getName() + " day of week: " + n);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.calendar.beginTransaction();
        this.calendar.setDayPattern(this.dayOfWeek, this.oldPattern);
        this.calendar.endTransaction();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.calendar.beginTransaction();
        this.calendar.setDayPattern(this.dayOfWeek, this.newPattern);
        this.calendar.endTransaction();
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.calendar = (CalendarManager)hashMap.get(this.uniqueId);
        if (this.calendar == null) {
            this.calendar = company.getCalendarForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.calendar);
        }
    }

    @Override
    public void serialize() {
        this.calendar = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.calendar != null) {
            this.calendar.beginTransaction();
            this.calendar.setDayPattern(this.dayOfWeek, this.newPattern);
            this.calendar.endTransaction();
        }
        return null;
    }
}

