/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarResourcePatternEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private HumanResource resource;
    private long uniqueId;
    private DayWorkingPattern oldPattern;
    private DayWorkingPattern newPattern;
    private Calendar date;

    public CalendarResourcePatternEdit(HumanResource humanResource, DayWorkingPattern dayWorkingPattern, DayWorkingPattern dayWorkingPattern2, Calendar calendar, String string) {
        this.resource = humanResource;
        this.uniqueId = humanResource.getUniqueId();
        this.newPattern = dayWorkingPattern2;
        this.oldPattern = dayWorkingPattern;
        this.date = calendar;
        Common.log("Action: " + string + " - calendar resource special pattern changed - resource: " + humanResource.getName() + " date: " + calendar);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.resource.getResourceCalendar().beginTransaction();
        this.resource.getResourceCalendar().setResourceDayPattern(this.date, this.oldPattern);
        this.resource.getResourceCalendar().endTransaction();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.resource.getResourceCalendar().beginTransaction();
        this.resource.getResourceCalendar().setResourceDayPattern(this.date, this.newPattern);
        this.resource.getResourceCalendar().endTransaction();
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.resource = (HumanResource)hashMap.get(this.uniqueId);
        if (this.resource == null) {
            this.resource = company.getHumanResourceForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.resource);
        }
    }

    @Override
    public void serialize() {
        this.resource = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.resource != null) {
            this.resource.getResourceCalendar().beginTransaction();
            this.resource.getResourceCalendar().setResourceDayPattern(this.date, this.newPattern);
            this.resource.getResourceCalendar().endTransaction();
        }
        return null;
    }
}

