/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarNameEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private String newName;
    private String oldName;
    private String actionId;
    private CalendarManager calendar;

    public CalendarNameEdit(CalendarManager calendarManager, String string, String string2, String string3) {
        this.calendar = calendarManager;
        this.uniqueId = calendarManager.getUniqueId();
        this.oldName = string;
        this.newName = string2;
        this.actionId = string2;
        Common.log("Action: " + string3 + " - calendar name changed - old: " + string + " new: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.calendar.setName(this.oldName);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.calendar.setName(this.newName);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.calendar = (CalendarManager)hashMap.get(this.uniqueId);
        if (this.calendar == null) {
            this.calendar = company.getCalendarForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.calendar);
        }
    }

    @Override
    public void serialize() {
        this.calendar = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.calendar != null) {
            this.calendar.setName(this.newName);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("calendar name edit", this.actionId, "Calendar no longer exists."));
        return vector;
    }
}

