/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentUnitsEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Assignment assignment;
    private double oldUnits;
    private double newUnits;

    public AssignmentUnitsEdit(Assignment assignment, double d, double d2, String string) {
        this.assignment = assignment;
        this.uniqueId = assignment.getUniqueId();
        this.oldUnits = d;
        this.newUnits = d2;
        Common.log("Action: " + string + " - assignment units changed - " + assignment.getTask().getFullName() + " - " + assignment.getResource() + " old units: " + d + " new units: " + d2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.assignment.setUnits(this.oldUnits);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.assignment.setUnits(this.newUnits);
    }

    @Override
    public void serialize() {
        this.assignment = null;
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.assignment = (Assignment)hashMap.get(this.uniqueId);
        if (this.assignment == null) {
            this.assignment = company.getAssignmentForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.assignment);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.assignment != null) {
            this.assignment.setUnits(this.newUnits);
        }
        return null;
    }
}

