/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentRemoveEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Assignment assignment;
    private long assignmentId;
    private int taskIndex;
    private int resourceIndex;

    public AssignmentRemoveEdit(Assignment assignment, int n, int n2, String string) {
        this.assignment = assignment;
        this.taskIndex = n;
        this.resourceIndex = n2;
        this.assignmentId = assignment.getUniqueId();
        Common.log("Action: " + string + " - assignment removed - " + assignment.getTask().getFullName() + " - " + assignment.getResource());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.assignment.getTask().addAssignment(this.assignment, this.taskIndex);
        this.assignment.getResource().addAssignment(this.assignment, this.resourceIndex);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.assignment.getTask().removeAssignment(this.assignment);
        this.assignment.getResource().removeAssignment(this.assignment);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.assignment = (Assignment)hashMap.get(this.assignmentId);
        if (this.assignment == null) {
            this.assignment = company.getAssignmentForUniqueId(this.assignmentId);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.assignment != null) {
            this.assignment.getTask().removeAssignment(this.assignment);
            this.assignment.getResource().removeAssignment(this.assignment);
        }
        return null;
    }

    @Override
    public void serialize() {
        this.assignment = null;
    }
}

