/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentAddEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Assignment assignment;
    private long assignmentId;
    private long taskId;
    private long resourceId;

    public AssignmentAddEdit(Assignment assignment, String string) {
        this.assignment = assignment;
        this.assignmentId = assignment.getUniqueId();
        this.taskId = assignment.getTask().getUniqueId();
        this.resourceId = assignment.getResource().getUniqueId();
        Common.log("Action: " + string + " - assignment added - " + assignment.getTask().getFullName() + " - " + assignment.getResource());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.assignment.getTask().removeAssignment(this.assignment);
        this.assignment.getResource().removeAssignment(this.assignment);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.assignment.getTask().addAssignment(this.assignment);
        this.assignment.getResource().addAssignment(this.assignment);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        Resource resource;
        Task task = (Task)hashMap.get(this.taskId);
        if (task == null) {
            task = company.getTaskForUniqueId(this.taskId);
            hashMap.put(this.taskId, task);
        }
        if ((resource = (Resource)hashMap.get(this.resourceId)) == null) {
            resource = company.getResourceForUniqueId(this.resourceId);
            hashMap.put(this.resourceId, resource);
        }
        if (task != null && resource != null) {
            this.assignment = new Assignment(this.assignmentId, task, resource);
            task.addAssignment(this.assignment);
            resource.addAssignment(this.assignment);
            hashMap.put(this.assignmentId, this.assignment);
            uniqueIdContainer.newElement(this.assignment);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }

    @Override
    public void serialize() {
        this.assignment = null;
    }
}

