/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time.renderer;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.renderer.AbstractTimeScaleRenderer;
import com.sbs.jpm.ui.treetablechart.time.textFormatter.WeekShortTextFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class WeekScaleRenderer
extends AbstractTimeScaleRenderer {
    private static Calendar calendar = Calendar.getInstance();

    public WeekScaleRenderer() {
        this(1);
    }

    public WeekScaleRenderer(int n) {
        super(n);
        this.currentTextFormatter = new WeekShortTextFormatter(27, 35);
        this.friendlyName = n + " " + Common.I18N_RP.getString("weeks");
    }

    public long getApproximateUnitDuration() {
        return 604800000L * (long)this.multiplier;
    }

    protected List getTimeUnits(TimeFrame timeFrame, boolean bl) {
        LinkedList<Date> linkedList = new LinkedList<Date>();
        Date date = timeFrame.getStartDate();
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        linkedList.add(date);
        int n = calendar.get(3);
        int n2 = n / this.multiplier;
        int n3 = n2 * this.multiplier;
        calendar.set(3, n3);
        calendar.set(7, calendar.getFirstDayOfWeek());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.add(3, this.multiplier);
        date = calendar.getTime();
        while (date.before(timeFrame.getEndDate())) {
            linkedList.add(date);
            calendar.setTime(date);
            calendar.add(3, this.multiplier);
            calendar.set(7, calendar.getFirstDayOfWeek());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            date = calendar.getTime();
        }
        Date date3 = date;
        linkedList.add(timeFrame.getEndDate());
        if (bl) {
            linkedList.set(0, date2);
            linkedList.set(linkedList.size() - 1, date3);
        }
        return linkedList;
    }
}

