/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time.renderer;

import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.renderer.TimeScaleRenderer;
import java.awt.Graphics;

public class TimeScaleRendererCombination {
    private TimeScaleRenderer[] timeScales;
    private GraphicPrimitiveContainer graphicPrimitiveContainer;
    private int height = 0;

    public TimeScaleRendererCombination(TimeScaleRenderer[] timeScaleRendererArray) {
        this.timeScales = timeScaleRendererArray;
        this.graphicPrimitiveContainer = new GraphicPrimitiveContainer();
        for (int i = 0; i < timeScaleRendererArray.length; ++i) {
            this.height += timeScaleRendererArray[i].getHeight();
        }
    }

    public long getApproximateUnitDuration() {
        return this.timeScales[0].getApproximateUnitDuration();
    }

    public TimeScaleRenderer getBottomRenderer() {
        return this.timeScales[0];
    }

    public TimeScaleRenderer getNextBottomRenderer() {
        if (this.timeScales.length > 1) {
            return this.timeScales[1];
        }
        return null;
    }

    public int getPrefferedWidth() {
        return this.timeScales[0].getPrefferedWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public void paint(TimeFrame timeFrame, TimeScaleManager timeScaleManager, Painter painter, Graphics graphics, int n, int n2) {
        this.render(timeFrame, timeScaleManager, this.graphicPrimitiveContainer, n, n2);
        this.graphicPrimitiveContainer.paint(painter, graphics);
    }

    private void render(TimeFrame timeFrame, TimeScaleManager timeScaleManager, GraphicPrimitiveContainer graphicPrimitiveContainer, int n, int n2) {
        graphicPrimitiveContainer.clear();
        int n3 = 0;
        for (int i = this.timeScales.length - 1; i >= 0; --i) {
            this.timeScales[i].render(timeFrame, timeScaleManager, graphicPrimitiveContainer, n, n2 + n3);
            n3 += this.timeScales[i].getHeight();
        }
    }
}

