/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time.renderer;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.renderer.AbstractTimeScaleRenderer;
import com.sbs.jpm.ui.treetablechart.time.textFormatter.MonthMediumTextFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class MonthScaleRenderer
extends AbstractTimeScaleRenderer {
    private static final Calendar calendar = Calendar.getInstance();

    public MonthScaleRenderer() {
        this(1);
    }

    public MonthScaleRenderer(int n) {
        super(n);
        this.currentTextFormatter = new MonthMediumTextFormatter(60, 75);
        this.friendlyName = n + " " + Common.I18N_RP.getString("months");
    }

    public long getApproximateUnitDuration() {
        return 2592000000L * (long)this.multiplier;
    }

    protected List getTimeUnits(TimeFrame timeFrame, boolean bl) {
        LinkedList<Date> linkedList = new LinkedList<Date>();
        Date date = timeFrame.getStartDate();
        calendar.setTime(date);
        linkedList.add(date);
        int n = calendar.get(2);
        int n2 = n / this.multiplier;
        int n3 = n2 * this.multiplier;
        calendar.set(calendar.get(1), n3, 1, 0, 0, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.add(2, this.multiplier);
        date = calendar.getTime();
        while (date.before(timeFrame.getEndDate())) {
            linkedList.add(date);
            calendar.setTime(date);
            calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
            calendar.set(14, 0);
            calendar.add(2, this.multiplier);
            date = calendar.getTime();
        }
        Date date3 = date;
        linkedList.add(timeFrame.getEndDate());
        if (bl) {
            linkedList.set(0, date2);
            linkedList.set(linkedList.size() - 1, date3);
        }
        return linkedList;
    }
}

