/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time.renderer;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.renderer.AbstractTimeScaleRenderer;
import com.sbs.jpm.ui.treetablechart.time.textFormatter.HourShortTextFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class HourScaleRenderer
extends AbstractTimeScaleRenderer {
    private static final Calendar calendar = Calendar.getInstance();

    public HourScaleRenderer() {
        this(1);
    }

    public HourScaleRenderer(int n) {
        super(n);
        this.currentTextFormatter = new HourShortTextFormatter(18, 25);
        this.friendlyName = n + " " + Common.I18N_RP.getString("hours");
    }

    public long getApproximateUnitDuration() {
        return 3600000L * (long)this.multiplier;
    }

    protected List getTimeUnits(TimeFrame timeFrame, boolean bl) {
        LinkedList<Date> linkedList = new LinkedList<Date>();
        Date date = timeFrame.getStartDate();
        linkedList.add(date);
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        int n = calendar.get(11);
        int n2 = n / this.multiplier;
        int n3 = n2 * this.multiplier;
        calendar.set(11, n3);
        Date date2 = calendar.getTime();
        calendar.add(11, this.multiplier);
        date = calendar.getTime();
        while (date.before(timeFrame.getEndDate())) {
            linkedList.add(date);
            calendar.setTime(date);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), 0, 0);
            calendar.set(14, 0);
            calendar.add(11, this.multiplier);
            date = calendar.getTime();
        }
        Date date3 = date;
        linkedList.add(timeFrame.getEndDate());
        if (bl) {
            linkedList.set(0, date2);
            linkedList.set(linkedList.size() - 1, date3);
        }
        return linkedList;
    }

    public String getText(Date date) {
        calendar.setTime(date);
        int n = calendar.get(10);
        String string = Integer.toString(n);
        return string;
    }
}

