/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.ui.treetablechart.JResourceChart;
import com.sbs.jpm.ui.treetablechart.JResourceTreeTable;
import com.sbs.jpm.ui.treetablechart.ResourceSheetHighlighter;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.swing.tree.TreePath;

public class WorkTreeTableManager
extends TreeTableManager {
    private FontMetrics fm;

    public WorkTreeTableManager(JResourceTreeTable jResourceTreeTable, TimeScaleManager timeScaleManager) {
        super(jResourceTreeTable, timeScaleManager);
    }

    private void displayWork(long l, double d, double d2, Color color, Font font) {
        Formatter formatter = new Formatter();
        formatter.format("%.2f", (double)l / (double)this.treeTable.getProject().getDurationManager().getDuration(DurationManager.HOUR));
        String string = formatter.toString() + DurationManager.HOUR;
        int n = this.fm.stringWidth(string);
        if (n > this.timeScaleManager.getCurrentBottomUnitSize() - 5) {
            int n2;
            String string2 = "...";
            int n3 = this.fm.stringWidth(string2);
            for (n2 = 0; n2 < string.length() && (n3 += this.fm.charWidth(string.charAt(n2))) <= this.timeScaleManager.getCurrentBottomUnitSize() - 5; ++n2) {
            }
            string = string.substring(0, n2) + string2;
        }
        double d3 = d + 3.0;
        double d4 = d2 - 5.0;
        GraphicPrimitiveContainer.Text text = this.graphicPrimitiveContainer.createText(d3, d4, string);
        text.setStyle(PrimitiveStyle.TREETABLE_TEXT);
        text.setForegroundColor(color);
        text.setFont(font);
    }

    private void displayUnits(double d, double d2, double d3, Font font) {
        Formatter formatter = new Formatter();
        formatter.format("%.2f", d);
        String string = formatter.toString();
        int n = this.fm.stringWidth(string);
        if (n > this.timeScaleManager.getCurrentBottomUnitSize() - 5) {
            int n2;
            String string2 = "...";
            int n3 = this.fm.stringWidth(string2);
            for (n2 = 0; n2 < string.length() && (n3 += this.fm.charWidth(string.charAt(n2))) <= this.timeScaleManager.getCurrentBottomUnitSize() - 5; ++n2) {
            }
            string = string.substring(0, n2) + string2;
        }
        double d4 = d2 + 3.0;
        double d5 = d3 - 5.0;
        GraphicPrimitiveContainer.Text text = this.graphicPrimitiveContainer.createText(d4, d5, string);
        text.setStyle(PrimitiveStyle.TREETABLE_TEXT);
        text.setFont(font);
    }

    public void paint(Painter painter, Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        TimeFrame timeFrame = new TimeFrame(new Date(this.timeScaleManager.getMilis(rectangle.x)), new Date(this.timeScaleManager.getMilis(rectangle.x + rectangle.width)));
        this.render(timeFrame, graphics);
        this.graphicPrimitiveContainer.paint(painter, graphics);
    }

    protected void render(TimeFrame timeFrame, Graphics graphics) {
        this.fm = this.treeTable.getGraphics().getFontMetrics();
        this.graphicPrimitiveContainer.clear();
        int n = this.treeTable.getRowHeight();
        List<Integer> list = ((JResourceChart)this.treeTable.getTreeTableChart()).getResourceSheetData().getWorkDataList();
        int n2 = list.size();
        int n3 = n2 != 0 ? n / n2 : 18;
        int n4 = 0;
        int n5 = this.treeTable.getRowCount() - 1;
        Date[] dateArray = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getExtendedTimeUnits(timeFrame);
        Font font = this.treeTable.getFont();
        for (int i = 0; i < dateArray.length - 1; ++i) {
            double d = this.timeScaleManager.getX(dateArray[i].getTime());
            int n6 = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getMinWidth();
            double d2 = this.timeScaleManager.convertMilisToPixels(dateArray[1].getTime() - dateArray[0].getTime());
            if (i == 0 && (double)n6 > d2) continue;
            boolean bl = false;
            for (int j = n4; j <= n5; ++j) {
                int n7;
                UniqueId uniqueId;
                TreePath treePath = this.treeTable.getPathForRow(j);
                Object object = treePath.getLastPathComponent();
                if (object instanceof Assignment) {
                    uniqueId = (Assignment)object;
                    Resource resource = ((Assignment)uniqueId).getResource();
                    n7 = j * n;
                    block43: for (int k = 0; k < n2; ++k) {
                        Resource resource2;
                        n7 += n3;
                        if (resource instanceof HumanResource) {
                            resource2 = (HumanResource)resource;
                            if (!bl) {
                                ((Assignment)uniqueId).computeWork(dateArray[i], dateArray[i + 1], ((Assignment)uniqueId).getTask().getCompletionDate());
                            }
                            long l = ((HumanResource)resource2).getOvertimeWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            long l2 = ((HumanResource)resource2).getStandardWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            long l3 = l2 + l;
                            long l4 = ((HumanResource)resource2).getActualWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            long l5 = ((HumanResource)resource2).getRemainingWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            boolean bl2 = ((HumanResource)resource2).isOverallocated((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            boolean bl3 = l != 0L;
                            switch (list.get(k)) {
                                case 0: {
                                    if (l4 == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l4, d, n7, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l4, d, n7, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l4, d, n7, Color.BLACK, font);
                                    break;
                                }
                                case 1: {
                                    if (l5 == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l5, d, n7, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l5, d, n7, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l5, d, n7, Color.BLACK, font);
                                    break;
                                }
                                case 2: {
                                    if (l3 == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l3, d, n7, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l3, d, n7, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l3, d, n7, Color.BLACK, font);
                                    break;
                                }
                                case 3: {
                                    if (l2 == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l2, d, n7, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l2, d, n7, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l2, d, n7, Color.BLACK, font);
                                    break;
                                }
                                case 4: {
                                    if (l == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l, d, n7, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l, d, n7, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l, d, n7, Color.BLACK, font);
                                    break;
                                }
                                case 5: {
                                    break;
                                }
                                case 6: {
                                    break;
                                }
                                case 7: {
                                    break;
                                }
                            }
                            continue;
                        }
                        resource2 = (MaterialResource)resource;
                        switch (list.get(k)) {
                            case 0: {
                                double d3 = ((MaterialResource)resource2).getActualUnits((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                if (d3 == -1.0) continue block43;
                                this.displayUnits(d3, d, n7, font);
                                continue block43;
                            }
                            case 1: {
                                double d4 = ((MaterialResource)resource2).getRemainingUnits((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                if (d4 == -1.0) continue block43;
                                this.displayUnits(d4, d, n7, font);
                                continue block43;
                            }
                            case 2: {
                                double d5 = ((MaterialResource)resource2).getUnits((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                if (d5 == -1.0) continue block43;
                                this.displayUnits(d5, d, n7, font);
                                continue block43;
                            }
                            case 3: {
                                continue block43;
                            }
                            case 4: {
                                continue block43;
                            }
                            case 5: {
                                continue block43;
                            }
                            case 6: {
                                continue block43;
                            }
                            case 7: {
                                continue block43;
                            }
                        }
                    }
                    continue;
                }
                if (!(object instanceof Resource) || ((Resource)(uniqueId = (Resource)object)).isEmpty()) continue;
                int n8 = j * n;
                block44: for (n7 = 0; n7 < n2; ++n7) {
                    Resource resource;
                    n8 += n3;
                    if (uniqueId instanceof HumanResource) {
                        bl = true;
                        resource = (HumanResource)uniqueId;
                        ((HumanResource)resource).computeWork(dateArray[i], dateArray[i + 1]);
                        long l = ((HumanResource)resource).getOvertimeWork(dateArray[i], dateArray[i + 1]);
                        long l6 = ((HumanResource)resource).getOverallocatedWork(dateArray[i], dateArray[i + 1]);
                        long l7 = ((HumanResource)resource).getStandardWork(dateArray[i], dateArray[i + 1]);
                        long l8 = ((HumanResource)resource).getActualWork(dateArray[i], dateArray[i + 1]);
                        long l9 = ((HumanResource)resource).getRemainingWork(dateArray[i], dateArray[i + 1]);
                        long l10 = ((HumanResource)resource).getUsedWork(dateArray[i], dateArray[i + 1]);
                        long l11 = ((HumanResource)resource).getAvailableWork(dateArray[i], dateArray[i + 1]);
                        long l12 = ((HumanResource)resource).getCapacityWork(dateArray[i], dateArray[i + 1]);
                        long l13 = l7 + l;
                        boolean bl4 = ((HumanResource)resource).isOverallocated(dateArray[i], dateArray[i + 1]);
                        boolean bl5 = l != 0L;
                        switch (list.get(n7)) {
                            case 0: {
                                if (l8 == 0L) break;
                                if (bl4) {
                                    this.displayWork(l8, d, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    break;
                                }
                                if (bl5) {
                                    this.displayWork(l8, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    break;
                                }
                                this.displayWork(l8, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 1: {
                                if (l9 == 0L) break;
                                if (bl4) {
                                    this.displayWork(l9, d, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    break;
                                }
                                if (bl5) {
                                    this.displayWork(l9, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    break;
                                }
                                this.displayWork(l9, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 2: {
                                if (l13 == 0L) break;
                                if (bl4) {
                                    this.displayWork(l13, d, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    break;
                                }
                                if (bl5) {
                                    this.displayWork(l13, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    break;
                                }
                                this.displayWork(l13, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 3: {
                                if (l7 == 0L) break;
                                this.displayWork(l7, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 4: {
                                if (l == 0L) break;
                                this.displayWork(l, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                break;
                            }
                            case 5: {
                                if (l6 == 0L) break;
                                if (bl4) {
                                    this.displayWork(l6, d, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    break;
                                }
                                if (bl5) {
                                    this.displayWork(l6, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    break;
                                }
                                this.displayWork(l6, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 6: {
                                if (l10 == 0L) break;
                                if (bl4) {
                                    this.displayWork(l10, d, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    break;
                                }
                                if (l != 0L) {
                                    this.displayWork(l10, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    break;
                                }
                                this.displayWork(l10, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 7: {
                                if (l11 == 0L) break;
                                this.displayWork(l11, d, n8, Color.GREEN.darker().darker(), font.deriveFont(1));
                                break;
                            }
                            case 8: {
                                if (l12 == 0L) break;
                                this.displayWork(l12, d, n8, Color.BLACK, font.deriveFont(1));
                            }
                        }
                        continue;
                    }
                    resource = (MaterialResource)uniqueId;
                    switch (list.get(n7)) {
                        case 0: {
                            double d6 = ((MaterialResource)resource).getActualUnits(dateArray[i], dateArray[i + 1]);
                            if (d6 == -1.0) continue block44;
                            this.displayUnits(d6, d, n8, font);
                            continue block44;
                        }
                        case 1: {
                            double d7 = ((MaterialResource)resource).getRemainingUnits(dateArray[i], dateArray[i + 1]);
                            if (d7 == -1.0) continue block44;
                            this.displayUnits(d7, d, n8, font);
                            continue block44;
                        }
                        case 2: {
                            double d8 = ((MaterialResource)resource).getTotalUnits(dateArray[i], dateArray[i + 1]);
                            if (d8 == -1.0) continue block44;
                            this.displayUnits(d8, d, n8, font);
                            continue block44;
                        }
                        case 3: {
                            continue block44;
                        }
                        case 4: {
                            continue block44;
                        }
                        case 5: {
                            continue block44;
                        }
                        case 6: {
                            continue block44;
                        }
                        case 7: {
                            continue block44;
                        }
                    }
                }
            }
        }
    }
}

