/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.CompanyListener;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleAdapter;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleEvent;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleListener;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;

public abstract class TreeTableManager {
    protected boolean calendaristic;
    protected Task project;
    protected JTreeTable treeTable;
    protected TimeScaleManager timeScaleManager;
    protected GraphicPrimitiveContainer graphicPrimitiveContainer;
    private CompanyListener companyHandler;
    private TimeScaleListener timeScaleHandler;
    private TreeExpansionListener treeExpansionHandler;

    public TreeTableManager(JTreeTable jTreeTable, TimeScaleManager timeScaleManager) {
        this.treeTable = jTreeTable;
        this.timeScaleManager = timeScaleManager;
        this.graphicPrimitiveContainer = new GraphicPrimitiveContainer();
        this.companyHandler = new CompanyHandler();
        this.timeScaleHandler = new TimeScaleHandler();
        this.treeExpansionHandler = new TreeExpansionHandler();
        if (this.timeScaleManager != null) {
            this.timeScaleManager.addTimeScaleListener(this.timeScaleHandler);
        }
        jTreeTable.addTreeExpansionListener(this.treeExpansionHandler);
    }

    public void setProject(Task task) {
        if (this.project != null) {
            this.project.getCompany().removeCompanyListener(this.companyHandler);
        }
        this.treeTable.removeTreeExpansionListener(this.treeExpansionHandler);
        this.project = task;
        if (this.project != null) {
            this.project.getCompany().addCompanyListener(this.companyHandler);
        }
        this.treeTable.addTreeExpansionListener(this.treeExpansionHandler);
    }

    public void paint(Painter painter, Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        TimeFrame timeFrame = new TimeFrame(new Date(this.timeScaleManager.getMilis(rectangle.x)), new Date(this.timeScaleManager.getMilis(rectangle.x + rectangle.width)));
        if (this.graphicPrimitiveContainer.isDirty()) {
            this.graphicPrimitiveContainer.setDirty(false);
            this.render(timeFrame, graphics);
        }
        this.graphicPrimitiveContainer.paint(painter, graphics);
    }

    public void setCalendaristic(boolean bl) {
        this.calendaristic = bl;
        this.graphicPrimitiveContainer.setDirty(true);
    }

    protected abstract void render(TimeFrame var1, Graphics var2);

    public void setTimeScaleManager(TimeScaleManager timeScaleManager) {
        if (this.timeScaleManager != null) {
            this.timeScaleManager.removeTimeScaleListener(this.timeScaleHandler);
        }
        this.timeScaleManager = timeScaleManager;
        this.graphicPrimitiveContainer.setDirty(true);
        if (this.timeScaleManager != null) {
            this.timeScaleManager.addTimeScaleListener(this.timeScaleHandler);
        }
    }

    public TimeScaleManager getTimeScaleManager() {
        return this.timeScaleManager;
    }

    private class TreeExpansionHandler
    implements TreeExpansionListener {
        private TreeExpansionHandler() {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }
    }

    private class TimeScaleHandler
    extends TimeScaleAdapter {
        private TimeScaleHandler() {
        }

        public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }

        public void zoomInChanged(TimeScaleEvent timeScaleEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }

        public void zoomOutChanged(TimeScaleEvent timeScaleEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }
    }

    private class CompanyHandler
    extends CompanyAdapter {
        private CompanyHandler() {
        }

        public void companyChanged(CompanyEvent companyEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }

        public void resourceAdded(CompanyEvent companyEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }

        public void resourceRemoved(CompanyEvent companyEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }

        public void calendarAdded(CompanyEvent companyEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }

        public void calendarRemoved(CompanyEvent companyEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }

        public void currentProjectChanged(CompanyEvent companyEvent) {
            TreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
        }
    }
}

