/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleEvent;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleListener;
import com.sbs.jpm.ui.treetablechart.time.renderer.TimeScaleRendererCombination;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public abstract class TimeScaleManager {
    protected double focusPointPercent = 15.0;
    protected int currentScaleCursor = 4;
    protected double pixelDuration = 3456000.0;
    protected Task project;
    protected Date focusDate;
    protected boolean zoomedBottomUnitSizeActive = false;
    protected double zoomedBottomUnitSize;
    private boolean adjusting;
    protected GraphicPrimitiveContainer graphicPrimitiveContainer = new GraphicPrimitiveContainer();
    protected TimeScaleRendererCombination[] scaleCombinationList = this.createScaleCombinationList();
    protected EventListenerList listeners;

    public TimeScaleManager() {
        TimeScaleRendererCombination timeScaleRendererCombination = this.scaleCombinationList[this.currentScaleCursor];
        int n = timeScaleRendererCombination.getPrefferedWidth();
        this.pixelDuration = timeScaleRendererCombination.getApproximateUnitDuration() / (long)n;
        this.listeners = new EventListenerList();
    }

    public TimeScaleManager(TimeScaleManager timeScaleManager) {
        this();
        this.currentScaleCursor = timeScaleManager.currentScaleCursor;
        this.focusDate = timeScaleManager.focusDate;
        this.focusPointPercent = timeScaleManager.focusPointPercent;
        this.project = timeScaleManager.project;
        TimeScaleRendererCombination timeScaleRendererCombination = this.scaleCombinationList[this.currentScaleCursor];
        int n = timeScaleRendererCombination.getPrefferedWidth();
        this.pixelDuration = timeScaleRendererCombination.getApproximateUnitDuration() / (long)n;
        this.listeners = timeScaleManager.listeners;
    }

    protected abstract TimeScaleRendererCombination[] createScaleCombinationList();

    public void focusOnDate(Date date) {
        Date date2 = new Date(this.focusDate.getTime());
        this.focusDate = date;
        this.fireFocusOnDateChanged(date2);
    }

    public boolean canZoomIn() {
        return this.currentScaleCursor > 0;
    }

    public boolean canZoomOut() {
        return this.currentScaleCursor < this.scaleCombinationList.length - 1;
    }

    public TimeScaleRendererCombination getCurrentScaleCombination() {
        return this.scaleCombinationList[this.currentScaleCursor];
    }

    public int getCurrentBottomUnitSize() {
        if (this.zoomedBottomUnitSizeActive) {
            return (int)this.zoomedBottomUnitSize;
        }
        return this.getCurrentScaleCombination().getPrefferedWidth();
    }

    public void paint(Painter painter, Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        TimeFrame timeFrame = new TimeFrame(new Date(this.getMilis(rectangle.x)), new Date(this.getMilis(rectangle.x + rectangle.width)));
        this.getCurrentScaleCombination().paint(timeFrame, this, painter, graphics, 0, 0);
        this.render();
        this.graphicPrimitiveContainer.paint(painter, graphics);
    }

    public Rectangle2D getFocusRectangle() {
        double d = this.getX(this.getFocusDate().getTime());
        int n = this.getCurrentScaleCombination().getHeight() - 10;
        double d2 = 10.0;
        int n2 = 10;
        return new Rectangle2D.Double(d, n, d2, n2);
    }

    public Date getFocusDate() {
        return this.focusDate;
    }

    protected void render() {
        this.graphicPrimitiveContainer.clear();
        UIManager uIManager = UIManager.getInstance();
        if (uIManager.isShowFocusPoint()) {
            GraphicPrimitiveContainer.Rectangle rectangle = this.graphicPrimitiveContainer.createRectangle(this.getX(this.getFocusDate().getTime()) - 5.0, this.getCurrentScaleCombination().getHeight() - 10, 10.0, 10.0, true);
            rectangle.setStyle(PrimitiveStyle.FOCUS_DATE);
        }
    }

    public void shift(int n) {
        this.fireShiftChanged(n);
    }

    private void computePixelDuration() {
        this.pixelDuration = this.scaleCombinationList[this.currentScaleCursor].getApproximateUnitDuration() / (long)this.scaleCombinationList[this.currentScaleCursor].getPrefferedWidth();
    }

    public int zoom(int n, int n2) {
        double d;
        double d2 = this.getX(this.getFocusDate().getTime());
        double d3 = (double)n / 3.0;
        if (!this.zoomedBottomUnitSizeActive) {
            this.zoomedBottomUnitSizeActive = true;
            this.zoomedBottomUnitSize = this.scaleCombinationList[this.currentScaleCursor].getBottomRenderer().getPrefferedWidth();
        }
        if ((d = this.zoomedBottomUnitSize + this.zoomedBottomUnitSize * d3 / 100.0) < (double)this.scaleCombinationList[this.currentScaleCursor].getBottomRenderer().getMinWidth()) {
            return n2;
        }
        if (d3 < 0.0) {
            this.zoomedBottomUnitSize = d;
            this.pixelDuration = (double)this.scaleCombinationList[this.currentScaleCursor].getApproximateUnitDuration() / this.zoomedBottomUnitSize;
            double d4 = this.getX(this.getFocusDate().getTime());
            double d5 = d4 - d2;
            this.fireTimeScaleChanged();
            this.shift((int)d5);
            return n2 + (int)d5;
        }
        if (d < 1600.0) {
            double d6 = this.zoomedBottomUnitSize;
            double d7 = this.pixelDuration;
            this.zoomedBottomUnitSize = d;
            this.pixelDuration = (double)this.scaleCombinationList[this.currentScaleCursor].getApproximateUnitDuration() / this.zoomedBottomUnitSize;
            if ((double)(this.project.getEndDate().getTime() - this.project.getStartDate().getTime()) / this.getPixelDuration() + 3200.0 >= 1.073741823E9) {
                this.zoomedBottomUnitSize = d6;
                this.pixelDuration = d7;
                return n2;
            }
            double d8 = this.getX(this.getFocusDate().getTime());
            double d9 = d8 - d2;
            this.fireTimeScaleChanged();
            this.shift((int)d9);
            return n2 + (int)d9;
        }
        return n2;
    }

    public void zoomOut() {
        if (this.currentScaleCursor < this.scaleCombinationList.length - 1) {
            if (this.zoomedBottomUnitSizeActive) {
                double d = this.zoomedBottomUnitSize;
                double d2 = this.scaleCombinationList[this.currentScaleCursor].getBottomRenderer().getApproximateUnitDuration();
                double d3 = d2 / d;
                int n = 0;
                double d4 = 9.223372036854776E18;
                for (int i = 0; i < this.scaleCombinationList.length; ++i) {
                    TimeScaleRendererCombination timeScaleRendererCombination = this.scaleCombinationList[i];
                    double d5 = timeScaleRendererCombination.getBottomRenderer().getPrefferedWidth();
                    double d6 = timeScaleRendererCombination.getBottomRenderer().getApproximateUnitDuration();
                    double d7 = d6 / d5;
                    if (!(Math.abs(d3 - d7) < d4)) continue;
                    d4 = Math.abs(d3 - d7);
                    n = i;
                }
                this.currentScaleCursor = n;
            } else {
                ++this.currentScaleCursor;
            }
            this.zoomedBottomUnitSizeActive = false;
            this.computePixelDuration();
            this.adjusting = true;
            this.fireZoomOutWillChange();
            this.fireTimeScaleChanged();
            this.fireZoomOutChanged();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TimeScaleManager.this.adjusting = false;
                }
            });
        }
    }

    public void zoomIn() {
        if (this.currentScaleCursor > 0) {
            if (this.zoomedBottomUnitSizeActive) {
                double d = this.zoomedBottomUnitSize;
                double d2 = this.scaleCombinationList[this.currentScaleCursor].getBottomRenderer().getApproximateUnitDuration();
                double d3 = d2 / d;
                int n = 0;
                double d4 = 9.223372036854776E18;
                for (int i = 0; i < this.scaleCombinationList.length; ++i) {
                    TimeScaleRendererCombination timeScaleRendererCombination = this.scaleCombinationList[i];
                    double d5 = timeScaleRendererCombination.getBottomRenderer().getPrefferedWidth();
                    double d6 = timeScaleRendererCombination.getBottomRenderer().getApproximateUnitDuration();
                    double d7 = d6 / d5;
                    if (!(Math.abs(d3 - d7) < d4)) continue;
                    d4 = Math.abs(d3 - d7);
                    n = i;
                }
                this.currentScaleCursor = n;
            } else {
                --this.currentScaleCursor;
            }
            this.zoomedBottomUnitSizeActive = false;
            this.computePixelDuration();
            this.adjusting = true;
            this.fireTimeScaleChanged();
            this.fireZoomInChanged();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TimeScaleManager.this.adjusting = false;
                }
            });
        }
    }

    public double getPixelDuration() {
        return this.pixelDuration;
    }

    public TimeFrame getProjectTimeFrame() {
        Date date = new Date(this.project.getStartDate().getTime() - (long)(1600.0 * this.getPixelDuration()));
        Date date2 = new Date(this.project.getEndDate().getTime() + (long)(1600.0 * this.getPixelDuration()));
        return new TimeFrame(date, date2);
    }

    public void addTimeScaleListener(TimeScaleListener timeScaleListener) {
        this.listeners.add(TimeScaleListener.class, timeScaleListener);
    }

    public void removeTimeScaleListener(TimeScaleListener timeScaleListener) {
        this.listeners.remove(TimeScaleListener.class, timeScaleListener);
    }

    protected void fireTimeScaleChanged() {
        TimeScaleEvent timeScaleEvent = new TimeScaleEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TimeScaleListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TimeScaleListener)eventListenerArray[i]).timeScaleChanged(timeScaleEvent);
        }
    }

    protected void fireZoomInChanged() {
        TimeScaleEvent timeScaleEvent = new TimeScaleEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TimeScaleListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TimeScaleListener)eventListenerArray[i]).zoomInChanged(timeScaleEvent);
        }
    }

    protected void fireZoomOutChanged() {
        TimeScaleEvent timeScaleEvent = new TimeScaleEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TimeScaleListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TimeScaleListener)eventListenerArray[i]).zoomOutChanged(timeScaleEvent);
        }
    }

    protected void fireZoomOutWillChange() {
        TimeScaleEvent timeScaleEvent = new TimeScaleEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TimeScaleListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TimeScaleListener)eventListenerArray[i]).zoomOutWillChange(timeScaleEvent);
        }
    }

    protected void fireFocusOnDateChanged(Date date) {
        TimeScaleEvent timeScaleEvent = new TimeScaleEvent((Object)this, date);
        EventListener[] eventListenerArray = this.listeners.getListeners(TimeScaleListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TimeScaleListener)eventListenerArray[i]).focusOnDateChanged(timeScaleEvent);
        }
    }

    protected void fireFocusDateChanged() {
        TimeScaleEvent timeScaleEvent = new TimeScaleEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TimeScaleListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TimeScaleListener)eventListenerArray[i]).focusDateChanged(timeScaleEvent);
        }
    }

    protected void fireShiftChanged(int n) {
        TimeScaleEvent timeScaleEvent = new TimeScaleEvent((Object)this, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(TimeScaleListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((TimeScaleListener)eventListenerArray[i]).shiftChanged(timeScaleEvent);
        }
    }

    public long convertPixelsToMilis(int n) {
        double d = (double)n * this.getPixelDuration();
        return (long)d;
    }

    public double convertMilisToPixels(long l) {
        double d = (double)l / this.getPixelDuration();
        return d;
    }

    public double getX(long l) {
        return (double)(l - this.getProjectTimeFrame().getStartDate().getTime()) / this.getPixelDuration();
    }

    public double getWidth(TimeFrame timeFrame) {
        return (double)(timeFrame.getEndDate().getTime() - timeFrame.getStartDate().getTime()) / this.getPixelDuration();
    }

    public long getMilis(double d) {
        return (long)((double)this.getProjectTimeFrame().getStartDate().getTime() + d * this.getPixelDuration());
    }

    public GraphicPrimitiveContainer.GraphicPrimitive getSelectablePrimitive(int n, int n2, int n3, int n4, PrimitiveStyle primitiveStyle) {
        GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.graphicPrimitiveContainer.getSelectablePrimitive(n, n2, n3, n4, primitiveStyle);
        return graphicPrimitive;
    }

    public int getCurrentScaleCursor() {
        return this.currentScaleCursor;
    }

    public void setCurrentScaleCursor(int n) {
        if (n < this.scaleCombinationList.length && n >= 0) {
            int n2 = this.currentScaleCursor;
            this.currentScaleCursor = n;
            this.zoomedBottomUnitSizeActive = false;
            this.computePixelDuration();
            this.adjusting = true;
            if (n2 > n) {
                this.fireTimeScaleChanged();
                this.fireZoomInChanged();
            } else {
                this.fireZoomOutWillChange();
                this.fireTimeScaleChanged();
                this.fireZoomOutChanged();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TimeScaleManager.this.adjusting = false;
                }
            });
        }
    }

    public TimeScaleRendererCombination getScaleCombination(int n) {
        return this.scaleCombinationList[n];
    }

    public int getScaleCombinationLength() {
        return this.scaleCombinationList.length;
    }

    public void setFocusDate(Date date) {
        this.focusDate = date;
        this.fireFocusDateChanged();
    }

    public void setProject(Task task) {
        this.project = task;
    }

    public Task getProject() {
        return this.project;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public double getFocusPointPercent() {
        return this.focusPointPercent;
    }

    public void setFocusPointPercent(double d) {
        this.focusPointPercent = d;
    }
}

