/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.core.CurrencyManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.treetablechart.JTaskSheetTreeTable;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;
import java.util.Formatter;
import javax.swing.tree.TreePath;

public class TaskCostTreeTableManager
extends TreeTableManager {
    private FontMetrics fm;

    public TaskCostTreeTableManager(JTaskSheetTreeTable jTaskSheetTreeTable, TimeScaleManager timeScaleManager) {
        super(jTaskSheetTreeTable, timeScaleManager);
    }

    private void displayCost(double d, double d2, double d3, Color color) {
        Formatter formatter = new Formatter();
        formatter.format(this.treeTable.getProject().getCompany().getRootTask().getCurrencyUnit() + "%." + CurrencyManager.getFractionDigits() + "f", d);
        String string = formatter.toString();
        int n = this.fm.stringWidth(string);
        if (n > this.timeScaleManager.getCurrentBottomUnitSize() - 5) {
            int n2;
            String string2 = "...";
            int n3 = this.fm.stringWidth(string2);
            for (n2 = 0; n2 < string.length() && (n3 += this.fm.charWidth(string.charAt(n2))) <= this.timeScaleManager.getCurrentBottomUnitSize() - 5; ++n2) {
            }
            string = string.substring(0, n2) + string2;
        }
        double d4 = d2 + 3.0;
        double d5 = d3 - 5.0;
        GraphicPrimitiveContainer.Text text = this.graphicPrimitiveContainer.createText(d4, d5, string);
        text.setStyle(PrimitiveStyle.TREETABLE_TEXT);
        text.setForegroundColor(color);
    }

    public void paint(Painter painter, Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        TimeFrame timeFrame = new TimeFrame(new Date(this.timeScaleManager.getMilis(rectangle.x)), new Date(this.timeScaleManager.getMilis(rectangle.x + rectangle.width)));
        this.render(timeFrame, graphics);
        this.graphicPrimitiveContainer.paint(painter, graphics);
    }

    protected void render(TimeFrame timeFrame, Graphics graphics) {
        this.fm = this.treeTable.getGraphics().getFontMetrics();
        this.graphicPrimitiveContainer.clear();
        int n = this.treeTable.getRowHeight();
        int n2 = 0;
        int n3 = this.treeTable.getRowCount() - 1;
        Date[] dateArray = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getExtendedTimeUnits(timeFrame);
        for (int i = 0; i < dateArray.length - 1; ++i) {
            double d = this.timeScaleManager.getX(dateArray[i].getTime());
            int n4 = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getMinWidth();
            double d2 = this.timeScaleManager.convertMilisToPixels(dateArray[1].getTime() - dateArray[0].getTime());
            if (i == 0 && (double)n4 > d2) continue;
            for (int j = n2; j <= n3; ++j) {
                TreePath treePath = this.treeTable.getPathForRow(j);
                Task task = (Task)treePath.getLastPathComponent();
                int n5 = (j + 1) * n;
                if (task.isEmpty()) continue;
                if (task.isMilestone()) {
                    Date date = task.getStartDate();
                    if (date.before(dateArray[i]) || !date.before(dateArray[i + 1])) continue;
                    double d3 = task.getCost(dateArray[i], dateArray[i + 1]);
                    this.displayCost(d3, d, n5, Color.BLACK);
                    continue;
                }
                double d4 = task.getCost(dateArray[i], dateArray[i + 1]);
                boolean bl = false;
                if (d4 != 0.0) {
                    bl = true;
                } else if (task.getWorkingDuration(dateArray[i], dateArray[i + 1]) != 0L) {
                    bl = true;
                }
                if (!bl) continue;
                this.displayCost(d4, d, n5, Color.BLACK);
            }
        }
    }
}

