/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.treetablechart.JResourceChart;
import com.sbs.jpm.ui.treetablechart.time.CostTreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.WorkTreeTableManager;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceSheetData {
    public static final int ACTUAL_WORK = 0;
    public static final int REMAINING_WORK = 1;
    public static final int ASSIGNED_WORK = 2;
    public static final int STANDARD_WORK = 3;
    public static final int OVERTIME_WORK = 4;
    public static final int OVERALLOCATED_WORK = 5;
    public static final int USED_WORK = 6;
    public static final int AVAILABLE_WORK = 7;
    public static final int CAPACITY_WORK = 8;
    public static final int ACTUAL_COST = 9;
    public static final int REMAINING_COST = 10;
    public static final int TOTAL_COST = 11;
    public static final int STANDARD_COST = 12;
    public static final int OVERTIME_COST = 13;
    private JResourceChart resourceChart;
    private List<Integer> workDataList;
    private List<Integer> costDataList;

    public ResourceSheetData(JResourceChart jResourceChart) {
        this.resourceChart = jResourceChart;
        this.workDataList = new LinkedList<Integer>();
        this.workDataList.add(2);
        this.costDataList = new LinkedList<Integer>();
        this.costDataList.add(11);
    }

    public void addWorkData(int n) {
        if (!this.workDataList.contains(n)) {
            this.workDataList.add(n);
            this.updateDataHeight();
        }
    }

    public void removeWorkData(int n) {
        this.workDataList.remove(new Integer(n));
        this.updateDataHeight();
    }

    public void addCostData(int n) {
        if (!this.costDataList.contains(n)) {
            this.costDataList.add(n);
            this.updateDataHeight();
        }
    }

    public void removeCostData(int n) {
        this.costDataList.remove(new Integer(n));
        this.updateDataHeight();
    }

    public void updateDataHeight() {
        TreeTableManager treeTableManager = this.resourceChart.getArea().getChartArea().getTreeTableManager();
        int n = treeTableManager instanceof WorkTreeTableManager ? this.workDataList.size() * 18 : (treeTableManager instanceof CostTreeTableManager ? this.costDataList.size() * 18 : 18);
        if (n == 0) {
            n = 18;
        }
        this.resourceChart.getTreeTable().setRowHeight(n);
        this.resourceChart.getResourceDataType().setFixedCellHeight(n);
        this.resourceChart.getRowHeader().setFixedCellHeight(n);
        this.resourceChart.revalidate();
        this.resourceChart.repaint();
    }

    public List<Integer> getWorkDataList() {
        return this.workDataList;
    }

    public List<Integer> getCostDataList() {
        return this.costDataList;
    }

    public static String typeAsString(int n) {
        switch (n) {
            case 0: {
                return Common.I18N_RP.getString("actual");
            }
            case 1: {
                return Common.I18N_RP.getString("remaining");
            }
            case 2: {
                return Common.I18N_RP.getString("assigned");
            }
            case 3: {
                return Common.I18N_RP.getString("standard");
            }
            case 4: {
                return Common.I18N_RP.getString("overtime");
            }
            case 5: {
                return Common.I18N_RP.getString("overallocated");
            }
            case 6: {
                return Common.I18N_RP.getString("used");
            }
            case 7: {
                return Common.I18N_RP.getString("available");
            }
            case 8: {
                return Common.I18N_RP.getString("capacity");
            }
            case 9: {
                return Common.I18N_RP.getString("actual");
            }
            case 10: {
                return Common.I18N_RP.getString("remaining");
            }
            case 11: {
                return Common.I18N_RP.getString("total");
            }
            case 12: {
                return Common.I18N_RP.getString("standard");
            }
            case 13: {
                return Common.I18N_RP.getString("overtime");
            }
        }
        return "";
    }

    public JResourceChart getResourceChart() {
        return this.resourceChart;
    }
}

