/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.CurrencyManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.ui.treetablechart.JResourceChart;
import com.sbs.jpm.ui.treetablechart.JResourceTreeTable;
import com.sbs.jpm.ui.treetablechart.ResourceSheetHighlighter;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.swing.tree.TreePath;

public class CostTreeTableManager
extends TreeTableManager {
    private FontMetrics fm;

    public CostTreeTableManager(JResourceTreeTable jResourceTreeTable, TimeScaleManager timeScaleManager) {
        super(jResourceTreeTable, timeScaleManager);
    }

    private void displayCost(double d, double d2, double d3, Color color, Font font) {
        Formatter formatter = new Formatter();
        formatter.format(this.treeTable.getProject().getCompany().getRootTask().getCurrencyUnit() + "%." + CurrencyManager.getFractionDigits() + "f", d);
        String string = formatter.toString();
        int n = this.fm.stringWidth(string);
        if (n > this.timeScaleManager.getCurrentBottomUnitSize() - 5) {
            int n2;
            String string2 = "...";
            int n3 = this.fm.stringWidth(string2);
            for (n2 = 0; n2 < string.length() && (n3 += this.fm.charWidth(string.charAt(n2))) <= this.timeScaleManager.getCurrentBottomUnitSize() - 5; ++n2) {
            }
            string = string.substring(0, n2) + string2;
        }
        double d4 = d2 + 3.0;
        double d5 = d3 - 5.0;
        GraphicPrimitiveContainer.Text text = this.graphicPrimitiveContainer.createText(d4, d5, string);
        text.setStyle(PrimitiveStyle.TREETABLE_TEXT);
        text.setForegroundColor(color);
        text.setFont(font);
    }

    public void paint(Painter painter, Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        TimeFrame timeFrame = new TimeFrame(new Date(this.timeScaleManager.getMilis(rectangle.x)), new Date(this.timeScaleManager.getMilis(rectangle.x + rectangle.width)));
        this.render(timeFrame, graphics);
        this.graphicPrimitiveContainer.paint(painter, graphics);
    }

    protected void render(TimeFrame timeFrame, Graphics graphics) {
        this.fm = this.treeTable.getGraphics().getFontMetrics();
        this.graphicPrimitiveContainer.clear();
        int n = this.treeTable.getRowHeight();
        List<Integer> list = ((JResourceChart)this.treeTable.getTreeTableChart()).getResourceSheetData().getCostDataList();
        int n2 = list.size();
        int n3 = n2 != 0 ? n / n2 : 18;
        int n4 = 0;
        int n5 = this.treeTable.getRowCount() - 1;
        Date[] dateArray = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getExtendedTimeUnits(timeFrame);
        Font font = this.treeTable.getFont();
        for (int i = 0; i < dateArray.length - 1; ++i) {
            double d = this.timeScaleManager.getX(dateArray[i].getTime());
            int n6 = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getMinWidth();
            double d2 = this.timeScaleManager.convertMilisToPixels(dateArray[1].getTime() - dateArray[0].getTime());
            if (i == 0 && (double)n6 > d2) continue;
            boolean bl = false;
            for (int j = n4; j <= n5; ++j) {
                boolean bl2;
                boolean bl3;
                int n7;
                UniqueId uniqueId;
                TreePath treePath = this.treeTable.getPathForRow(j);
                Object object = treePath.getLastPathComponent();
                if (object instanceof Assignment) {
                    uniqueId = (Assignment)object;
                    Resource resource = ((Assignment)uniqueId).getResource();
                    n7 = j * n;
                    block28: for (int k = 0; k < n2; ++k) {
                        n7 += n3;
                        if (resource instanceof HumanResource) {
                            HumanResource humanResource = (HumanResource)resource;
                            if (!bl) {
                                ((Assignment)uniqueId).computeWork(dateArray[i], dateArray[i + 1], ((Assignment)uniqueId).getTask().getCompletionDate());
                            }
                            double d3 = humanResource.getOvertimeCost((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            double d4 = humanResource.getStandardCost((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            double d5 = d4 + d3;
                            double d6 = humanResource.getActualCost((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            double d7 = humanResource.getRemainingCost((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            boolean bl4 = humanResource.isOverallocated((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            bl3 = false;
                            if (d3 != 0.0) {
                                bl3 = true;
                            } else if (humanResource.getOvertimeWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]) != 0L) {
                                bl3 = true;
                            }
                            switch (list.get(k)) {
                                case 9: {
                                    long l;
                                    bl2 = false;
                                    if (d6 == 0.0) {
                                        l = humanResource.getActualWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                        if (l != 0L) {
                                            bl2 = true;
                                        }
                                    } else {
                                        bl2 = true;
                                    }
                                    if (!bl2) continue block28;
                                    if (bl4) {
                                        this.displayCost(d6, d, n7, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayCost(d6, d, n7, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayCost(d6, d, n7, Color.BLACK, font);
                                    break;
                                }
                                case 10: {
                                    long l;
                                    bl2 = false;
                                    if (d7 == 0.0) {
                                        l = humanResource.getRemainingWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                        if (l != 0L) {
                                            bl2 = true;
                                        }
                                    } else {
                                        bl2 = true;
                                    }
                                    if (!bl2) continue block28;
                                    if (bl4) {
                                        this.displayCost(d7, d, n7, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayCost(d7, d, n7, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayCost(d7, d, n7, Color.BLACK, font);
                                    break;
                                }
                                case 11: {
                                    long l;
                                    bl2 = false;
                                    if (d5 == 0.0) {
                                        long l2;
                                        l = humanResource.getStandardWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                        if (l + (l2 = humanResource.getOvertimeWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1])) != 0L) {
                                            bl2 = true;
                                        }
                                    } else {
                                        bl2 = true;
                                    }
                                    if (!bl2) continue block28;
                                    if (bl4) {
                                        this.displayCost(d5, d, n7, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayCost(d5, d, n7, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayCost(d5, d, n7, Color.BLACK, font);
                                    break;
                                }
                                case 12: {
                                    long l;
                                    bl2 = false;
                                    if (d4 == 0.0) {
                                        l = humanResource.getStandardWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                        if (l != 0L) {
                                            bl2 = true;
                                        }
                                    } else {
                                        bl2 = true;
                                    }
                                    if (!bl2) continue block28;
                                    this.displayCost(d4, d, n7, Color.BLACK, font);
                                    break;
                                }
                                case 13: {
                                    long l;
                                    bl2 = false;
                                    if (d3 == 0.0) {
                                        l = humanResource.getOvertimeWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                        if (l != 0L) {
                                            bl2 = true;
                                        }
                                    } else {
                                        bl2 = true;
                                    }
                                    if (!bl2) break;
                                    this.displayCost(d3, d, n7, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                }
                            }
                            continue;
                        }
                        switch (list.get(k)) {
                            case 9: {
                                double d8 = resource.getActualCost((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                if (d8 == -1.0) continue block28;
                                this.displayCost(d8, d, n7, Color.BLACK, font);
                                continue block28;
                            }
                            case 10: {
                                double d9 = resource.getRemainingCost((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                if (d9 == -1.0) continue block28;
                                this.displayCost(d9, d, n7, Color.BLACK, font);
                                continue block28;
                            }
                            case 11: {
                                double d10 = resource.getCost((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                if (d10 == -1.0) continue block28;
                                this.displayCost(d10, d, n7, Color.BLACK, font);
                                continue block28;
                            }
                            case 12: {
                                continue block28;
                            }
                        }
                    }
                    continue;
                }
                if (!(object instanceof Resource) || ((Resource)(uniqueId = (Resource)object)).isEmpty()) continue;
                int n8 = j * n;
                block29: for (n7 = 0; n7 < n2; ++n7) {
                    n8 += n3;
                    if (uniqueId instanceof HumanResource) {
                        bl = true;
                        HumanResource humanResource = (HumanResource)uniqueId;
                        humanResource.computeWork(dateArray[i], dateArray[i + 1]);
                        long l = humanResource.getOvertimeWork(dateArray[i], dateArray[i + 1]);
                        double d11 = humanResource.getOvertimeCost(dateArray[i], dateArray[i + 1]);
                        double d12 = humanResource.getStandardCost(dateArray[i], dateArray[i + 1]);
                        double d13 = d12 + d11;
                        double d14 = humanResource.getActualCost(dateArray[i], dateArray[i + 1]);
                        double d15 = humanResource.getRemainingCost(dateArray[i], dateArray[i + 1]);
                        bl3 = humanResource.isOverallocated(dateArray[i], dateArray[i + 1]);
                        bl2 = l != 0L;
                        switch (list.get(n7)) {
                            case 9: {
                                long l3;
                                boolean bl5 = false;
                                if (d14 == 0.0) {
                                    l3 = humanResource.getActualWork(dateArray[i], dateArray[i + 1]);
                                    if (l3 != 0L) {
                                        bl5 = true;
                                    }
                                } else {
                                    bl5 = true;
                                }
                                if (!bl5) continue block29;
                                if (bl3) {
                                    this.displayCost(d14, d, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    break;
                                }
                                if (bl2) {
                                    this.displayCost(d14, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    break;
                                }
                                this.displayCost(d14, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 10: {
                                long l3;
                                boolean bl5 = false;
                                if (d15 == 0.0) {
                                    l3 = humanResource.getRemainingWork(dateArray[i], dateArray[i + 1]);
                                    if (l3 != 0L) {
                                        bl5 = true;
                                    }
                                } else {
                                    bl5 = true;
                                }
                                if (!bl5) continue block29;
                                if (bl3) {
                                    this.displayCost(d15, d, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    break;
                                }
                                if (bl2) {
                                    this.displayCost(d15, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    break;
                                }
                                this.displayCost(d15, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 11: {
                                long l3;
                                boolean bl5 = false;
                                if (d13 == 0.0) {
                                    l3 = humanResource.getStandardWork(dateArray[i], dateArray[i + 1]) + humanResource.getOvertimeWork(dateArray[i], dateArray[i + 1]);
                                    if (l3 != 0L) {
                                        bl5 = true;
                                    }
                                } else {
                                    bl5 = true;
                                }
                                if (!bl5) continue block29;
                                if (bl3) {
                                    this.displayCost(d13, d, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    break;
                                }
                                if (bl2) {
                                    this.displayCost(d13, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    break;
                                }
                                this.displayCost(d13, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 12: {
                                long l3;
                                boolean bl5 = false;
                                if (d12 == 0.0) {
                                    l3 = humanResource.getStandardWork(dateArray[i], dateArray[i + 1]);
                                    if (l3 != 0L) {
                                        bl5 = true;
                                    }
                                } else {
                                    bl5 = true;
                                }
                                if (!bl5) continue block29;
                                this.displayCost(d12, d, n8, Color.BLACK, font.deriveFont(1));
                                break;
                            }
                            case 13: {
                                long l3;
                                boolean bl5 = false;
                                if (d11 == 0.0) {
                                    l3 = humanResource.getOvertimeWork(dateArray[i], dateArray[i + 1]);
                                    if (l3 != 0L) {
                                        bl5 = true;
                                    }
                                } else {
                                    bl5 = true;
                                }
                                if (!bl5) break;
                                this.displayCost(d11, d, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                            }
                        }
                        continue;
                    }
                    switch (list.get(n7)) {
                        case 9: {
                            double d16 = ((Resource)uniqueId).getActualCost(dateArray[i], dateArray[i + 1]);
                            if (d16 == -1.0) continue block29;
                            this.displayCost(d16, d, n8, Color.BLACK, font.deriveFont(1));
                            continue block29;
                        }
                        case 10: {
                            double d17 = ((Resource)uniqueId).getRemainingCost(dateArray[i], dateArray[i + 1]);
                            if (d17 == -1.0) continue block29;
                            this.displayCost(d17, d, n8, Color.BLACK, font.deriveFont(1));
                            continue block29;
                        }
                        case 11: {
                            double d18 = ((Resource)uniqueId).getCost(dateArray[i], dateArray[i + 1]);
                            if (d18 == -1.0) continue block29;
                            this.displayCost(d18, d, n8, Color.BLACK, font.deriveFont(1));
                            continue block29;
                        }
                        case 12: {
                            continue block29;
                        }
                    }
                }
            }
        }
    }
}

