/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.Period;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.renderer.TimeScaleRendererCombination;
import com.sbs.util.SystemUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class BackgroundManager {
    protected boolean calendaristic;
    protected TimeScaleManager timeScaleManager;
    protected Task project;
    protected GraphicPrimitiveContainer graphicPrimitiveContainer;
    private Calendar calendar;
    protected JTreeTable treeTable;

    public BackgroundManager(JTreeTable jTreeTable, TimeScaleManager timeScaleManager) {
        this.timeScaleManager = timeScaleManager;
        this.treeTable = jTreeTable;
        this.graphicPrimitiveContainer = new GraphicPrimitiveContainer();
        this.calendar = Calendar.getInstance();
    }

    public void setProject(Task task) {
        this.project = task;
    }

    protected void render(TimeFrame timeFrame, int n) {
        GraphicPrimitiveContainer.Line line;
        int n2;
        Object object;
        this.graphicPrimitiveContainer.clear();
        TimeScaleRendererCombination timeScaleRendererCombination = this.timeScaleManager.getCurrentScaleCombination();
        long l = timeScaleRendererCombination.getApproximateUnitDuration();
        UIManager uIManager = UIManager.getInstance();
        this.renderHorizontalLines(timeFrame);
        if (uIManager.isShowNonWorking()) {
            if (this.calendaristic) {
                this.renderCalendaristic(timeFrame, n);
            } else if (l < 86400000L) {
                this.renderCalendaristic(timeFrame, n);
            } else {
                this.renderConventional(timeFrame, n);
            }
        }
        double d = timeFrame.getStartDate().getTime();
        double d2 = this.timeScaleManager.getPixelDuration();
        if (timeScaleRendererCombination.getNextBottomRenderer() != null) {
            object = timeScaleRendererCombination.getNextBottomRenderer().getTimeUnits(timeFrame);
            for (n2 = 1; n2 < ((Date[])object).length - 1; ++n2) {
                double d3 = this.timeScaleManager.getX(object[n2].getTime());
                GraphicPrimitiveContainer.Line line2 = this.graphicPrimitiveContainer.createLine(d3, 0.0, d3, n);
                line2.setStyle(PrimitiveStyle.UNIT_DELIMITER);
            }
        }
        this.renderVerticalLines(timeFrame, n);
        if (uIManager.isShowSelection()) {
            this.renderSelection(timeFrame);
        }
        object = this.project.getUsedCalendar();
        int n3 = n2 = !this.calendaristic && l >= 86400000L ? 1 : 0;
        if (uIManager.isShowCurrentDate()) {
            this.calendar.setTimeInMillis(System.currentTimeMillis());
            long l2 = System.currentTimeMillis();
            double d4 = ((double)l2 - d) / d2;
            line = this.graphicPrimitiveContainer.createLine(d4, 0.0, d4, n);
            line.setStyle(PrimitiveStyle.CURRENT_DATE);
        }
        if (this.project != null) {
            if (uIManager.isShowProjectEstimatedStart()) {
                this.calendar.setTime(this.project.getConstraint().getDate());
                long l3 = this.project.getConstraint().getDate().getTime();
                if (n2 != 0) {
                    ((CalendarManager)object).getFirstTime(this.calendar, true, true, Long.MAX_VALUE);
                    if (this.calendar.getTimeInMillis() >= l3) {
                        l3 = this.getConventionalDate(l3, true, (CalendarManager)object);
                    }
                }
                double d5 = ((double)l3 - d) / d2;
                line = this.graphicPrimitiveContainer.createLine(d5, 0.0, d5, n);
                line.setStyle(PrimitiveStyle.PROJECT_ESTIMATED_START_DATE);
            }
            if (uIManager.isShowProjectStart()) {
                this.calendar.setTime(this.project.getStartDate());
                long l4 = this.project.getStartDate().getTime();
                if (n2 != 0) {
                    ((CalendarManager)object).getFirstTime(this.calendar, true, true, Long.MAX_VALUE);
                    if (this.calendar.getTimeInMillis() >= l4) {
                        l4 = this.getConventionalDate(l4, true, (CalendarManager)object);
                    }
                }
                double d6 = ((double)l4 - d) / d2;
                line = this.graphicPrimitiveContainer.createLine(d6, 0.0, d6, n);
                line.setStyle(PrimitiveStyle.PROJECT_START_DATE);
            }
            if (uIManager.isShowProjectFinish()) {
                long l5 = this.project.getEndDate().getTime();
                if (n2 != 0) {
                    l5 = this.getConventionalDate(l5, false, (CalendarManager)object);
                }
                double d7 = (int)(((double)l5 - d) / d2);
                line = this.graphicPrimitiveContainer.createLine(d7, 0.0, d7, n);
                line.setStyle(PrimitiveStyle.PROJECT_END_DATE);
            }
        }
    }

    protected GraphicPrimitiveContainer.Line createLine(double d, double d2, double d3, double d4, boolean bl) {
        GraphicPrimitiveContainer.Line line = this.graphicPrimitiveContainer.createLine(d, d2, d3, d4, bl);
        return line;
    }

    protected void renderSelection(TimeFrame timeFrame) {
        int[] nArray = this.treeTable.getSelectedRows();
        int n = this.treeTable.getRowHeight();
        long l = timeFrame.getStartDate().getTime();
        long l2 = timeFrame.getEndDate().getTime();
        double d = this.timeScaleManager.getX(l);
        double d2 = this.timeScaleManager.getX(l2);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i] * n;
            GraphicPrimitiveContainer.Rectangle rectangle = this.graphicPrimitiveContainer.createRectangle(d, n2, d2 - d, n);
            rectangle.setBackgroundColor(new Color(226, 229, 237, 125));
        }
    }

    protected void renderHorizontalLines(TimeFrame timeFrame) {
        int n = this.treeTable.getRowCount();
        int n2 = this.treeTable.getRowHeight();
        long l = timeFrame.getStartDate().getTime();
        long l2 = timeFrame.getEndDate().getTime();
        double d = this.timeScaleManager.getX(l);
        double d2 = this.timeScaleManager.getX(l2);
        Color color = javax.swing.UIManager.getColor("UIColorHighlighter.stripingBackground");
        if (color == null) {
            color = Color.WHITE;
        }
        for (int i = 1; i <= n; ++i) {
            int n3 = i * n2 - 1;
            if (SystemUtilities.isOSMac()) {
                GraphicPrimitiveContainer.Rectangle rectangle = this.graphicPrimitiveContainer.createRectangle(d, n3 - n2, d2 - d, n2);
                rectangle.setBackgroundColor((i - 1) % 2 == 0 ? color : Color.WHITE);
                continue;
            }
            this.createLine(d, n3, d2, n3, false);
        }
    }

    protected void renderVerticalLines(TimeFrame timeFrame, int n) {
        int n2 = this.treeTable.getRowCount();
        int n3 = this.treeTable.getRowHeight();
        Date[] dateArray = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getExtendedTimeUnits(timeFrame);
        for (int i = 0; i < dateArray.length - 1; ++i) {
            long l = dateArray[i].getTime();
            double d = this.timeScaleManager.getX(l);
            this.createLine(d, 0.0, d, n2 * n3, false);
        }
    }

    private long getConventionalDate(long l, boolean bl, CalendarManager calendarManager) {
        long l2;
        long l3;
        this.calendar.setTimeInMillis(l);
        if (bl) {
            l3 = CalendarManager.getDayStartTime(this.calendar);
            l2 = calendarManager.getDuration(new Date(l3), new Date(l), true);
        } else {
            this.calendar.add(5, 1);
            l3 = CalendarManager.getDayStartTime(this.calendar);
            l2 = calendarManager.getDuration(new Date(l), new Date(l3), true);
        }
        if (l2 == 0L) {
            return l3;
        }
        return l;
    }

    protected void renderConventional(TimeFrame timeFrame, int n) {
        CalendarManager calendarManager = this.project == null ? CalendarManager.STANDARD_CALENDAR : this.project.getUsedCalendar();
        TimeScaleRendererCombination timeScaleRendererCombination = this.timeScaleManager.getCurrentScaleCombination();
        Date[] dateArray = timeScaleRendererCombination.getBottomRenderer().getExtendedTimeUnits(timeFrame);
        for (int i = 0; i < dateArray.length - 1; ++i) {
            this.calendar.setTime(dateArray[i]);
            calendarManager.getFirstTime(this.calendar, true, Long.MAX_VALUE);
            if (this.calendar.getTime().before(dateArray[i + 1])) continue;
            double d = this.timeScaleManager.getX(dateArray[i].getTime());
            double d2 = this.timeScaleManager.getX(dateArray[i + 1].getTime());
            GraphicPrimitiveContainer.Rectangle rectangle = this.graphicPrimitiveContainer.createRectangle(d, 0.0, d2 - d, n);
            rectangle.setStyle(PrimitiveStyle.PERIOD);
        }
    }

    protected void renderCalendaristic(TimeFrame timeFrame, int n) {
        TimeScaleRendererCombination timeScaleRendererCombination = this.timeScaleManager.getCurrentScaleCombination();
        CalendarManager calendarManager = this.project == null ? CalendarManager.STANDARD_CALENDAR : this.project.getUsedCalendar();
        long l = timeScaleRendererCombination.getApproximateUnitDuration();
        long l2 = l / 3L;
        Date date = new Date(timeFrame.getStartDate().getTime() - l);
        Date date2 = new Date(timeFrame.getEndDate().getTime() + l);
        List list = calendarManager.getPeriods(date, date2, l2, false);
        for (Period period : list) {
            double d = this.timeScaleManager.getX(period.getStartPeriod());
            double d2 = this.timeScaleManager.getX(period.getEndPeriod());
            GraphicPrimitiveContainer.Rectangle rectangle = this.graphicPrimitiveContainer.createRectangle(d, 0.0, d2 - d, n);
            rectangle.setStyle(PrimitiveStyle.PERIOD);
        }
    }

    public void paint(Painter painter, Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        TimeFrame timeFrame = new TimeFrame(new Date(this.timeScaleManager.getMilis(rectangle.x)), new Date(this.timeScaleManager.getMilis(rectangle.x + rectangle.width)));
        this.render(timeFrame, n);
        this.graphicPrimitiveContainer.paint(painter, graphics);
    }

    public void setCalendaristic(boolean bl) {
        this.calendaristic = bl;
    }

    public boolean isCalendaristic() {
        return this.calendaristic;
    }

    public void setTimeScaleManager(TimeScaleManager timeScaleManager) {
        this.timeScaleManager = timeScaleManager;
    }
}

