/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.mouse;

import com.sbs.jpm.ui.treetablechart.JChartArea;
import com.sbs.jpm.ui.treetablechart.mouse.ChartArea;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteraction;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteractionListener;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public abstract class MouseDispatcher
extends MouseInputAdapter
implements MouseInteractionListener {
    protected JChartArea area;
    protected ChartArea chartArea;
    protected final Cursor RESIZE_CURSOR = new Cursor(10);
    protected final Cursor HAND_CURSOR = new Cursor(12);
    protected MouseInteraction currentMouseInteraction;

    public MouseDispatcher(JChartArea jChartArea) {
        this.area = jChartArea;
        this.chartArea = this.createChartArea();
    }

    protected abstract ChartArea createChartArea();

    public void startMouseInteraction(MouseInteraction mouseInteraction) {
        this.currentMouseInteraction = mouseInteraction;
    }

    public void endMouseInteraction(MouseInteraction mouseInteraction) {
        this.currentMouseInteraction = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.chartArea.mouseMoved(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.chartArea.mousePressed(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.currentMouseInteraction != null) {
            this.currentMouseInteraction.mouseDragged(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.currentMouseInteraction != null) {
            this.currentMouseInteraction.mouseReleased(mouseEvent);
        }
        this.chartArea.mouseReleased(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.chartArea.mouseClicked(mouseEvent);
    }

    public ChartArea getChartArea() {
        return this.chartArea;
    }

    public MouseInteraction getCurrentMouseInteraction() {
        return this.currentMouseInteraction;
    }
}

